/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DataInputOutputUtils {
    public static int[] readIntArray(DataInput in2) throws IOException {
        int len = in2.readInt();
        int[] values = new int[len];
        for (int i10 = 0; i10 < len; ++i10) {
            values[i10] = in2.readInt();
        }
        return values;
    }

    public static void writeIntArray(DataOutput out, int[] values) throws IOException {
        out.writeInt(values.length);
        for (int value : values) {
            out.writeInt(value);
        }
    }

    public static float[] readFloatArray(DataInput in2) throws IOException {
        int len = in2.readInt();
        float[] values = new float[len];
        for (int i10 = 0; i10 < len; ++i10) {
            values[i10] = in2.readFloat();
        }
        return values;
    }

    public static void writeFloatArray(DataOutput out, float[] values) throws IOException {
        out.writeInt(values.length);
        for (float value : values) {
            out.writeFloat(value);
        }
    }

    public static List<TensorInfo> readTensorInfoList(DataInput in2) throws IOException {
        ArrayList<TensorInfo> tensorInfoList = new ArrayList<TensorInfo>();
        int len = in2.readInt();
        for (int i10 = 0; i10 < len; ++i10) {
            tensorInfoList.add(new TensorInfo(in2));
        }
        return tensorInfoList;
    }

    public static void writeTensorInfoList(DataOutput out, List<TensorInfo> tensorInfoList) throws IOException {
        out.writeInt(tensorInfoList.size());
        for (TensorInfo tensorInfo : tensorInfoList) {
            tensorInfo.save(out);
        }
    }

    public static List<TensorGroupInfo> readTensorGroupInfoList(DataInput in2) throws IOException {
        ArrayList<TensorGroupInfo> tensorGroupInfoList = new ArrayList<TensorGroupInfo>();
        int len = in2.readInt();
        for (int i10 = 0; i10 < len; ++i10) {
            tensorGroupInfoList.add(new TensorGroupInfo(in2));
        }
        return tensorGroupInfoList;
    }

    public static void writeTensorGroupInfoList(DataOutput out, List<TensorGroupInfo> tensorInfoList) throws IOException {
        out.writeInt(tensorInfoList.size());
        for (TensorGroupInfo tensorGroupInfo : tensorInfoList) {
            tensorGroupInfo.save(out);
        }
    }
}

