/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.Utf8;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;

public class Table {
    protected int bb_pos;
    protected ByteBuffer bb;
    private int vtable_start;
    private int vtable_size;
    Utf8 utf8 = Utf8.getDefault();

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }

    protected int __offset(int vtable_offset) {
        return vtable_offset < this.vtable_size ? (int)this.bb.getShort(this.vtable_start + vtable_offset) : 0;
    }

    protected static int __offset(int vtable_offset, int offset, ByteBuffer bb2) {
        int vtable = bb2.capacity() - offset;
        return bb2.getShort(vtable + vtable_offset - bb2.getInt(vtable)) + vtable;
    }

    protected int __indirect(int offset) {
        return offset + this.bb.getInt(offset);
    }

    protected static int __indirect(int offset, ByteBuffer bb2) {
        return offset + bb2.getInt(offset);
    }

    protected String __string(int offset) {
        return Table.__string(offset, this.bb, this.utf8);
    }

    protected static String __string(int offset, ByteBuffer bb2, Utf8 utf8) {
        offset += bb2.getInt(offset);
        int length = bb2.getInt(offset);
        return utf8.decodeUtf8(bb2, offset + 4, length);
    }

    protected int __vector_len(int offset) {
        offset += this.bb_pos;
        offset += this.bb.getInt(offset);
        return this.bb.getInt(offset);
    }

    protected int __vector(int offset) {
        return (offset += this.bb_pos) + this.bb.getInt(offset) + 4;
    }

    protected ByteBuffer __vector_as_bytebuffer(int vector_offset, int elem_size) {
        int o10 = this.__offset(vector_offset);
        if (o10 == 0) {
            return null;
        }
        ByteBuffer bb2 = this.bb.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int vectorstart = this.__vector(o10);
        bb2.position(vectorstart);
        bb2.limit(vectorstart + this.__vector_len(o10) * elem_size);
        return bb2;
    }

    protected ByteBuffer __vector_in_bytebuffer(ByteBuffer bb2, int vector_offset, int elem_size) {
        int o10 = this.__offset(vector_offset);
        if (o10 == 0) {
            return null;
        }
        int vectorstart = this.__vector(o10);
        bb2.rewind();
        bb2.limit(vectorstart + this.__vector_len(o10) * elem_size);
        bb2.position(vectorstart);
        return bb2;
    }

    protected Table __union(Table t10, int offset) {
        return Table.__union(t10, offset, this.bb);
    }

    protected static Table __union(Table t10, int offset, ByteBuffer bb2) {
        t10.__reset(Table.__indirect(offset, bb2), bb2);
        return t10;
    }

    protected static boolean __has_identifier(ByteBuffer bb2, String ident) {
        if (ident.length() != 4) {
            throw new AssertionError((Object)"FlatBuffers: file identifier must be length 4");
        }
        for (int i10 = 0; i10 < 4; ++i10) {
            if (ident.charAt(i10) == (char)bb2.get(bb2.position() + 4 + i10)) continue;
            return false;
        }
        return true;
    }

    protected void sortTables(int[] offsets, final ByteBuffer bb2) {
        int i10;
        Integer[] off = new Integer[offsets.length];
        for (i10 = 0; i10 < offsets.length; ++i10) {
            off[i10] = offsets[i10];
        }
        Arrays.sort(off, new Comparator<Integer>(){

            @Override
            public int compare(Integer o12, Integer o22) {
                return Table.this.keysCompare(o12, o22, bb2);
            }
        });
        for (i10 = 0; i10 < offsets.length; ++i10) {
            offsets[i10] = off[i10];
        }
    }

    protected int keysCompare(Integer o12, Integer o22, ByteBuffer bb2) {
        return 0;
    }

    protected static int compareStrings(int offset_1, int offset_2, ByteBuffer bb2) {
        offset_1 += bb2.getInt(offset_1);
        offset_2 += bb2.getInt(offset_2);
        int len_1 = bb2.getInt(offset_1);
        int len_2 = bb2.getInt(offset_2);
        int startPos_1 = offset_1 + 4;
        int startPos_2 = offset_2 + 4;
        int len = Math.min(len_1, len_2);
        for (int i10 = 0; i10 < len; ++i10) {
            if (bb2.get(i10 + startPos_1) == bb2.get(i10 + startPos_2)) continue;
            return bb2.get(i10 + startPos_1) - bb2.get(i10 + startPos_2);
        }
        return len_1 - len_2;
    }

    protected static int compareStrings(int offset_1, byte[] key, ByteBuffer bb2) {
        offset_1 += bb2.getInt(offset_1);
        int len_1 = bb2.getInt(offset_1);
        int len_2 = key.length;
        int startPos_1 = offset_1 + 4;
        int len = Math.min(len_1, len_2);
        for (int i10 = 0; i10 < len; ++i10) {
            if (bb2.get(i10 + startPos_1) == key[i10]) continue;
            return bb2.get(i10 + startPos_1) - key[i10];
        }
        return len_1 - len_2;
    }

    protected void __reset(int _i, ByteBuffer _bb) {
        this.bb = _bb;
        if (this.bb != null) {
            this.bb_pos = _i;
            this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
            this.vtable_size = this.bb.getShort(this.vtable_start);
        } else {
            this.bb_pos = 0;
            this.vtable_start = 0;
            this.vtable_size = 0;
        }
    }

    public void __reset() {
        this.__reset(0, null);
    }
}

