/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.Utf8;
import java.nio.ByteBuffer;

public final class Utf8Safe
extends Utf8 {
    private static int computeEncodedLength(CharSequence sequence) {
        int i10;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i10 = 0; i10 < utf16Length && sequence.charAt(i10) < '\u0080'; ++i10) {
        }
        while (i10 < utf16Length) {
            char c10 = sequence.charAt(i10);
            if (c10 < '\u0800') {
                utf8Length += 127 - c10 >>> 31;
            } else {
                utf8Length += Utf8Safe.encodedLengthGeneral(sequence, i10);
                break;
            }
            ++i10;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i10 = start; i10 < utf16Length; ++i10) {
            char c10 = sequence.charAt(i10);
            if (c10 < '\u0800') {
                utf8Length += 127 - c10 >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c10 || c10 > '\udfff') continue;
            int cp2 = Character.codePointAt(sequence, i10);
            if (cp2 < 65536) {
                throw new UnpairedSurrogateException(i10, utf16Length);
            }
            ++i10;
        }
        return utf8Length;
    }

    public static String decodeUtf8Array(byte[] bytes, int index, int size) {
        byte b10;
        int offset;
        if ((index | size | bytes.length - index - size) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
        }
        int limit = offset + size;
        char[] resultArr = new char[size];
        int resultPos = 0;
        for (offset = index; offset < limit && Utf8.DecodeUtil.isOneByte(b10 = bytes[offset]); ++offset) {
            Utf8.DecodeUtil.handleOneByte(b10, resultArr, resultPos++);
        }
        while (offset < limit) {
            byte byte1;
            if (Utf8.DecodeUtil.isOneByte(byte1 = bytes[offset++])) {
                byte b11;
                Utf8.DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                while (offset < limit && Utf8.DecodeUtil.isOneByte(b11 = bytes[offset])) {
                    ++offset;
                    Utf8.DecodeUtil.handleOneByte(b11, resultArr, resultPos++);
                }
                continue;
            }
            if (Utf8.DecodeUtil.isTwoBytes(byte1)) {
                if (offset >= limit) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleTwoBytes(byte1, bytes[offset++], resultArr, resultPos++);
                continue;
            }
            if (Utf8.DecodeUtil.isThreeBytes(byte1)) {
                if (offset >= limit - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleThreeBytes(byte1, bytes[offset++], bytes[offset++], resultArr, resultPos++);
                continue;
            }
            if (offset >= limit - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.DecodeUtil.handleFourBytes(byte1, bytes[offset++], bytes[offset++], bytes[offset++], resultArr, resultPos++);
            ++resultPos;
        }
        return new String(resultArr, 0, resultPos);
    }

    public static String decodeUtf8Buffer(ByteBuffer buffer, int offset, int length) {
        byte b10;
        if ((offset | length | buffer.limit() - offset - length) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), offset, length));
        }
        int limit = offset + length;
        char[] resultArr = new char[length];
        int resultPos = 0;
        while (offset < limit && Utf8.DecodeUtil.isOneByte(b10 = buffer.get(offset))) {
            ++offset;
            Utf8.DecodeUtil.handleOneByte(b10, resultArr, resultPos++);
        }
        while (offset < limit) {
            byte byte1;
            if (Utf8.DecodeUtil.isOneByte(byte1 = buffer.get(offset++))) {
                byte b11;
                Utf8.DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                while (offset < limit && Utf8.DecodeUtil.isOneByte(b11 = buffer.get(offset))) {
                    ++offset;
                    Utf8.DecodeUtil.handleOneByte(b11, resultArr, resultPos++);
                }
                continue;
            }
            if (Utf8.DecodeUtil.isTwoBytes(byte1)) {
                if (offset >= limit) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleTwoBytes(byte1, buffer.get(offset++), resultArr, resultPos++);
                continue;
            }
            if (Utf8.DecodeUtil.isThreeBytes(byte1)) {
                if (offset >= limit - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleThreeBytes(byte1, buffer.get(offset++), buffer.get(offset++), resultArr, resultPos++);
                continue;
            }
            if (offset >= limit - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.DecodeUtil.handleFourBytes(byte1, buffer.get(offset++), buffer.get(offset++), buffer.get(offset++), resultArr, resultPos++);
            ++resultPos;
        }
        return new String(resultArr, 0, resultPos);
    }

    @Override
    public int encodedLength(CharSequence in2) {
        return Utf8Safe.computeEncodedLength(in2);
    }

    @Override
    public String decodeUtf8(ByteBuffer buffer, int offset, int length) throws IllegalArgumentException {
        if (buffer.hasArray()) {
            return Utf8Safe.decodeUtf8Array(buffer.array(), buffer.arrayOffset() + offset, length);
        }
        return Utf8Safe.decodeUtf8Buffer(buffer, offset, length);
    }

    private static void encodeUtf8Buffer(CharSequence in2, ByteBuffer out) {
        int inIx;
        int inLength = in2.length();
        int outIx = out.position();
        try {
            char c10;
            for (inIx = 0; inIx < inLength && (c10 = in2.charAt(inIx)) < '\u0080'; ++inIx) {
                out.put(outIx + inIx, (byte)c10);
            }
            if (inIx == inLength) {
                out.position(outIx + inIx);
                return;
            }
            outIx += inIx;
            while (inIx < inLength) {
                c10 = in2.charAt(inIx);
                if (c10 < '\u0080') {
                    out.put(outIx, (byte)c10);
                } else if (c10 < '\u0800') {
                    out.put(outIx++, (byte)(0xC0 | c10 >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & c10));
                } else if (c10 < '\ud800' || '\udfff' < c10) {
                    out.put(outIx++, (byte)(0xE0 | c10 >>> 12));
                    out.put(outIx++, (byte)(0x80 | 0x3F & c10 >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & c10));
                } else {
                    char low;
                    if (inIx + 1 == inLength || !Character.isSurrogatePair(c10, low = in2.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx, inLength);
                    }
                    int codePoint = Character.toCodePoint(c10, low);
                    out.put(outIx++, (byte)(0xF0 | codePoint >>> 18));
                    out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    out.put(outIx, (byte)(0x80 | 0x3F & codePoint));
                }
                ++inIx;
                ++outIx;
            }
            out.position(outIx);
        }
        catch (IndexOutOfBoundsException e10) {
            int badWriteIndex = out.position() + Math.max(inIx, outIx - out.position() + 1);
            throw new ArrayIndexOutOfBoundsException("Failed writing " + in2.charAt(inIx) + " at index " + badWriteIndex);
        }
    }

    private static int encodeUtf8Array(CharSequence in2, byte[] out, int offset, int length) {
        char c10;
        int i10;
        int utf16Length = in2.length();
        int j10 = offset;
        int limit = offset + length;
        for (i10 = 0; i10 < utf16Length && i10 + j10 < limit && (c10 = in2.charAt(i10)) < '\u0080'; ++i10) {
            out[j10 + i10] = (byte)c10;
        }
        if (i10 == utf16Length) {
            return j10 + utf16Length;
        }
        j10 += i10;
        while (i10 < utf16Length) {
            c10 = in2.charAt(i10);
            if (c10 < '\u0080' && j10 < limit) {
                out[j10++] = (byte)c10;
            } else if (c10 < '\u0800' && j10 <= limit - 2) {
                out[j10++] = (byte)(0x3C0 | c10 >>> 6);
                out[j10++] = (byte)(0x80 | 0x3F & c10);
            } else if ((c10 < '\ud800' || '\udfff' < c10) && j10 <= limit - 3) {
                out[j10++] = (byte)(0x1E0 | c10 >>> 12);
                out[j10++] = (byte)(0x80 | 0x3F & c10 >>> 6);
                out[j10++] = (byte)(0x80 | 0x3F & c10);
            } else if (j10 <= limit - 4) {
                char low;
                if (i10 + 1 == in2.length() || !Character.isSurrogatePair(c10, low = in2.charAt(++i10))) {
                    throw new UnpairedSurrogateException(i10 - 1, utf16Length);
                }
                int codePoint = Character.toCodePoint(c10, low);
                out[j10++] = (byte)(0xF0 | codePoint >>> 18);
                out[j10++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                out[j10++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                out[j10++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                if (!('\ud800' > c10 || c10 > '\udfff' || i10 + 1 != in2.length() && Character.isSurrogatePair(c10, in2.charAt(i10 + 1)))) {
                    throw new UnpairedSurrogateException(i10, utf16Length);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c10 + " at index " + j10);
            }
            ++i10;
        }
        return j10;
    }

    @Override
    public void encodeUtf8(CharSequence in2, ByteBuffer out) {
        if (out.hasArray()) {
            int start = out.arrayOffset();
            int end = Utf8Safe.encodeUtf8Array(in2, out.array(), start + out.position(), out.remaining());
            out.position(end - start);
        } else {
            Utf8Safe.encodeUtf8Buffer(in2, out);
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + index + " of " + length);
        }
    }
}

