/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.actions;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMLSearchSession;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMlSearchState;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMlSessionService;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereTabWithMl;
import com.intellij.ide.actions.searcheverywhere.ml.id.SearchEverywhereMlItemIdProvider;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createNewJsonScratchFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/ide/scratch/ScratchFileCreationHelper$Context;", "createScratchFileContext", "json", "", "getFeaturesReport", "", "", "searchEverywhereUI", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereUI;", "isTabWithMl", "", "tabId", "openScratchFile", "file", "shouldActionBeEnabled", "update", "Companion", "ElementFeatures", "intellij.searchEverywhereMl"})
public final class OpenFeaturesInScratchFileAction
extends AnAction {
    private static final String SHOULD_ORDER_BY_ML_KEY = "shouldOrderByMl";
    private static final String CONTEXT_INFO_KEY = "contextInfo";
    private static final String FOUND_ELEMENTS_KEY = "foundElements";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(this.shouldActionBeEnabled(e));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldActionBeEnabled(AnActionEvent e) {
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance((Project)e.getProject());
        SearchEverywhereMLSearchSession session = SearchEverywhereMlSessionService.Companion.getService().getCurrentSession();
        if (e.getProject() == null) return false;
        SearchEverywhereManager searchEverywhereManager = seManager;
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereManager, (String)"seManager");
        if (!searchEverywhereManager.isShown()) return false;
        if (session == null) return false;
        if (session.getCurrentSearchState() == null) return false;
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String json;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SearchEverywhereManager searchEverywhereManager = SearchEverywhereManager.getInstance((Project)e.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereManager, (String)"SearchEverywhereManager.getInstance(e.project)");
        SearchEverywhereUI searchEverywhereUI = searchEverywhereManager.getCurrentlyShownUI();
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereUI, (String)"SearchEverywhereManager.\u2026project).currentlyShownUI");
        SearchEverywhereUI searchEverywhereUI2 = searchEverywhereUI;
        Map<String, Object> report = this.getFeaturesReport(searchEverywhereUI2);
        String string = json = ExtensionsKt.jacksonObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(report);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json");
        ScratchFileCreationHelper.Context context = this.createScratchFileContext(string);
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project!!");
        VirtualFile scratchFile = this.createNewJsonScratchFile(project2, context);
        Project project3 = e.getProject();
        Intrinsics.checkNotNull((Object)project3);
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"e.project!!");
        this.openScratchFile(scratchFile, project3);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getFeaturesReport(SearchEverywhereUI searchEverywhereUI) {
        void $this$mapTo$iv$iv;
        SearchEverywhereMlSessionService mlSessionService = SearchEverywhereMlSessionService.Companion.getService();
        SearchEverywhereMLSearchSession searchEverywhereMLSearchSession = mlSessionService.getCurrentSession();
        Intrinsics.checkNotNull((Object)searchEverywhereMLSearchSession);
        SearchEverywhereMLSearchSession searchSession = searchEverywhereMLSearchSession;
        List list = searchEverywhereUI.getFoundElementsInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"searchEverywhereUI.foundElementsInfo");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ElementFeatures elementFeatures;
            String contributor;
            String elementName;
            void info;
            SearchEverywhereFoundElementInfo searchEverywhereFoundElementInfo = (SearchEverywhereFoundElementInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int rankingWeight = info.priority;
            SearchEverywhereContributor searchEverywhereContributor = info.contributor;
            Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor, (String)"info.contributor");
            Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor.getSearchProviderId(), (String)"info.contributor.searchProviderId");
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.notNullize((String)info.element.toString(), (String)"undefined"), (String)"StringUtil.notNullize(in\u2026.toString(), \"undefined\")");
            SearchEverywhereMlItemIdProvider searchEverywhereMlItemIdProvider = searchSession.getItemIdProvider();
            Object object = info.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"info.element");
            if (searchEverywhereMlItemIdProvider.isElementSupported(object)) {
                SearchEverywhereMlSearchState state;
                Double d;
                SearchEverywhereMlItemIdProvider searchEverywhereMlItemIdProvider2 = searchSession.getItemIdProvider();
                Object object2 = info.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"info.element");
                int id = searchEverywhereMlItemIdProvider2.getId(object2);
                String string = searchEverywhereUI.getSelectedTabID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchEverywhereUI.selectedTabID");
                if (this.isTabWithMl(string)) {
                    SearchEverywhereContributor searchEverywhereContributor2 = info.contributor;
                    Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor2, (String)"info.contributor");
                    Object object3 = info.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"info.element");
                    d = mlSessionService.getMlWeight(searchEverywhereContributor2, object3, rankingWeight);
                } else {
                    d = null;
                }
                Double mlWeight = d;
                SearchEverywhereMlSearchState searchEverywhereMlSearchState = state = searchSession.getCurrentSearchState();
                Intrinsics.checkNotNull((Object)searchEverywhereMlSearchState);
                Object object4 = info.element;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"info.element");
                SearchEverywhereContributor searchEverywhereContributor3 = info.contributor;
                Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor3, (String)"info.contributor");
                elementFeatures = new ElementFeatures(elementName, mlWeight, rankingWeight, contributor, MapsKt.toSortedMap(searchEverywhereMlSearchState.getElementFeatures(id, object4, searchEverywhereContributor3, rankingWeight).getFeatures()));
            } else {
                elementFeatures = new ElementFeatures(elementName, null, rankingWeight, contributor, MapsKt.emptyMap());
            }
            ElementFeatures elementFeatures2 = elementFeatures;
            collection.add(elementFeatures2);
        }
        List features2 = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[3];
        String string = searchEverywhereUI.getSelectedTabID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchEverywhereUI.selectedTabID");
        pairArray[0] = TuplesKt.to((Object)SHOULD_ORDER_BY_ML_KEY, (Object)mlSessionService.shouldOrderByMl(string));
        pairArray[1] = TuplesKt.to((Object)CONTEXT_INFO_KEY, (Object)searchSession.getCachedContextInfo());
        pairArray[2] = TuplesKt.to((Object)FOUND_ELEMENTS_KEY, (Object)features2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isTabWithMl(String tabId) {
        return SearchEverywhereTabWithMl.Companion.findById(tabId) != null;
    }

    private final ScratchFileCreationHelper.Context createScratchFileContext(String json) {
        ScratchFileCreationHelper.Context context;
        ScratchFileCreationHelper.Context $this$apply = context = new ScratchFileCreationHelper.Context();
        boolean bl = false;
        $this$apply.text = json;
        $this$apply.fileExtension = "json";
        $this$apply.createOption = ScratchFileService.Option.create_if_missing;
        return context;
    }

    private final VirtualFile createNewJsonScratchFile(Project project2, ScratchFileCreationHelper.Context context) {
        String fileName = "search-everywhere-features." + context.fileExtension;
        VirtualFile virtualFile = ScratchRootType.getInstance().createScratchFile(project2, fileName, context.language, context.text, context.createOption);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private final void openScratchFile(VirtualFile file, Project project2) {
        FileEditorManager.getInstance((Project)project2).openFile(file, true);
    }

    @JsonPropertyOrder(value={"name", "mlWeight", "rankingWeight", "contributor", "features"})
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0083\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nH\u00c6\u0003JN\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$ElementFeatures;", "", "name", "", "mlWeight", "", "rankingWeight", "", "contributor", "features", "", "(Ljava/lang/String;Ljava/lang/Double;ILjava/lang/String;Ljava/util/Map;)V", "getContributor", "()Ljava/lang/String;", "getFeatures", "()Ljava/util/Map;", "getMlWeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getName", "getRankingWeight", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/Double;ILjava/lang/String;Ljava/util/Map;)Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$ElementFeatures;", "equals", "", "other", "hashCode", "toString", "intellij.searchEverywhereMl"})
    private static final class ElementFeatures {
        @NotNull
        private final String name;
        @Nullable
        private final Double mlWeight;
        private final int rankingWeight;
        @NotNull
        private final String contributor;
        @NotNull
        private final Map<String, Object> features;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Double getMlWeight() {
            return this.mlWeight;
        }

        public final int getRankingWeight() {
            return this.rankingWeight;
        }

        @NotNull
        public final String getContributor() {
            return this.contributor;
        }

        @NotNull
        public final Map<String, Object> getFeatures() {
            return this.features;
        }

        public ElementFeatures(@NotNull String name, @Nullable Double mlWeight, int rankingWeight, @NotNull String contributor, @NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            this.name = name;
            this.mlWeight = mlWeight;
            this.rankingWeight = rankingWeight;
            this.contributor = contributor;
            this.features = features2;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Double component2() {
            return this.mlWeight;
        }

        public final int component3() {
            return this.rankingWeight;
        }

        @NotNull
        public final String component4() {
            return this.contributor;
        }

        @NotNull
        public final Map<String, Object> component5() {
            return this.features;
        }

        @NotNull
        public final ElementFeatures copy(@NotNull String name, @Nullable Double mlWeight, int rankingWeight, @NotNull String contributor, @NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            return new ElementFeatures(name, mlWeight, rankingWeight, contributor, features2);
        }

        public static /* synthetic */ ElementFeatures copy$default(ElementFeatures elementFeatures, String string, Double d, int n, String string2, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = elementFeatures.name;
            }
            if ((n2 & 2) != 0) {
                d = elementFeatures.mlWeight;
            }
            if ((n2 & 4) != 0) {
                n = elementFeatures.rankingWeight;
            }
            if ((n2 & 8) != 0) {
                string2 = elementFeatures.contributor;
            }
            if ((n2 & 0x10) != 0) {
                map = elementFeatures.features;
            }
            return elementFeatures.copy(string, d, n, string2, map);
        }

        @NotNull
        public String toString() {
            return "ElementFeatures(name=" + this.name + ", mlWeight=" + this.mlWeight + ", rankingWeight=" + this.rankingWeight + ", contributor=" + this.contributor + ", features=" + this.features + ")";
        }

        public int hashCode() {
            String string = this.name;
            Double d = this.mlWeight;
            String string2 = this.contributor;
            Map<String, Object> map = this.features;
            return ((((string != null ? string.hashCode() : 0) * 31 + (d != null ? ((Object)d).hashCode() : 0)) * 31 + Integer.hashCode(this.rankingWeight)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ElementFeatures)) break block3;
                    ElementFeatures elementFeatures = (ElementFeatures)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)elementFeatures.name) || !Intrinsics.areEqual((Object)this.mlWeight, (Object)elementFeatures.mlWeight) || this.rankingWeight != elementFeatures.rankingWeight || !Intrinsics.areEqual((Object)this.contributor, (Object)elementFeatures.contributor) || !Intrinsics.areEqual(this.features, elementFeatures.features)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$Companion;", "", "()V", "CONTEXT_INFO_KEY", "", "FOUND_ELEMENTS_KEY", "SHOULD_ORDER_BY_ML_KEY", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

