/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.peer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.peer.PContainerPeer;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\b\u0016\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J0\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/projector/awt/peer/PWindowPeer;", "Lorg/jetbrains/projector/awt/peer/PContainerPeer;", "Ljava/awt/peer/WindowPeer;", "target", "Ljava/awt/Window;", "(Ljava/awt/Window;)V", "dispose", "", "repositionSecurityWarning", "setBounds", "x", "", "y", "width", "height", "op", "setModalBlocked", "blocker", "Ljava/awt/Dialog;", "blocked", "", "setOpacity", "opacity", "", "setOpaque", "isOpaque", "toBack", "toFront", "transferFocusToOwnerWindow", "updateAlwaysOnTopState", "updateFocusableWindowState", "updateIconImages", "updateMinimumSize", "updateWindow", "Companion", "projector-awt"})
public class PWindowPeer
extends PContainerPeer
implements WindowPeer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int HEADER_VISIBLE_HEIGHT_PX = 10;
    @NotNull
    private static final Logger logger;

    public PWindowPeer(@NotNull Window target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(target);
    }

    @Override
    public void toFront() {
        this.getPWindow().toFront();
    }

    @Override
    public void toBack() {
        this.getPWindow().toBack();
    }

    /*
     * WARNING - void declaration
     */
    private final void transferFocusToOwnerWindow() {
        Window targetOwner;
        for (targetOwner = ((Window)this.getPWindow().getTarget()).getOwner(); targetOwner != null && targetOwner.getOwner() != null && !targetOwner.isFocusableWindow(); targetOwner = targetOwner.getOwner()) {
        }
        if (targetOwner == null) {
            Object v0;
            block7: {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = PWindow.Companion.getWindows();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PWindow it = (PWindow)element$iv$iv;
                    boolean bl = false;
                    if (!(it != this.getPWindow())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Window it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    PWindow it = (PWindow)element$iv$iv;
                    boolean bl2 = false;
                    Component component = it.getTarget();
                    if ((component instanceof Window ? (Window)component : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List $this$lastOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    Window p0 = (Window)element$iv;
                    boolean bl = false;
                    if (!p0.isFocusableWindow()) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            targetOwner = v0;
        }
        if (targetOwner != null) {
            PWindow pWindow = PWindow.Companion.getWindow(targetOwner);
            if (pWindow != null) {
                pWindow.transferNativeFocus();
            }
        }
    }

    @Override
    public void dispose() {
        this.transferFocusToOwnerWindow();
        super.dispose();
    }

    @Override
    public void updateAlwaysOnTopState() {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public void setModalBlocked(@NotNull Dialog blocker, boolean blocked) {
        Intrinsics.checkNotNullParameter((Object)blocker, (String)"blocker");
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void updateIconImages() {
        this.getPWindow().updateIcons();
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void repositionSecurityWarning() {
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        super.setBounds(x, y, width, height, op);
        if (this.getPWindow().getUndecorated() || Intrinsics.areEqual((Object)CollectionsKt.first(PWindow.Companion.getWindows()), (Object)this.getPWindow()) || PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
            return;
        }
        Rectangle rectangle = Companion.getVisibleWindowBoundsIfNeeded(x, y, width, height);
        if (rectangle != null) {
            Rectangle it = rectangle;
            boolean bl = false;
            this.getPWindow().getTarget().setBounds(it);
        }
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PWindowPeer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ(\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/awt/peer/PWindowPeer$Companion;", "", "()V", "HEADER_VISIBLE_HEIGHT_PX", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "createVisibleWindowBounds", "Ljava/awt/Rectangle;", "headerVisibleHeightPx", "targetWindowBounds", "screenBounds", "getVisibleWindowBoundsIfNeeded", "x", "y", "width", "height", "isWindowHeaderVisibleEnough", "", "windowBounds", "projector-awt"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Rectangle getVisibleWindowBoundsIfNeeded(int x, int y, int width, int height) {
            Rectangle newBounds = new Rectangle(x, y, width, height);
            Rectangle screenBounds = PGraphicsEnvironment.Companion.getDefaultDevice().getClientScreenBounds();
            if (this.isWindowHeaderVisibleEnough(10, newBounds, screenBounds)) {
                return null;
            }
            Rectangle visibleWindowBounds = this.createVisibleWindowBounds(10, newBounds, screenBounds);
            if (this.isWindowHeaderVisibleEnough(10, visibleWindowBounds, screenBounds)) {
                return visibleWindowBounds;
            }
            Logger.DefaultImpls.error$default(logger, null, (Function0)new Function0<String>(newBounds, screenBounds){
                final /* synthetic */ Rectangle $newBounds;
                final /* synthetic */ Rectangle $screenBounds;
                {
                    this.$newBounds = $newBounds;
                    this.$screenBounds = $screenBounds;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Can't create visible window bounds... (10, " + this.$newBounds + ", " + this.$screenBounds + ")";
                }
            }, 1, null);
            return null;
        }

        public final boolean isWindowHeaderVisibleEnough(int headerVisibleHeightPx, @NotNull Rectangle windowBounds, @NotNull Rectangle screenBounds) {
            Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
            Intrinsics.checkNotNullParameter((Object)screenBounds, (String)"screenBounds");
            Rectangle headerBounds = new Rectangle(windowBounds.x, windowBounds.y - headerVisibleHeightPx, windowBounds.width, headerVisibleHeightPx);
            int n = screenBounds.y;
            int n2 = screenBounds.y + screenBounds.height;
            int n3 = MathKt.roundToInt((double)headerBounds.getCenterY());
            if (!(n <= n3 ? n3 <= n2 : false)) {
                return false;
            }
            n = screenBounds.x;
            n2 = screenBounds.x + screenBounds.width;
            n3 = MathKt.roundToInt((double)headerBounds.getCenterX());
            return n <= n3 ? n3 <= n2 : false;
        }

        @NotNull
        public final Rectangle createVisibleWindowBounds(int headerVisibleHeightPx, @NotNull Rectangle targetWindowBounds, @NotNull Rectangle screenBounds) {
            Intrinsics.checkNotNullParameter((Object)targetWindowBounds, (String)"targetWindowBounds");
            Intrinsics.checkNotNullParameter((Object)screenBounds, (String)"screenBounds");
            Rectangle headerBounds = new Rectangle(targetWindowBounds.x, targetWindowBounds.y - headerVisibleHeightPx, targetWindowBounds.width, headerVisibleHeightPx);
            Rectangle visibleWindowBounds = new Rectangle(targetWindowBounds);
            Point visibleHeaderPoint = new Point(MathKt.roundToInt((double)headerBounds.getCenterX()), MathKt.roundToInt((double)headerBounds.getCenterY()));
            if (visibleHeaderPoint.x > screenBounds.x + screenBounds.width) {
                visibleWindowBounds.x -= visibleHeaderPoint.x - (screenBounds.x + screenBounds.width);
            }
            if (visibleHeaderPoint.y > screenBounds.y + screenBounds.height) {
                visibleWindowBounds.y -= visibleHeaderPoint.y - (screenBounds.y + screenBounds.height);
            }
            if (visibleHeaderPoint.x < screenBounds.x) {
                visibleWindowBounds.x += screenBounds.x - visibleHeaderPoint.x;
            }
            if (visibleHeaderPoint.y < screenBounds.y) {
                visibleWindowBounds.y += screenBounds.y - visibleHeaderPoint.y;
            }
            return visibleWindowBounds;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

