/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.service.DrawEventQueue;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.toClient.ServerCopyAreaEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawLineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawPolylineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawRenderableImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawRenderedImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawStringEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintArcEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintOvalEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPathEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPolygonEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRoundRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetCompositeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetFontEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetPaintEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetTransformEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowPaintEvent;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.core.convert.toClient.ConvertKt;
import org.jetbrains.projector.server.core.util.SizeAware;
import org.jetbrains.projector.server.service.ProjectorDrawEventQueue;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "target", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "(Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;)V", "buildCommand", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "CommandBuilder", "Companion", "projector-server"})
public final class ProjectorDrawEventQueue
implements DrawEventQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerDrawCommandsEvent.Target target;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final SizeAware<ConcurrentLinkedQueue<Pair<ServerDrawCommandsEvent.Target, List<ServerWindowEvent>>>> commands$delegate;

    public ProjectorDrawEventQueue(@NotNull ServerDrawCommandsEvent.Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @Override
    @NotNull
    public DrawEventQueue.CommandBuilder buildCommand() {
        return new CommandBuilder(this.target);
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorDrawEventQueue.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
        commands$delegate = new SizeAware<Collection>(new ConcurrentLinkedQueue(), ProjectorServer.Companion.getENABLE_BIG_COLLECTIONS_CHECKS() ? Integer.valueOf(ProjectorServer.Companion.getBIG_COLLECTIONS_CHECKS_START_SIZE()) : null, logger);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J8\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\"\u0010\u001e\u001a\u00020\u000b2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0!0 H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020\u000bH\u0016J(\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J@\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0016J0\u0010.\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010/\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0016J*\u00102\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0!0 H\u0016J0\u00103\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020'H\u0016J@\u00104\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0016J\u0012\u00107\u001a\u00020\u00012\b\u00108\u001a\u0004\u0018\u000101H\u0016J\u0010\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00012\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020DH\u0016J\u0016\u0010E\u001a\u00020\u00012\f\u0010F\u001a\b\u0012\u0004\u0012\u00020'0 H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006G"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue$CommandBuilder;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "target", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "(Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;)V", "events", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "getTarget", "()Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "build", "", "copyArea", "x", "", "y", "width", "height", "dx", "dy", "drawImage", "imageId", "", "awtImageInfo", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "drawLine", "x1", "y1", "x2", "y2", "drawPolyline", "points", "", "Lkotlin/Pair;", "drawRenderableImage", "drawRenderedImage", "drawString", "string", "", "", "desiredWidth", "paintArc", "paintType", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "startAngle", "arcAngle", "paintOval", "paintPath", "path", "Ljava/awt/Shape;", "paintPolygon", "paintRect", "paintRoundRect", "arcWidth", "arcHeight", "setClip", "identitySpaceClip", "setComposite", "composite", "Ljava/awt/Composite;", "setFont", "font", "Ljava/awt/Font;", "setPaint", "paint", "Ljava/awt/Paint;", "setStroke", "stroke", "Ljava/awt/Stroke;", "setTransform", "tx", "projector-server"})
    private static final class CommandBuilder
    implements DrawEventQueue.CommandBuilder {
        @NotNull
        private final ServerDrawCommandsEvent.Target target;
        @NotNull
        private final List<ServerWindowEvent> events;

        public CommandBuilder(@NotNull ServerDrawCommandsEvent.Target target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.events = new ArrayList();
        }

        @NotNull
        public final ServerDrawCommandsEvent.Target getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setClip(@Nullable Shape identitySpaceClip) {
            this.events.add(ConvertKt.createSetClipEvent(identitySpaceClip));
            return this;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setTransform(@NotNull List<Double> tx) {
            Intrinsics.checkNotNullParameter(tx, (String)"tx");
            this.events.add(new ServerSetTransformEvent(tx));
            return this;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setStroke(@NotNull Stroke stroke) {
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            this.events.add(ConvertKt.toSetStrokeEvent(stroke));
            return this;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setPaint(@NotNull Paint paint) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            this.events.add(new ServerSetPaintEvent(ConvertKt.toPaintValue(paint)));
            return this;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setComposite(@NotNull Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            this.events.add(new ServerSetCompositeEvent(ConvertKt.toCommonComposite(composite)));
            return this;
        }

        @Override
        @NotNull
        public DrawEventQueue.CommandBuilder setFont(@NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Integer n = (Integer)font.getAttributes().get(TextAttribute.LIGATURES);
            this.events.add(new ServerSetFontEvent(FontCacher.INSTANCE.getId(font), font.getSize(), (n == null ? 0 : n) > 0));
            return this;
        }

        private final void build() {
            boolean bl;
            block4: {
                Companion.getCommands().add((Pair<ServerDrawCommandsEvent.Target, List<ServerWindowEvent>>)TuplesKt.to((Object)this.target, this.events));
                Iterable $this$none$iv = CollectionsKt.asReversedMutable(this.events);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ServerWindowEvent it = (ServerWindowEvent)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ServerWindowPaintEvent)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Logger.DefaultImpls.info$default(logger, null, build.2.INSTANCE, 1, null);
            }
        }

        @Override
        public void drawRenderedImage() {
            this.events.add(ServerDrawRenderedImageEvent.INSTANCE);
            this.build();
        }

        @Override
        public void drawRenderableImage() {
            this.events.add(ServerDrawRenderableImageEvent.INSTANCE);
            this.build();
        }

        @Override
        public void drawString(@NotNull String string, double x, double y, double desiredWidth) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.events.add(new ServerDrawStringEvent(string, x, y, desiredWidth));
            this.build();
        }

        @Override
        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            this.events.add(new ServerCopyAreaEvent(x, y, width, height, dx, dy));
            this.build();
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            this.events.add(new ServerDrawLineEvent(x1, y1, x2, y2));
            this.build();
        }

        @Override
        public void paintRect(@NotNull AwtPaintType paintType, double x, double y, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            this.events.add(new ServerPaintRectEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height));
            this.build();
        }

        @Override
        public void paintRoundRect(@NotNull AwtPaintType paintType, int x, int y, int width, int height, int arcWidth, int arcHeight) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            this.events.add(new ServerPaintRoundRectEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height, arcWidth, arcHeight));
            this.build();
        }

        @Override
        public void paintOval(@NotNull AwtPaintType paintType, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            this.events.add(new ServerPaintOvalEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height));
            this.build();
        }

        @Override
        public void paintArc(@NotNull AwtPaintType paintType, int x, int y, int width, int height, int startAngle, int arcAngle) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            this.events.add(new ServerPaintArcEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height, startAngle, arcAngle));
            this.build();
        }

        @Override
        public void drawPolyline(@NotNull List<Pair<Integer, Integer>> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            this.events.add(new ServerDrawPolylineEvent(Companion.toPoints(points2)));
            this.build();
        }

        @Override
        public void paintPolygon(@NotNull AwtPaintType paintType, @NotNull List<Pair<Integer, Integer>> points2) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            this.events.add(new ServerPaintPolygonEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), Companion.toPoints(points2)));
            this.build();
        }

        @Override
        public void drawImage(@NotNull Object imageId, @NotNull AwtImageInfo awtImageInfo) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)awtImageInfo, (String)"awtImageInfo");
            if (!(imageId instanceof ImageId)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.events.add(new ServerDrawImageEvent((ImageId)imageId, org.jetbrains.projector.server.util.ConvertKt.toImageEventInfo(awtImageInfo)));
            this.build();
        }

        @Override
        public void paintPath(@NotNull AwtPaintType paintType, @NotNull Shape path) {
            Intrinsics.checkNotNullParameter((Object)((Object)paintType), (String)"paintType");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.events.add(new ServerPaintPathEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), ConvertKt.toCommonPath(path)));
            this.build();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00050\u0007H\u0002R3\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue$Companion;", "", "()V", "commands", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "getCommands", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "commands$delegate", "Lorg/jetbrains/projector/server/core/util/SizeAware;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "toPoints", "Lorg/jetbrains/projector/common/protocol/data/Point;", "", "projector-server"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Point> toPoints(List<Pair<Integer, Integer>> $this$toPoints) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toPoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$x$y;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int x = ((Number)$dstr$x$y.component1()).intValue();
                int y = ((Number)$dstr$x$y.component2()).intValue();
                collection.add(new Point(x, y));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ConcurrentLinkedQueue<Pair<ServerDrawCommandsEvent.Target, List<ServerWindowEvent>>> getCommands() {
            return (ConcurrentLinkedQueue)commands$delegate.getValue((Object)this, (KProperty)$$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "commands", "getCommands()Ljava/util/concurrent/ConcurrentLinkedQueue;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

