/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.performance;

import com.intellij.completion.ml.performance.CompletionPerformanceTracker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000bJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u00020\rH\u0002J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0019J\u0006\u0010\u001a\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ'\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010\"R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/completion/ml/performance/CompletionPerformanceTracker;", "", "()V", "elementProvidersMeasurer", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/LongAdder;", "measures", "sortingCount", "", "totalMlContribution", "", "addByKey", "", "key", "value", "contextFeaturesCalculated", "providerName", "timeSpent", "eventLogged", "eventType", "flushElementProvidersContribution", "itemsScored", "itemsCount", "measurements", "", "reorderedByML", "sortingPerformed", "totalTime", "totalMLTimeContribution", "trackElementFeaturesCalculation", "T", "compute", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.completionMlRanking"})
public final class CompletionPerformanceTracker {
    private int sortingCount;
    private final ConcurrentHashMap<String, LongAdder> measures = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LongAdder> elementProvidersMeasurer = new ConcurrentHashMap();
    private long totalMlContribution;

    public final long totalMLTimeContribution() {
        return this.totalMlContribution;
    }

    public final void sortingPerformed(int itemsCount, long totalTime) {
        this.addByKey("sorting.items." + this.sortingCount, itemsCount);
        this.addByKey("sorting.time." + this.sortingCount, totalTime);
        this.totalMlContribution += totalTime;
        ++this.sortingCount;
    }

    public final void eventLogged(@NotNull String eventType, long timeSpent) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        this.addByKey("log." + eventType, timeSpent);
        this.addByKey("log.total", timeSpent);
    }

    public final void contextFeaturesCalculated(@NotNull String providerName, long timeSpent) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        this.addByKey("context.features." + providerName, timeSpent);
    }

    public final void itemsScored(int itemsCount, long timeSpent) {
        this.addByKey("model.items." + this.sortingCount, itemsCount);
        this.addByKey("model.time." + this.sortingCount, timeSpent);
    }

    public final void reorderedByML() {
        this.addByKey("reordered.by.ml", 1L);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Long> measurements() {
        void $this$mapValuesTo$iv$iv;
        this.flushElementProvidersContribution();
        Map $this$mapValues$iv = this.measures;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Long l = ((LongAdder)it.getValue()).longValue();
            map3.put(k2, l);
        }
        return destination$iv$iv;
    }

    public final <T> T trackElementFeaturesCalculation(@NotNull String providerName, @NotNull Function0<? extends T> compute2) {
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        Intrinsics.checkNotNullParameter(compute2, (String)"compute");
        long started = System.nanoTime();
        Object result = compute2.invoke();
        this.elementProvidersMeasurer.computeIfAbsent(providerName, trackElementFeaturesCalculation.1.INSTANCE).add(System.nanoTime() - started);
        return (T)result;
    }

    private final void flushElementProvidersContribution() {
        Map $this$forEach$iv = this.elementProvidersMeasurer;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.addByKey("element.features." + (String)it.getKey(), TimeUnit.NANOSECONDS.toMillis(((LongAdder)it.getValue()).longValue()));
        }
        this.elementProvidersMeasurer.clear();
    }

    private final void addByKey(String key, long value) {
        if (value != 0L) {
            this.measures.computeIfAbsent(key, addByKey.1.INSTANCE).add(value);
        }
    }
}

