/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/ConstructorMapApplicabilityProvider;", "Lorg/jetbrains/plugins/groovy/extensions/GroovyApplicabilityProvider;", "()V", "hasOtherMapConstructor", "", "method", "Lcom/intellij/psi/PsiMethod;", "isApplicable", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Applicability;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "isConstructor", "intellij.groovy.psi"})
public class ConstructorMapApplicabilityProvider
extends GroovyApplicabilityProvider {
    public boolean isConstructor(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method.isConstructor();
    }

    @Nullable
    public Applicability isApplicable(@NotNull List<? extends Argument> arguments2, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!this.isConstructor(method)) {
            return null;
        }
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] parameters2 = psiParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameters2, (String)"parameters");
        PsiParameter[] psiParameterArray = parameters2;
        if (!(psiParameterArray.length == 0)) {
            return null;
        }
        Argument argument = (Argument)CollectionsKt.singleOrNull(arguments2);
        if (argument == null) {
            return null;
        }
        Argument argument2 = argument;
        PsiType argumentType = argument2.getType();
        return InheritanceUtil.isInheritor((PsiType)argumentType, (String)"java.util.Map") && !this.hasOtherMapConstructor(method) ? Applicability.applicable : Applicability.inapplicable;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOtherMapConstructor(PsiMethod method) {
        boolean bl;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"method.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        PsiMethod[] psiMethodArray = containingClass.getConstructors();
        if (psiMethodArray != null) {
            void $this$filterTo$iv$iv;
            PsiMethod[] $this$filter$iv = psiMethodArray;
            boolean $i$f$filter = false;
            PsiMethod[] psiMethodArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_8 = $this$filterTo$iv$iv;
            int n = 0;
            int n2 = ((void)var8_8).length;
            while (n < n2) {
                boolean bl2;
                PsiType psiType;
                void element$iv$iv = var8_8[n];
                ++n;
                void constructor = element$iv$iv;
                boolean bl3 = false;
                void v2 = constructor;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"constructor");
                PsiParameterList psiParameterList = v2.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"constructor.parameterList");
                PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                if (!((psiParameterArray != null && (psiParameterArray = (PsiParameter[])ArraysKt.singleOrNull((Object[])psiParameterArray)) != null ? psiParameterArray.getType() : (psiType = null)) instanceof PsiClassType)) {
                    psiType = null;
                }
                if ((PsiClassType)psiType == null) {
                    bl2 = false;
                } else {
                    PsiClassType argumentType;
                    boolean isSubtypeOfMap = InheritanceUtil.isInheritor((PsiType)((PsiType)argumentType), (String)"java.util.Map");
                    if (isSubtypeOfMap) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)GroovyPsiElementFactory.getInstance(method.getProject()).createTypeByFQClassName("java.util.Map"), (String)"GroovyPsiElementFactory.\u2026ClassNames.JAVA_UTIL_MAP)");
                    Object object = argumentType.resolve();
                    if (object == null || (object = object.getQualifiedName()) == null) {
                        bl2 = false;
                    } else {
                        PsiClassType map2;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"argumentType.resolve()?.\u2026me ?: return@filter false");
                        Object argumentQualifiedName = object;
                        return InheritanceUtil.isInheritor((PsiType)((PsiType)map2), (String)argumentQualifiedName);
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            bl = !collection.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }
}

