/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.documentation;

import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigDeclarationDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigReferenceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/editorconfig/language/codeinsight/documentation/EditorConfigElementDescriptionProvider;", "Lcom/intellij/psi/ElementDescriptionProvider;", "()V", "getElementDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/ElementDescriptionLocation;", "intellij.editorconfig"})
public final class EditorConfigElementDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        PsiElement psiElement = element;
        if (!(psiElement instanceof EditorConfigDescribableElement)) {
            psiElement = null;
        }
        if ((EditorConfigDescribableElement)psiElement == null) {
            return null;
        }
        if (element instanceof EditorConfigFlatOptionKey) {
            Object[] objectArray = new Object[2];
            String string2 = ((EditorConfigFlatOptionKey)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.text");
            objectArray[0] = string2;
            EditorConfigHeader editorConfigHeader = ((EditorConfigDescribableElement)element).getSection().getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"element.section.header");
            String string3 = editorConfigHeader.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element.section.header.text");
            objectArray[1] = string3;
            return EditorConfigBundle.INSTANCE.get("usage.type.option.key", objectArray);
        }
        EditorConfigDescriptor descriptor = ((EditorConfigDescribableElement)element).getDescriptor(false);
        EditorConfigDescriptor editorConfigDescriptor = descriptor;
        if (editorConfigDescriptor instanceof EditorConfigDeclarationDescriptor || editorConfigDescriptor instanceof EditorConfigReferenceDescriptor) {
            Object[] objectArray = new Object[2];
            String string4 = ((EditorConfigDescribableElement)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"element.text");
            objectArray[0] = string4;
            EditorConfigHeader editorConfigHeader = ((EditorConfigDescribableElement)element).getSection().getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"element.section.header");
            String string5 = editorConfigHeader.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"element.section.header.text");
            objectArray[1] = string5;
            string = EditorConfigBundle.INSTANCE.get("usage.type.identifier", objectArray);
        } else if (editorConfigDescriptor instanceof EditorConfigConstantDescriptor) {
            Object[] objectArray = new Object[2];
            String string6 = ((EditorConfigDescribableElement)element).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"element.text");
            objectArray[0] = string6;
            EditorConfigHeader editorConfigHeader = ((EditorConfigDescribableElement)element).getSection().getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"element.section.header");
            String string7 = editorConfigHeader.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"element.section.header.text");
            objectArray[1] = string7;
            string = EditorConfigBundle.INSTANCE.get("usage.type.constant", objectArray);
        } else {
            string = EditorConfigBundle.INSTANCE.get("usage.type.unknown");
        }
        return string;
    }
}

