/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomClasspathElement;
import com.intellij.lang.ant.dom.AntDomPropertyDefiningTask;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.GenericAttributeValue;
import java.net.URL;
import org.jetbrains.annotations.NonNls;

public abstract class AntDomWhichResourceTask
extends AntDomPropertyDefiningTask
implements AntDomClasspathElement {
    private volatile ClassLoader myCachedLoader;

    @Attribute(value="class")
    public abstract GenericAttributeValue<String> getClassName();

    @Attribute(value="resource")
    public abstract GenericAttributeValue<String> getResourceName();

    @Override
    @NlsSafe
    protected String calcPropertyValue(@NonNls String propertyName) {
        URL resource;
        ClassLoader loader;
        Object resName = this.getClassName().getStringValue();
        resName = resName == null ? this.getResourceName().getStringValue() : ((String)resName).replace(".", "/") + ".class";
        if (resName != null && (loader = this.getClassLoader()) != null && (resource = loader.getResource((String)resName)) != null) {
            return resource.toExternalForm();
        }
        return "";
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = this.myCachedLoader;
        if (loader == null) {
            this.myCachedLoader = loader = CustomAntElementsRegistry.createClassLoader(CustomAntElementsRegistry.collectUrls(this), this.getContextAntProject());
        }
        return loader;
    }
}

