/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.semantics;

import com.android.tools.idea.gradle.dsl.parser.semantics.ArityHelper;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertySemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SurfaceSyntaxDescription;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

public final class ModelMapCollector {
    @NotNull
    public static Collector<Object[], ?, ImmutableMap<SurfaceSyntaxDescription, ModelEffectDescription>> toModelMap() {
        Function<Object[], SurfaceSyntaxDescription> k = data -> {
            String name = (String)data[0];
            Integer arity = (Integer)data[1];
            SemanticsDescription description = (SemanticsDescription)data[3];
            if (Objects.equals(arity, ArityHelper.property)) {
                if (!(description instanceof PropertySemanticsDescription)) {
                    throw new RuntimeException("Dsl setup problem for " + name + ": property/semantics description mismatch");
                }
            } else if (!(description instanceof MethodSemanticsDescription)) {
                throw new RuntimeException("Dsl setup problem for " + name + ": method/semantics description mismatch");
            }
            return new SurfaceSyntaxDescription(name, arity);
        };
        Function<Object[], ModelEffectDescription> v = data -> {
            ModelPropertyDescription mpd;
            String name = (String)data[0];
            Object propertyDescriptionDesignator = data[2];
            SemanticsDescription sd = (SemanticsDescription)data[3];
            if (propertyDescriptionDesignator instanceof String) {
                mpd = new ModelPropertyDescription((String)propertyDescriptionDesignator);
            } else if (propertyDescriptionDesignator instanceof ModelPropertyDescription) {
                mpd = (ModelPropertyDescription)propertyDescriptionDesignator;
            } else {
                throw new RuntimeException("Unrecognized model property description designator for " + name + ": " + propertyDescriptionDesignator);
            }
            return new ModelEffectDescription(mpd, sd);
        };
        Collector collector = ImmutableMap.toImmutableMap(k, v);
        if (collector == null) {
            ModelMapCollector.$$$reportNull$$$0(0);
        }
        return collector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/semantics/ModelMapCollector", "toModelMap"));
    }
}

