/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.JSONB;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONBGetAttributeAsText
extends AbstractField<String>
implements QOM.JSONBGetAttributeAsText {
    final Field<JSONB> field;
    final Field<String> attribute;

    JSONBGetAttributeAsText(Field<JSONB> field, Field<String> attribute) {
        super(Names.N_JSONB_GET_ATTRIBUTE_AS_TEXT, Tools.allNotNull(SQLDataType.VARCHAR, field, attribute));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.JSONB);
        this.attribute = Tools.nullSafeNotNull(attribute, SQLDataType.VARCHAR);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSONB, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$.").concat(this.attribute)), DSL.inline("null").cast(SQLDataType.JSONB))));
                break;
            }
            case MARIADB: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSONB, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$.").concat(this.attribute)).cast(SQLDataType.VARCHAR), DSL.inline("null"))));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$.").concat(this.attribute)));
                break;
            }
            default: {
                ctx.sql('(').visit(this.field).sql("->>").visit(this.attribute).sql(')');
            }
        }
    }

    @Override
    public final Field<JSONB> $arg1() {
        return this.field;
    }

    @Override
    public final Field<String> $arg2() {
        return this.attribute;
    }

    @Override
    public final QOM.JSONBGetAttributeAsText $arg1(Field<JSONB> newValue) {
        return this.$constructor().apply((Field<JSONB>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.JSONBGetAttributeAsText $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<JSONB>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<JSONB>, ? super Field<String>, ? extends QOM.JSONBGetAttributeAsText> $constructor() {
        return (a1, a2) -> new JSONBGetAttributeAsText((Field<JSONB>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONBGetAttributeAsText) {
            QOM.JSONBGetAttributeAsText o = (QOM.JSONBGetAttributeAsText)that;
            return StringUtils.equals(this.$field(), o.$field()) && StringUtils.equals(this.$attribute(), o.$attribute());
        }
        return super.equals(that);
    }
}

