/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.jooq.Asterisk;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.GroupField;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.QualifiedAsterisk;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOffsetStep;
import org.jooq.SelectQuery;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWithTiesStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TablePartitionByStep;
import org.jooq.WindowDefinition;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractResultQuery;
import org.jooq.impl.AsteriskImpl;
import org.jooq.impl.CombineOperator;
import org.jooq.impl.CommonTableExpressionList;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.Convert;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.ForLock;
import org.jooq.impl.GroupFieldList;
import org.jooq.impl.InlineDerivedTable;
import org.jooq.impl.JoinTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.LazyName;
import org.jooq.impl.Limit;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.NoField;
import org.jooq.impl.QOM;
import org.jooq.impl.QualifiedSelectFieldList;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RowAsField;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.SelectImpl;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.TableAsField;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableList;
import org.jooq.impl.ThrowingSupplier;
import org.jooq.impl.Tools;
import org.jooq.impl.TopLevelCte;
import org.jooq.impl.Transformations;
import org.jooq.impl.Val;
import org.jooq.impl.WindowList;
import org.jooq.impl.WithImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

final class SelectQueryImpl<R extends Record>
extends AbstractResultQuery<R>
implements SelectQuery<R> {
    private static final JooqLogger log = JooqLogger.getLogger(SelectQueryImpl.class);
    private static final Clause[] CLAUSES = new Clause[]{Clause.SELECT};
    static final Set<SQLDialect> EMULATE_SELECT_INTO_AS_CTAS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORT_SELECT_INTO_TABLE = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_WINDOW_CLAUSE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB);
    private static final Set<SQLDialect> OPTIONAL_FROM_CLAUSE = SQLDialect.supportedBy(SQLDialect.DEFAULT, SQLDialect.H2, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> REQUIRES_DERIVED_TABLE_DML = SQLDialect.supportedUntil(SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_IMPLICIT_GROUP_BY_ON_HAVING = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_FULL_WITH_TIES = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> EMULATE_DISTINCT_ON = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_FOR_UPDATE_OF_FIELDS = SQLDialect.supportedBy(SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_UNION_ORDER_BY_ALIAS = SQLDialect.supportedBy(SQLDialect.FIREBIRD);
    static final Set<SQLDialect> NO_SUPPORT_WITH_READ_ONLY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    final WithImpl with;
    private final SelectFieldList<SelectFieldOrAsterisk> select;
    private Table<?> intoTable;
    private String hint;
    private String option;
    private boolean distinct;
    private final QueryPartList<SelectFieldOrAsterisk> distinctOn;
    private ForLock forLock;
    private boolean withCheckOption;
    private boolean withReadOnly;
    private final TableList from;
    private final ConditionProviderImpl condition;
    private final GroupFieldList groupBy;
    private boolean groupByDistinct;
    private final ConditionProviderImpl having;
    private WindowList window;
    private final ConditionProviderImpl qualify;
    private final SortFieldList orderBy;
    private final QueryPartList<Field<?>> seek;
    private boolean seekBefore;
    private final Limit limit;
    private final List<CombineOperator> unionOp;
    private final List<QueryPartList<Select<?>>> union;
    private final SortFieldList unionOrderBy;
    private final QueryPartList<Field<?>> unionSeek;
    private boolean unionSeekBefore;
    private final Limit unionLimit;
    private final Map<QueryPart, QueryPart> localQueryPartMapping;
    private static final Set<SQLDialect> NO_SUPPORT_UNION_PARENTHESES = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_CTE_IN_UNION = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.MARIADB);
    private static final Set<SQLDialect> UNION_PARENTHESIS = SQLDialect.supportedUntil(SQLDialect.DERBY);

    SelectQueryImpl(Configuration configuration, WithImpl with) {
        this(configuration, with, null);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, boolean distinct) {
        this(configuration, with, null, distinct);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, TableLike<? extends R> from) {
        this(configuration, with, from, false);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, TableLike<? extends R> from, boolean distinct) {
        super(configuration);
        this.with = with;
        this.distinct = distinct;
        this.distinctOn = new SelectFieldList<SelectFieldOrAsterisk>();
        this.select = new SelectFieldList();
        this.from = new TableList();
        this.condition = new ConditionProviderImpl();
        this.groupBy = new GroupFieldList();
        this.having = new ConditionProviderImpl();
        this.qualify = new ConditionProviderImpl();
        this.orderBy = new SortFieldList();
        this.seek = new QueryPartList();
        this.limit = new Limit();
        this.unionOp = new ArrayList<CombineOperator>();
        this.union = new ArrayList();
        this.unionOrderBy = new SortFieldList();
        this.unionSeek = new QueryPartList();
        this.unionLimit = new Limit();
        if (from != null) {
            this.from.add(from.asTable());
        }
        this.localQueryPartMapping = new LinkedHashMap<QueryPart, QueryPart>();
    }

    private final SelectQueryImpl<R> copyTo(CopyClause clause, boolean scalarSelect, SelectQueryImpl<R> result) {
        return this.copyBetween(CopyClause.START, clause, scalarSelect, result);
    }

    private final SelectQueryImpl<R> copyAfter(CopyClause clause, boolean scalarSelect, SelectQueryImpl<R> result) {
        return this.copyBetween(clause, CopyClause.END, scalarSelect, result);
    }

    private final SelectQueryImpl<R> copyBetween(CopyClause start, CopyClause end, boolean scalarSelect, SelectQueryImpl<R> result) {
        if (CopyClause.START.between(start, end)) {
            result.from.addAll(this.from);
            result.condition.setWhere(this.condition.getWhere());
            if (scalarSelect) {
                result.select.addAll(this.select);
            }
        }
        if (CopyClause.WHERE.between(start, end)) {
            result.groupBy.addAll(this.groupBy);
            result.groupByDistinct = this.groupByDistinct;
            result.having.setWhere(this.having.getWhere());
            if (this.window != null) {
                result.addWindow0(this.window);
            }
            result.qualify.setWhere(this.qualify.getWhere());
        }
        if (CopyClause.QUALIFY.between(start, end)) {
            if (!scalarSelect) {
                result.select.addAll(this.select);
            }
            result.hint = this.hint;
            result.distinct = this.distinct;
            result.distinctOn.addAll((Collection<SelectFieldOrAsterisk>)this.distinctOn);
            result.orderBy.addAll(this.orderBy);
            result.seek.addAll((Collection<Field<?>>)this.seek);
            result.limit.from(this.limit);
            result.forLock = this.forLock;
            result.withCheckOption = this.withCheckOption;
            result.withReadOnly = this.withReadOnly;
            result.option = this.option;
            result.intoTable = this.intoTable;
            result.union.addAll(this.union);
            result.unionOp.addAll(this.unionOp);
            result.unionOrderBy.addAll(this.unionOrderBy);
            result.unionSeek.addAll((Collection<Field<?>>)this.unionSeek);
            result.unionSeekBefore = this.unionSeekBefore;
            result.unionLimit.from(this.unionLimit);
        }
        return result;
    }

    private final SelectQueryImpl<R> copy(Consumer<? super SelectQueryImpl<R>> finisher) {
        return this.copy(finisher, this.with);
    }

    private final SelectQueryImpl<R> copy(Consumer<? super SelectQueryImpl<R>> finisher, WithImpl newWith) {
        SelectQueryImpl<R> result = this.copyTo(CopyClause.END, false, new SelectQueryImpl<R>(this.configuration(), newWith));
        finisher.accept(result);
        return result;
    }

    @Override
    public final <T> Field<T> asField() {
        return new ScalarSubquery(this, Tools.scalarType(this), false);
    }

    @Override
    public final <T> Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    @Override
    public <T> Field<T> asField(Function<? super Field<T>, ? extends String> aliasFunction) {
        return this.asField().as(aliasFunction);
    }

    @Override
    public final Row fieldsRow() {
        return this.asTable().fieldsRow();
    }

    @Override
    public final Field<Result<R>> asMultiset() {
        return DSL.multiset(this);
    }

    @Override
    public final Field<Result<R>> asMultiset(String alias) {
        return DSL.multiset(this).as(alias);
    }

    @Override
    public final Field<Result<R>> asMultiset(Name alias) {
        return DSL.multiset(this).as(alias);
    }

    @Override
    public final Field<Result<R>> asMultiset(Field<?> alias) {
        return DSL.multiset(this).as((Field)alias);
    }

    @Override
    public final Table<R> asTable() {
        return new DerivedTable(this).as(new LazyName(() -> DSL.name(Tools.autoAlias(this))));
    }

    @Override
    public final Table<R> asTable(String alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(String alias, Collection<? extends String> fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Name alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(Name alias, Name ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Name alias, Collection<? extends Name> fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Table<?> alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(Table<?> alias, Field<?> ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Table<?> alias, Collection<? extends Field<?>> fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(String alias, Function<? super Field<?>, ? extends String> aliasFunction) {
        return new DerivedTable(this).as(alias, aliasFunction);
    }

    @Override
    public final Table<R> asTable(String alias, BiFunction<? super Field<?>, ? super Integer, ? extends String> aliasFunction) {
        return new DerivedTable(this).as(alias, aliasFunction);
    }

    @Override
    public final Field<?>[] getFields(ThrowingSupplier<? extends ResultSetMetaData, SQLException> rs) throws SQLException {
        Field<?>[] fields = this.getFields();
        if (fields.length == 0) {
            return new MetaDataFieldProvider(this.configuration(), rs.get()).getFields();
        }
        return fields;
    }

    @Override
    public final Field<?>[] getFields() {
        Collection<Field<?>> fields = this.coerce();
        if (fields == null || fields.isEmpty()) {
            fields = this.getSelect();
        }
        return Tools.fieldArray(fields);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final Select<?> distinctOnEmulation() {
        ArrayList<Field> partitionBy = new ArrayList<Field>(this.distinctOn.size());
        for (SelectFieldOrAsterisk s : this.distinctOn) {
            if (!(s instanceof Field)) continue;
            Field f = (Field)s;
            partitionBy.add(f);
        }
        SelectField rn = DSL.rowNumber().over(DSL.partitionBy(partitionBy).orderBy(this.orderBy)).as("rn");
        SelectQueryImpl<R> copy = this.copy(x -> {});
        copy.distinctOn.clear();
        copy.select.add(rn);
        copy.orderBy.clear();
        copy.limit.clear();
        SelectSeekStepN s1 = DSL.select(new QualifiedSelectFieldList(DSL.table(DSL.name("t")), (Iterable<SelectFieldOrAsterisk>)this.select)).from((TableLike<?>)copy.asTable("t")).where(rn.eq(DSL.one())).orderBy(Tools.map(this.orderBy, o -> Tools.unqualified(o)));
        if (this.limit.limit != null) {
            SelectLimitPercentStep s2 = s1.limit(this.limit.limit);
            SelectWithTiesStep s3 = this.limit.percent ? s2.percent() : s2;
            SelectOffsetStep s4 = this.limit.withTies ? s3.withTies() : s3;
            return this.limit.offset != null ? s4.offset(this.limit.offset) : s4;
        }
        return this.limit.offset != null ? s1.offset(this.limit.offset) : s1;
    }

    @Override
    public final void accept(Context<?> ctx) {
        List dmlTables;
        Table dmlTable;
        if (ctx.subqueryLevel() == 1 && REQUIRES_DERIVED_TABLE_DML.contains((Object)ctx.dialect()) && !Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_INSERT_SELECT)) && (dmlTable = (Table)ctx.data(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE)) != null && Tools.containsUnaliasedTable(this.getFrom(), dmlTable)) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.asTable("t")));
        } else if (ctx.subqueryLevel() == 1 && ctx.family() == SQLDialect.MARIADB && !Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_INSERT_SELECT)) && ((dmlTable = (Table)ctx.data(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE)) != null && Tools.aliased(dmlTable) != null && Tools.containsUnaliasedTable(this.getFrom(), dmlTable) || (dmlTables = (List)ctx.data(Tools.SimpleDataKey.DATA_DML_USING_TABLES)) != null && Tools.anyMatch(dmlTables, t -> Tools.containsUnaliasedTable(this.getFrom(), t)))) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.asTable("t")));
        } else if (Tools.isNotEmpty(this.distinctOn) && EMULATE_DISTINCT_ON.contains((Object)ctx.dialect())) {
            ctx.visit(this.distinctOnEmulation());
        } else if (!this.qualify.hasWhere() || !Transformations.transformQualify(ctx.configuration())) {
            if (this.withReadOnly && NO_SUPPORT_WITH_READ_ONLY.contains((Object)ctx.dialect())) {
                ctx.visit(this.copy(s -> {
                    s.withReadOnly = false;
                    if (!(s.distinct || !s.groupBy.isEmpty() || s.having.hasWhere() || s.limit.isApplicable() || s.hasUnions())) {
                        s.union((Select)DSL.select(Tools.map(s.getSelect(), f -> DSL.inline(null, f))).where((Condition)DSL.falseCondition()));
                    }
                }));
            } else {
                this.accept0(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void accept0(Context<?> context) {
        boolean topLevelCte = false;
        if (context.subqueryLevel() == 0) {
            context.scopeStart();
            if (topLevelCte |= context.data(Tools.SimpleDataKey.DATA_TOP_LEVEL_CTE) == null) {
                context.data(Tools.SimpleDataKey.DATA_TOP_LEVEL_CTE, new TopLevelCte());
            }
        }
        SQLDialect dialect = context.dialect();
        switch (SettingsTools.getRenderTable(context.settings())) {
            case NEVER: {
                context.data(Tools.ExtendedDataKey.DATA_RENDER_TABLE, false);
                break;
            }
            case WHEN_MULTIPLE_TABLES: {
                if (!this.knownTableSource() || this.getFrom().size() >= 2) break;
                context.data(Tools.ExtendedDataKey.DATA_RENDER_TABLE, false);
                break;
            }
            case WHEN_AMBIGUOUS_COLUMNS: {
                if (!this.knownTableSource() || Tools.hasAmbiguousNames(this.getSelect())) break;
                context.data(Tools.ExtendedDataKey.DATA_RENDER_TABLE, false);
            }
        }
        Object renderTrailingLimit = context.data(Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE);
        Name[] selectAliases = (Name[])context.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES);
        try {
            List<Field<?>> originalFields = null;
            List<Field<?>> alternativeFields = null;
            if (selectAliases != null) {
                context.data().remove(Tools.SimpleDataKey.DATA_SELECT_ALIASES);
                originalFields = this.getSelect();
                alternativeFields = Tools.map(originalFields, (f, i) -> i < selectAliases.length ? f.as(selectAliases[i]) : f);
            }
            if (Boolean.TRUE.equals(renderTrailingLimit)) {
                context.data().remove(Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE);
            }
            if (this.intoTable != null && !Boolean.TRUE.equals(context.data(Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE)) && EMULATE_SELECT_INTO_AS_CTAS.contains((Object)dialect)) {
                context.data(Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE, true, c -> c.visit(DSL.createTable(this.intoTable).as(this)));
                return;
            }
            if (this.with != null) {
                context.visit(this.with);
            } else if (topLevelCte) {
                CommonTableExpressionList.markTopLevelCteAndAccept(context, c -> {});
            }
            this.pushWindow(context);
            Boolean wrapDerivedTables = (Boolean)context.data(Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES);
            if (Boolean.TRUE.equals(wrapDerivedTables)) {
                context.sqlIndentStart('(').data().remove(Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES);
            }
            switch (context.family()) {
                case MARIADB: {
                    if (this.getLimit().isApplicable() && this.getLimit().isExpression()) {
                        this.toSQLReferenceLimitWithWindowFunctions(context);
                        break;
                    }
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                    break;
                }
                case POSTGRES: {
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                    break;
                }
                case FIREBIRD: 
                case MYSQL: {
                    if (this.getLimit().isApplicable() && (this.getLimit().withTies() || this.getLimit().isExpression())) {
                        this.toSQLReferenceLimitWithWindowFunctions(context);
                        break;
                    }
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                    break;
                }
                case CUBRID: 
                case YUGABYTEDB: {
                    if (this.getLimit().isApplicable() && this.getLimit().withTies()) {
                        this.toSQLReferenceLimitWithWindowFunctions(context);
                        break;
                    }
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                    break;
                }
                default: {
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                }
            }
            if (this.forLock != null) {
                context.visit(this.forLock);
            } else if (this.withCheckOption) {
                context.formatSeparator().visit(Keywords.K_WITH_CHECK_OPTION);
            } else if (this.withReadOnly && !NO_SUPPORT_WITH_READ_ONLY.contains((Object)context.dialect())) {
                context.formatSeparator().visit(Keywords.K_WITH_READ_ONLY);
            }
            if (!StringUtils.isBlank(this.option)) {
                context.formatSeparator().sql(this.option);
            }
            if (Boolean.TRUE.equals(wrapDerivedTables)) {
                context.sqlIndentEnd(')').data(Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES, true);
            }
        }
        finally {
            if (renderTrailingLimit != null) {
                context.data(Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE, renderTrailingLimit);
            }
            if (selectAliases != null) {
                context.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES, selectAliases);
            }
        }
        if (context.subqueryLevel() == 0) {
            context.scopeEnd();
        }
    }

    private final void pushWindow(Context<?> context) {
        if (Tools.isNotEmpty(this.window)) {
            context.data(Tools.SimpleDataKey.DATA_WINDOW_DEFINITIONS, this.window);
        }
    }

    private final void toSQLReferenceLimitDefault(Context<?> context, List<Field<?>> originalFields, List<Field<?>> alternativeFields) {
        context.data(Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE, true, c -> this.toSQLReference0(context, originalFields, alternativeFields));
    }

    private final void toSQLReferenceLimitWithWindowFunctions(Context<?> ctx) {
        List<Field<?>> originalFields = this.getSelect();
        ArrayList alternativeFields = new ArrayList(originalFields.size());
        if (originalFields.isEmpty()) {
            alternativeFields.add(DSL.field("*"));
        } else {
            alternativeFields.addAll(Tools.aliasedFields(originalFields));
        }
        alternativeFields.add((Field<?>)CustomField.of("rn", SQLDataType.INTEGER, c -> {
            boolean wrapQueryExpressionBodyInDerivedTable = this.wrapQueryExpressionBodyInDerivedTable((Context<?>)c);
            c.data(Tools.BooleanDataKey.DATA_UNALIAS_ALIASED_EXPRESSIONS, !wrapQueryExpressionBodyInDerivedTable);
            boolean q = c.qualify();
            c.data(Tools.SimpleDataKey.DATA_OVERRIDE_ALIASES_IN_ORDER_BY, new Object[]{originalFields, alternativeFields});
            if (wrapQueryExpressionBodyInDerivedTable) {
                c.qualify(false);
            }
            c.visit(this.distinct ? DSL.denseRank().over(DSL.orderBy(this.getNonEmptyOrderByForDistinct(c.configuration()))) : (this.getLimit().withTies() ? DSL.rank().over(DSL.orderBy(this.getNonEmptyOrderBy(c.configuration()))) : DSL.rowNumber().over(DSL.orderBy(this.getNonEmptyOrderBy(c.configuration())))));
            c.data().remove(Tools.BooleanDataKey.DATA_UNALIAS_ALIASED_EXPRESSIONS);
            c.data().remove(Tools.SimpleDataKey.DATA_OVERRIDE_ALIASES_IN_ORDER_BY);
            if (wrapQueryExpressionBodyInDerivedTable) {
                c.qualify(q);
            }
        }).as("rn"));
        List<Field<?>> unaliasedFields = Tools.unaliasedFields(originalFields);
        ctx.visit(Keywords.K_SELECT).separatorRequired(true).declareFields(true, c -> c.visit(new SelectFieldList(unaliasedFields))).formatSeparator().visit(Keywords.K_FROM).sqlIndentStart(" (").subquery(true);
        this.toSQLReference0(ctx, originalFields, alternativeFields);
        ctx.subquery(false).sqlIndentEnd(") ").visit(DSL.name("x")).formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(DSL.name("rn")).sql(" > ").visit(this.getLimit().getLowerRownum());
        if (!this.getLimit().limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_AND).sql(' ').visit(DSL.name("rn")).sql(" <= ").visit(this.getLimit().getUpperRownum());
        }
        if (!(ctx.subquery() || this.getOrderBy().isEmpty() || Boolean.FALSE.equals(ctx.settings().isRenderOrderByRownumberForEmulatedPagination()))) {
            ctx.formatSeparator().visit(Keywords.K_ORDER_BY).sql(' ').visit(DSL.name("rn"));
        }
    }

    private final void toSQLReference0(Context<?> context, List<Field<?>> originalFields, List<Field<?>> alternativeFields) {
        boolean wrapQueryExpressionBodyInDerivedTable;
        SQLDialect family = context.family();
        boolean qualify = context.qualify();
        int unionOpSize = this.unionOp.size();
        boolean unionParensRequired = false;
        boolean unionOpNesting = false;
        boolean applySeekOnDerivedTable = this.applySeekOnDerivedTable();
        boolean wrapQueryExpressionInDerivedTable = false;
        if (wrapQueryExpressionInDerivedTable) {
            context.visit(Keywords.K_SELECT).sql(" *").formatSeparator().visit(Keywords.K_FROM).sql(" (").formatIndentStart().formatNewLine();
        }
        if (wrapQueryExpressionBodyInDerivedTable = applySeekOnDerivedTable) {
            context.visit(Keywords.K_SELECT).sql(' ');
            context.formatIndentStart().formatNewLine().sql("t.*");
            if (alternativeFields != null && originalFields.size() < alternativeFields.size()) {
                context.sql(", ").formatSeparator().declareFields(true, c -> c.visit((Field)alternativeFields.get(alternativeFields.size() - 1)));
            }
            context.formatIndentEnd().formatSeparator().visit(Keywords.K_FROM).sql(" (").formatIndentStart().formatNewLine();
        }
        if (unionOpSize > 0) {
            if (!Boolean.TRUE.equals(context.data(Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS))) {
                unionOpNesting = this.unionOpNesting();
                context.data(Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS, unionOpNesting);
            }
            for (int i = unionOpSize - 1; i >= 0; --i) {
                switch (this.unionOp.get(i)) {
                    case EXCEPT: {
                        context.start(Clause.SELECT_EXCEPT);
                        break;
                    }
                    case EXCEPT_ALL: {
                        context.start(Clause.SELECT_EXCEPT_ALL);
                        break;
                    }
                    case INTERSECT: {
                        context.start(Clause.SELECT_INTERSECT);
                        break;
                    }
                    case INTERSECT_ALL: {
                        context.start(Clause.SELECT_INTERSECT_ALL);
                        break;
                    }
                    case UNION: {
                        context.start(Clause.SELECT_UNION);
                        break;
                    }
                    case UNION_ALL: {
                        context.start(Clause.SELECT_UNION_ALL);
                    }
                }
                unionParensRequired = unionOpNesting || this.unionParensRequired(context);
                this.unionParenthesis(context, '(', alternativeFields != null ? alternativeFields : this.getSelect(), this.derivedTableRequired(context, this), unionParensRequired);
            }
        }
        Tools.traverseJoins(this.getFrom(), t -> {
            if (t instanceof TableImpl) {
                context.scopeRegister((QueryPart)t, true);
            }
        });
        if (this.with == null || Transformations.transformInlineCTE(context.configuration())) {
            // empty if block
        }
        for (Map.Entry<QueryPart, QueryPart> entry : this.localQueryPartMapping.entrySet()) {
            context.scopeRegister(entry.getKey(), true, entry.getValue());
        }
        context.start(Clause.SELECT_SELECT).visit(Keywords.K_SELECT).separatorRequired(true);
        if (!StringUtils.isBlank(this.hint)) {
            context.sql(' ').sql(this.hint).separatorRequired(true);
        }
        if (Tools.isNotEmpty(this.distinctOn)) {
            context.visit(Keywords.K_DISTINCT_ON).sql(" (").visit(this.distinctOn).sql(')').separatorRequired(true);
        } else if (this.distinct) {
            context.visit(Keywords.K_DISTINCT).separatorRequired(true);
        }
        if (Integer.valueOf(1).equals(context.data(Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE))) {
            context.qualify(false);
        }
        context.declareFields(true);
        if (alternativeFields != null) {
            if (wrapQueryExpressionBodyInDerivedTable && originalFields.size() < alternativeFields.size()) {
                context.visit(new SelectFieldList((Iterable<Field<?>>)alternativeFields.subList(0, originalFields.size())));
            } else {
                context.visit(new SelectFieldList((Iterable<Field<?>>)alternativeFields));
            }
        } else {
            context.visit(this.getSelectResolveUnsupportedAsterisks(context));
        }
        if (Integer.valueOf(1).equals(context.data(Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE))) {
            context.qualify(qualify);
        }
        context.declareFields(false).end(Clause.SELECT_SELECT);
        if (!context.subquery()) {
            context.start(Clause.SELECT_INTO);
            Table<?> actualIntoTable = (Table<?>)context.data(Tools.SimpleDataKey.DATA_SELECT_INTO_TABLE);
            if (actualIntoTable == null) {
                actualIntoTable = this.intoTable;
            }
            if (!(actualIntoTable == null || Boolean.TRUE.equals(context.data(Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE)) || !SUPPORT_SELECT_INTO_TABLE.contains((Object)context.dialect()) && actualIntoTable instanceof Table)) {
                context.formatSeparator().visit(Keywords.K_INTO).sql(' ').visit(actualIntoTable);
            }
            context.end(Clause.SELECT_INTO);
        }
        context.start(Clause.SELECT_FROM).declareTables(true);
        boolean hasFrom = !this.getFrom().isEmpty() || !OPTIONAL_FROM_CLAUSE.contains((Object)context.dialect());
        List semiAntiJoinPredicates = null;
        ConditionProviderImpl where = this.getWhere(context);
        if (hasFrom) {
            Object previousCollect = context.data(Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN, true);
            Object previousCollected = context.data(Tools.SimpleDataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, null);
            TableList tablelist = this.getFrom();
            tablelist = this.transformInlineDerivedTables(tablelist, where);
            context.formatSeparator().visit(Keywords.K_FROM).separatorRequired(true).visit(tablelist);
            semiAntiJoinPredicates = (List)context.data(Tools.SimpleDataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, previousCollected);
            context.data(Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN, previousCollect);
        }
        context.declareTables(false).end(Clause.SELECT_FROM);
        context.start(Clause.SELECT_WHERE);
        if (Boolean.TRUE.equals(context.data().get(Tools.BooleanDataKey.DATA_SELECT_NO_DATA))) {
            context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(DSL.falseCondition());
        } else if (where.hasWhere() || semiAntiJoinPredicates != null || Boolean.TRUE.equals(context.data().get(Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE))) {
            ConditionProviderImpl actual = new ConditionProviderImpl();
            if (semiAntiJoinPredicates != null) {
                actual.addConditions(semiAntiJoinPredicates);
            }
            if (where.hasWhere()) {
                actual.addConditions(where.getWhere());
            }
            context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(actual);
        }
        context.end(Clause.SELECT_WHERE);
        context.start(Clause.SELECT_GROUP_BY);
        if (!this.getGroupBy().isEmpty() || this.getHaving().hasWhere() && NO_IMPLICIT_GROUP_BY_ON_HAVING.contains((Object)context.dialect())) {
            context.formatSeparator().visit(Keywords.K_GROUP_BY);
            if (this.groupByDistinct) {
                context.sql(' ').visit(Keywords.K_DISTINCT);
            }
            GroupFieldList g = this.groupBy;
            context.separatorRequired(true).visit(g);
        }
        context.end(Clause.SELECT_GROUP_BY);
        context.start(Clause.SELECT_HAVING);
        if (this.getHaving().hasWhere()) {
            context.formatSeparator().visit(Keywords.K_HAVING).sql(' ').visit(this.getHaving());
        }
        context.end(Clause.SELECT_HAVING);
        context.start(Clause.SELECT_WINDOW);
        if (Tools.isNotEmpty(this.window) && !NO_SUPPORT_WINDOW_CLAUSE.contains((Object)context.dialect())) {
            context.formatSeparator().visit(Keywords.K_WINDOW).separatorRequired(true).declareWindows(true, c -> c.visit(this.window));
        }
        context.end(Clause.SELECT_WINDOW);
        if (this.getQualify().hasWhere()) {
            context.formatSeparator().visit(Keywords.K_QUALIFY).sql(' ').visit(this.getQualify());
        }
        this.toSQLOrderBy(context, originalFields, alternativeFields, false, wrapQueryExpressionBodyInDerivedTable, false, this.orderBy, this.limit);
        if (unionOpSize > 0) {
            this.unionParenthesis(context, ')', null, this.derivedTableRequired(context, this), unionParensRequired);
            block18: for (int i = 0; i < unionOpSize; ++i) {
                CombineOperator op = this.unionOp.get(i);
                for (Select select : this.union.get(i)) {
                    boolean derivedTableRequired = this.derivedTableRequired(context, select);
                    boolean otherUnionParensRequired = unionParensRequired || this.unionOpNesting();
                    context.formatSeparator().visit(op.toKeyword(family));
                    if (otherUnionParensRequired) {
                        context.sql(' ');
                    } else {
                        context.formatSeparator();
                    }
                    this.unionParenthesis(context, '(', select.getSelect(), derivedTableRequired, otherUnionParensRequired);
                    context.visit(select);
                    this.unionParenthesis(context, ')', null, derivedTableRequired, otherUnionParensRequired);
                }
                if (i < unionOpSize - 1) {
                    this.unionParenthesis(context, ')', null, this.derivedTableRequired(context, this), unionParensRequired);
                }
                switch (this.unionOp.get(i)) {
                    case EXCEPT: {
                        context.end(Clause.SELECT_EXCEPT);
                        continue block18;
                    }
                    case EXCEPT_ALL: {
                        context.end(Clause.SELECT_EXCEPT_ALL);
                        continue block18;
                    }
                    case INTERSECT: {
                        context.end(Clause.SELECT_INTERSECT);
                        continue block18;
                    }
                    case INTERSECT_ALL: {
                        context.end(Clause.SELECT_INTERSECT_ALL);
                        continue block18;
                    }
                    case UNION: {
                        context.end(Clause.SELECT_UNION);
                        continue block18;
                    }
                    case UNION_ALL: {
                        context.end(Clause.SELECT_UNION_ALL);
                    }
                }
            }
            if (unionOpNesting) {
                context.data().remove(Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS);
            }
        }
        if (wrapQueryExpressionBodyInDerivedTable) {
            context.formatIndentEnd().formatNewLine().sql(") t");
            if (applySeekOnDerivedTable) {
                context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').qualify(false, c -> c.visit(this.getSeekCondition(context)));
            }
        }
        context.qualify(false, c -> this.toSQLOrderBy(context, originalFields, alternativeFields, wrapQueryExpressionInDerivedTable, wrapQueryExpressionBodyInDerivedTable, true, this.unionOrderBy, this.unionLimit));
    }

    private final boolean hasInlineDerivedTables(TableList tablelist) {
        return Tools.anyMatch(tablelist, t -> t instanceof InlineDerivedTable || t instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)t));
    }

    private final boolean hasInlineDerivedTables(JoinTable join) {
        return join.lhs instanceof InlineDerivedTable || join.rhs instanceof InlineDerivedTable || join.lhs instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)join.lhs) || join.rhs instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)join.rhs);
    }

    private final TableList transformInlineDerivedTables(TableList tablelist, ConditionProviderImpl where) {
        if (!this.hasInlineDerivedTables(tablelist)) {
            return tablelist;
        }
        TableList result = new TableList();
        for (Table table : tablelist) {
            this.transformInlineDerivedTable0(table, result, where);
        }
        return result;
    }

    private final void transformInlineDerivedTable0(Table<?> table, TableList result, ConditionProviderImpl where) {
        if (table instanceof InlineDerivedTable) {
            InlineDerivedTable t = (InlineDerivedTable)table;
            result.add(t.table);
            where.addConditions(t.condition);
        } else if (table instanceof JoinTable) {
            result.add(this.transformInlineDerivedTables0(table, where, false));
        } else {
            result.add(table);
        }
    }

    private final Table<?> transformInlineDerivedTables0(Table<?> table, ConditionProviderImpl where, boolean keepDerivedTable) {
        if (table instanceof InlineDerivedTable) {
            InlineDerivedTable t = (InlineDerivedTable)table;
            if (keepDerivedTable) {
                return t.query().asTable(t.table);
            }
            where.addConditions(t.condition);
            return t.table;
        }
        if (table instanceof JoinTable) {
            Table<?> lhs;
            JoinTable j = (JoinTable)table;
            return j.transform(lhs, switch (j.type) {
                case JoinType.LEFT_OUTER_JOIN, JoinType.LEFT_ANTI_JOIN, JoinType.LEFT_SEMI_JOIN, JoinType.STRAIGHT_JOIN, JoinType.CROSS_APPLY, JoinType.OUTER_APPLY, JoinType.NATURAL_LEFT_OUTER_JOIN -> {
                    lhs = this.transformInlineDerivedTables0(j.lhs, where, keepDerivedTable);
                    yield this.transformInlineDerivedTables0(j.rhs, where, true);
                }
                case JoinType.RIGHT_OUTER_JOIN, JoinType.NATURAL_RIGHT_OUTER_JOIN -> {
                    lhs = this.transformInlineDerivedTables0(j.lhs, where, true);
                    yield this.transformInlineDerivedTables0(j.rhs, where, keepDerivedTable);
                }
                case JoinType.FULL_OUTER_JOIN, JoinType.NATURAL_FULL_OUTER_JOIN -> {
                    lhs = this.transformInlineDerivedTables0(j.lhs, where, true);
                    yield this.transformInlineDerivedTables0(j.rhs, where, true);
                }
                default -> {
                    lhs = this.transformInlineDerivedTables0(j.lhs, where, keepDerivedTable);
                    yield this.transformInlineDerivedTables0(j.rhs, where, keepDerivedTable);
                }
            });
        }
        return table;
    }

    private final void toSQLOrderBy(Context<?> ctx, List<Field<?>> originalFields, List<Field<?>> alternativeFields, boolean wrapQueryExpressionInDerivedTable, boolean wrapQueryExpressionBodyInDerivedTable, boolean isUnionOrderBy, QueryPartListView<SortField<?>> actualOrderBy, Limit actualLimit) {
        ctx.start(Clause.SELECT_ORDER_BY);
        if (!(this.getLimit().withTies() && !SUPPORT_FULL_WITH_TIES.contains((Object)ctx.dialect()) || actualOrderBy.isEmpty())) {
            ctx.formatSeparator().visit(Keywords.K_ORDER);
            ctx.sql(' ').visit(Keywords.K_BY).separatorRequired(true);
            if (RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect()) && Tools.findAny(actualOrderBy, s -> s.$field() instanceof Val) != null) {
                SelectFieldIndexes s2 = this.getSelectFieldIndexes(ctx);
                if (s2.mapped) {
                    actualOrderBy = new QueryPartListView((List<SortField<?>>)((Object)actualOrderBy)).map(t1 -> {
                        Field in = t1.$field();
                        if (in instanceof Val && in.getDataType().isNumeric()) {
                            Val val = (Val)in;
                            int x = Convert.convert(val.getValue(), Integer.TYPE) - 1;
                            int mapped = s.mapping[x];
                            Val out = s.projectionSizes[x] == 1 ? val.copy(mapped + 1) : DSL.field("{0}", DSL.list((QueryPart[])IntStream.range(mapped, mapped + s.projectionSizes[mapped]).mapToObj(i -> val.copy(i + 1)).toArray(SelectField[]::new)));
                            return t1.$field(out);
                        }
                        return t1;
                    });
                }
            }
            if (NO_SUPPORT_UNION_ORDER_BY_ALIAS.contains((Object)ctx.dialect()) && this.hasUnions() && isUnionOrderBy) {
                List<String> n = Tools.map(this.getSelect(), Field::getName);
                actualOrderBy = new QueryPartListView((List<SortField<?>>)((Object)actualOrderBy)).map(t1 -> {
                    int i = n.indexOf(t1.$field().getName());
                    return i >= 0 ? t1.$field(DSL.inline(i + 1)) : t1;
                });
            }
            ctx.visit(actualOrderBy);
        }
        ctx.end(Clause.SELECT_ORDER_BY);
        if (wrapQueryExpressionInDerivedTable) {
            ctx.formatIndentEnd().formatNewLine().sql(") x");
        }
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE))) {
            if (actualLimit.isApplicable()) {
                ctx.visit(actualLimit);
            } else if (!actualOrderBy.isEmpty() && Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_FORCE_LIMIT_WITH_ORDER_BY))) {
                Limit l = new Limit();
                l.setLimit(Long.MAX_VALUE);
                ctx.visit(l);
            }
        }
    }

    private final boolean applySeekOnDerivedTable() {
        return !this.getSeek().isEmpty() && !this.getOrderBy().isEmpty() && !this.unionOp.isEmpty();
    }

    private final boolean wrapQueryExpressionBodyInDerivedTable(Context<?> ctx) {
        return false;
    }

    final boolean hasUnions() {
        return !this.unionOp.isEmpty();
    }

    private final boolean unionOpNesting() {
        if (this.unionOp.size() > 1) {
            return true;
        }
        for (QueryPartList<Select<?>> s1 : this.union) {
            for (Select select : s1) {
                SelectQueryImpl s = Tools.selectQueryImpl(select);
                if (s == null || s.unionOp.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean derivedTableRequired(Context<?> context, Select<?> s1) {
        SelectQueryImpl s;
        return NO_SUPPORT_CTE_IN_UNION.contains((Object)context.dialect()) && (s = Tools.selectQueryImpl(s1)) != null && s.with != null;
    }

    private final boolean unionParensRequired(Context<?> context) {
        if (this.unionOp.isEmpty()) {
            return false;
        }
        if (this.unionParensRequired(this) || context.settings().isRenderParenthesisAroundSetOperationQueries().booleanValue()) {
            return true;
        }
        CombineOperator op = this.unionOp.get(0);
        if ((op == CombineOperator.EXCEPT || op == CombineOperator.EXCEPT_ALL) && this.union.get(0).size() > 1) {
            return true;
        }
        for (QueryPartList<Select<?>> s1 : this.union) {
            for (Select select : s1) {
                SelectQueryImpl s = Tools.selectQueryImpl(select);
                if (s == null || !this.unionParensRequired(s)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean unionParensRequired(SelectQueryImpl<?> s) {
        return s.orderBy.size() > 0 || s.limit.isApplicable() || s.with != null;
    }

    private final void unionParenthesis(Context<?> ctx, char parenthesis, List<Field<?>> fields, boolean derivedTableRequired, boolean parensRequired) {
        if ('(' == parenthesis) {
            ((AbstractContext)ctx).subquery0(true, true);
        } else if (')' == parenthesis) {
            ((AbstractContext)ctx).subquery0(false, true);
        }
        if ((parensRequired |= (derivedTableRequired |= derivedTableRequired || parensRequired && NO_SUPPORT_UNION_PARENTHESES.contains((Object)ctx.dialect()) || Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS)) && UNION_PARENTHESIS.contains((Object)ctx.dialect()) || Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST)))) && ')' == parenthesis) {
            ctx.formatIndentEnd().formatNewLine();
        } else if (parensRequired && '(' == parenthesis && derivedTableRequired) {
            ctx.formatNewLine().visit(Keywords.K_SELECT).sql(' ');
            if (ctx.family() == SQLDialect.DERBY) {
                ctx.visit(new SelectFieldList<Field>((Iterable<Field>)Tools.map(fields, f -> Tools.unqualified(f))));
            } else {
                ctx.sql('*');
            }
            ctx.formatSeparator().visit(Keywords.K_FROM).sql(' ');
        }
        switch (ctx.family()) {
            case FIREBIRD: {
                break;
            }
            default: {
                if (!parensRequired) break;
                ctx.sql(parenthesis);
            }
        }
        if (parensRequired && '(' == parenthesis) {
            ctx.formatIndentStart().formatNewLine();
        } else if (parensRequired && ')' == parenthesis && derivedTableRequired) {
            ctx.sql(" x");
        }
    }

    @Override
    public final void addSelect(Collection<? extends SelectFieldOrAsterisk> fields) {
        this.getSelectAsSpecified().addAll(fields);
    }

    @Override
    public final void addSelect(SelectFieldOrAsterisk ... fields) {
        this.addSelect(Arrays.asList(fields));
    }

    @Override
    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public final void addDistinctOn(SelectFieldOrAsterisk ... fields) {
        this.addDistinctOn(Arrays.asList(fields));
    }

    @Override
    public final void addDistinctOn(Collection<? extends SelectFieldOrAsterisk> fields) {
        this.distinctOn.addAll((Collection<SelectFieldOrAsterisk>)fields);
    }

    @Override
    public final void setInto(Table<?> table) {
        this.intoTable = table;
    }

    @Override
    public final void addOffset(Number offset) {
        this.getLimit().setOffset(offset);
    }

    @Override
    public final void addOffset(Field<? extends Number> offset) {
        this.getLimit().setOffset(offset);
    }

    @Override
    public final void addLimit(Number l) {
        this.getLimit().setLimit(l);
    }

    @Override
    public final void addLimit(Field<? extends Number> l) {
        this.getLimit().setLimit(l);
    }

    @Override
    public final void addLimit(Number offset, Number l) {
        this.getLimit().setOffset(offset);
        this.getLimit().setLimit(l);
    }

    @Override
    public final void addLimit(Number offset, Field<? extends Number> l) {
        this.getLimit().setOffset(offset);
        this.getLimit().setLimit(l);
    }

    @Override
    public final void addLimit(Field<? extends Number> offset, Number l) {
        this.getLimit().setOffset(offset);
        this.getLimit().setLimit(l);
    }

    @Override
    public final void addLimit(Field<? extends Number> offset, Field<? extends Number> l) {
        this.getLimit().setOffset(offset);
        this.getLimit().setLimit(l);
    }

    @Override
    public final void setLimitPercent(boolean percent) {
        this.getLimit().setPercent(percent);
    }

    @Override
    public final void setWithTies(boolean withTies) {
        this.getLimit().setWithTies(withTies);
    }

    final ForLock forLock() {
        if (this.forLock == null) {
            this.forLock = new ForLock();
        }
        return this.forLock;
    }

    @Override
    public final void setForUpdate(boolean forUpdate) {
        if (forUpdate) {
            this.forLock().forLockMode = ForLock.ForLockMode.UPDATE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForNoKeyUpdate(boolean forNoKeyUpdate) {
        if (forNoKeyUpdate) {
            this.forLock().forLockMode = ForLock.ForLockMode.NO_KEY_UPDATE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForKeyShare(boolean forKeyShare) {
        if (forKeyShare) {
            this.forLock().forLockMode = ForLock.ForLockMode.KEY_SHARE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForUpdateOf(Field<?> ... fields) {
        this.setForLockModeOf(fields);
    }

    @Override
    public final void setForUpdateOf(Collection<? extends Field<?>> fields) {
        this.setForLockModeOf(fields);
    }

    @Override
    public final void setForUpdateOf(Table<?> ... tables) {
        this.setForLockModeOf(tables);
    }

    @Override
    public final void setForUpdateWait(int seconds) {
        this.setForLockModeWait(seconds);
    }

    @Override
    public final void setForUpdateNoWait() {
        this.setForLockModeNoWait();
    }

    @Override
    public final void setForUpdateSkipLocked() {
        this.setForLockModeSkipLocked();
    }

    @Override
    public final void setForShare(boolean forShare) {
        if (forShare) {
            this.forLock().forLockMode = ForLock.ForLockMode.SHARE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForLockModeOf(Field<?> ... fields) {
        this.setForLockModeOf(Arrays.asList(fields));
    }

    @Override
    public final void setForLockModeOf(Collection<? extends Field<?>> fields) {
        this.initLockMode();
        this.forLock().forLockOf = new QueryPartList((Iterable<Field<?>>)fields);
        this.forLock().forLockOfTables = null;
    }

    @Override
    public final void setForLockModeOf(Table<?> ... tables) {
        this.initLockMode();
        this.forLock().forLockOf = null;
        this.forLock().forLockOfTables = new TableList((List<? extends Table<?>>)Arrays.asList(tables));
    }

    @Override
    public final void setForLockModeWait(int seconds) {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.WAIT;
        this.forLock().forLockWait = seconds;
    }

    @Override
    public final void setForLockModeNoWait() {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.NOWAIT;
        this.forLock().forLockWait = 0;
    }

    @Override
    public final void setForLockModeSkipLocked() {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.SKIP_LOCKED;
        this.forLock().forLockWait = 0;
    }

    private final void initLockMode() {
        this.forLock().forLockMode = this.forLock().forLockMode == null ? ForLock.ForLockMode.UPDATE : this.forLock().forLockMode;
    }

    @Override
    public final void setWithCheckOption() {
        this.withCheckOption = true;
        this.withReadOnly = false;
    }

    @Override
    public final void setWithReadOnly() {
        this.withCheckOption = false;
        this.withReadOnly = true;
    }

    @Override
    public final List<Field<?>> getSelect() {
        return this.getSelectResolveAllAsterisks(Tools.configuration(this.configuration()).dsl());
    }

    private static final Collection<? extends Field<?>> subtract(List<? extends Field<?>> left, List<? extends Field<?>> right) {
        FieldsImpl e = new FieldsImpl(right);
        ArrayList result = new ArrayList();
        for (Field<?> f : left) {
            if (e.field(f) != null) continue;
            result.add(f);
        }
        return result;
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectAsSpecified() {
        return this.select;
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveImplicitAsterisks() {
        if (this.getSelectAsSpecified().isEmpty()) {
            return this.resolveAsterisk(new SelectFieldList());
        }
        return this.getSelectAsSpecified();
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveUnsupportedAsterisks(Context<?> ctx) {
        return this.getSelectResolveSomeAsterisks0(ctx, false);
    }

    final SelectFieldList<Field<?>> getSelectResolveAllAsterisks(Scope ctx) {
        return this.getSelectResolveSomeAsterisks0(ctx, true);
    }

    private final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveSomeAsterisks0(Scope ctx, boolean resolveSupported) {
        SelectFieldList<SelectFieldOrAsterisk> result = new SelectFieldList<SelectFieldOrAsterisk>();
        boolean resolveExcept = resolveSupported || !AsteriskImpl.SUPPORT_NATIVE_EXCEPT.contains((Object)ctx.dialect());
        boolean resolveUnqualifiedCombined = resolveSupported || AsteriskImpl.NO_SUPPORT_UNQUALIFIED_COMBINED.contains((Object)ctx.dialect());
        SelectFieldList<SelectFieldOrAsterisk> list = this.getSelectResolveImplicitAsterisks();
        int size = 0;
        for (SelectFieldOrAsterisk s : list) {
            this.appendResolveSomeAsterisks0(ctx, resolveSupported, result, resolveExcept, resolveUnqualifiedCombined, list, s);
            if (resolveSupported && size == result.size()) {
                return new SelectFieldList<SelectFieldOrAsterisk>();
            }
            size = result.size();
        }
        return result;
    }

    private final void appendResolveSomeAsterisks0(Scope ctx, boolean resolveSupported, SelectFieldList<SelectFieldOrAsterisk> result, boolean resolveExcept, boolean resolveUnqualifiedCombined, SelectFieldList<SelectFieldOrAsterisk> list, SelectFieldOrAsterisk s) {
        if (s instanceof Field) {
            Field f = (Field)s;
            result.add(this.getResolveProjection(ctx, f));
        } else if (s instanceof QualifiedAsterisk) {
            QualifiedAsterisk q = (QualifiedAsterisk)s;
            Table<?> table = q.qualifier();
            if (table instanceof QOM.JoinTable) {
                QOM.JoinTable j = (QOM.JoinTable)table;
                this.appendResolveSomeAsterisks0(ctx, resolveSupported, result, resolveExcept, resolveUnqualifiedCombined, list, j.$table1().asterisk());
                this.appendResolveSomeAsterisks0(ctx, resolveSupported, result, resolveExcept, resolveUnqualifiedCombined, list, j.$table2().asterisk());
            } else if (q.$except().isEmpty()) {
                if (resolveSupported) {
                    result.addAll(Arrays.asList(q.qualifier().fields()));
                } else {
                    result.add(s);
                }
            } else if (resolveExcept) {
                result.addAll(SelectQueryImpl.subtract(Arrays.asList(q.qualifier().fields()), q.$except()));
            } else {
                result.add(s);
            }
        } else if (s instanceof Asterisk) {
            Asterisk a = (Asterisk)s;
            if (a.$except().isEmpty()) {
                if (resolveSupported || resolveUnqualifiedCombined && list.size() > 1) {
                    result.addAll(this.resolveAsterisk(new QueryPartList()));
                } else {
                    result.add(s);
                }
            } else if (resolveExcept) {
                result.addAll(this.resolveAsterisk(new QueryPartList(), (QueryPartListView)a.$except()));
            } else {
                result.add(s);
            }
        } else if (s instanceof Row) {
            Row r = (Row)((Object)s);
            result.add(this.getResolveProjection(ctx, new RowAsField(r)));
        } else if (s instanceof Table) {
            Table t = (Table)s;
            result.add(this.getResolveProjection(ctx, new TableAsField(t)));
        } else {
            throw new AssertionError((Object)("Type not supported: " + String.valueOf(s)));
        }
    }

    private final Field<?> getResolveProjection(Scope ctx, Field<?> f) {
        return f;
    }

    private final <Q extends QueryPartList<? super Field<?>>> Q resolveAsterisk(Q result) {
        return this.resolveAsterisk(result, null);
    }

    private final <Q extends QueryPartList<? super Field<?>>> Q resolveAsterisk(Q result, QueryPartCollectionView<? extends Field<?>> except) {
        FieldsImpl e;
        FieldsImpl fieldsImpl = e = except == null ? null : new FieldsImpl(except);
        if (this.knownTableSource()) {
            if (e == null) {
                for (TableLike table : this.getFrom()) {
                    for (Field<?> field : table.asTable().fields()) {
                        result.add(field);
                    }
                }
            } else {
                for (TableLike table : this.getFrom()) {
                    for (Field<?> field : table.asTable().fields()) {
                        if (e.field(field) != null) continue;
                        result.add(field);
                    }
                }
            }
        }
        if (this.getFrom().isEmpty()) {
            result.add(DSL.one());
        }
        return result;
    }

    private final SelectFieldIndexes getSelectFieldIndexes(Context<?> ctx) {
        List<Field<?>> s = this.getSelect();
        boolean mapped = false;
        int[] mapping = new int[s.size()];
        int[] projectionSizes = new int[s.size()];
        if (RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            for (int i = 0; i < mapping.length; ++i) {
                projectionSizes[i] = ((AbstractField)s.get(i)).projectionSize();
                mapped |= projectionSizes[i] > 1;
                if (i >= mapping.length - 1) continue;
                mapping[i + 1] = mapping[i] + projectionSizes[i];
            }
        } else {
            for (int i = 0; i < mapping.length; ++i) {
                mapping[i] = i;
            }
        }
        return new SelectFieldIndexes(mapped, mapping, projectionSizes);
    }

    private final boolean knownTableSource() {
        return Tools.traverseJoins(this.getFrom(), Boolean.valueOf(true), r -> r == false, null, j -> j.type != JoinType.LEFT_ANTI_JOIN && j.type != JoinType.LEFT_SEMI_JOIN, null, (r, t) -> r != false && t.fieldsRow().size() > 0);
    }

    @Override
    final Class<? extends R> getRecordType0() {
        if (this.getFrom().size() == 1 && this.getSelectAsSpecified().isEmpty()) {
            return ((Table)this.getFrom().get(0)).asTable().getRecordType();
        }
        return Tools.recordType(this.getSelect().size());
    }

    final TableList getFrom() {
        return this.from;
    }

    final ConditionProviderImpl getWhere(Context<?> ctx) {
        ConditionProviderImpl result = new ConditionProviderImpl();
        if (this.condition.hasWhere()) {
            result.addConditions(this.condition.getWhere());
        }
        if (!this.getOrderBy().isEmpty() && !this.getSeek().isEmpty() && this.unionOp.isEmpty()) {
            result.addConditions(this.getSeekCondition(ctx));
        }
        return result;
    }

    final Condition getSeekCondition(Context<?> ctx) {
        SortFieldList o = this.getOrderBy();
        Condition c = null;
        QueryPartList<Field<?>> s = this.getSeek();
        if (o.nulls()) {
            // empty if block
        }
        if (o.size() > 1 && o.uniform() && !Boolean.FALSE.equals(ctx.settings().isRenderRowConditionForSeekClause())) {
            List<Field<?>> l = o.fields();
            Serializable r = s;
            if (Tools.anyMatch(r, e -> e instanceof NoField)) {
                l = new ArrayList(l);
                r = new ArrayList((Collection<Field<?>>)((Object)r));
                for (int i = 0; i < r.size(); ++i) {
                    if (!(r.get(i) instanceof NoField)) continue;
                    l.remove(i);
                    r.remove(i);
                }
            }
            c = l.isEmpty() ? DSL.noCondition() : (((SortField)o.get(0)).getOrder() != SortOrder.DESC ^ this.seekBefore ? (l.size() == 1 ? l.get(0).gt((Field)r.get(0)) : DSL.row(l).gt(DSL.row(r))) : (l.size() == 1 ? l.get(0).lt((Field)r.get(0)) : DSL.row(l).lt(DSL.row(r))));
        } else {
            ConditionProviderImpl or = new ConditionProviderImpl();
            for (int i = 0; i < o.size(); ++i) {
                if (s.get(i) instanceof NoField) continue;
                ConditionProviderImpl and = new ConditionProviderImpl();
                for (int j = 0; j < i; ++j) {
                    if (s.get(j) instanceof NoField) continue;
                    and.addConditions(((SortField)o.get(j)).$field().eq((Field)s.get(j)));
                }
                SortField sf = (SortField)o.get(i);
                if (sf.getOrder() != SortOrder.DESC ^ this.seekBefore) {
                    and.addConditions(sf.$field().gt((Field)s.get(i)));
                } else {
                    and.addConditions(sf.$field().lt((Field)s.get(i)));
                }
                or.addConditions(Operator.OR, (Condition)and);
            }
            c = or.getWhere();
        }
        if (o.size() > 1 && Boolean.TRUE.equals(ctx.settings().isRenderRedundantConditionForSeekClause())) {
            c = ((SortField)o.get(0)).getOrder() != SortOrder.DESC ^ this.seekBefore ? ((SortField)o.get(0)).$field().ge((Field)s.get(0)).and(c) : ((SortField)o.get(0)).$field().le((Field)s.get(0)).and(c);
        }
        return c;
    }

    final GroupFieldList getGroupBy() {
        return this.groupBy;
    }

    final ConditionProviderImpl getHaving() {
        return this.having;
    }

    final ConditionProviderImpl getQualify() {
        return this.qualify;
    }

    final SortFieldList getOrderBy() {
        return this.unionOp.size() == 0 ? this.orderBy : this.unionOrderBy;
    }

    final QueryPartList<Field<?>> getSeek() {
        return this.unionOp.size() == 0 ? this.seek : this.unionSeek;
    }

    final Limit getLimit() {
        return this.unionOp.size() == 0 ? this.limit : this.unionLimit;
    }

    final SortFieldList getNonEmptyOrderBy(Configuration configuration) {
        if (this.getOrderBy().isEmpty()) {
            SortFieldList result = new SortFieldList();
            switch (configuration.family()) {
                default: 
            }
            result.add(DSL.field("({select} 0)").asc());
            return result;
        }
        return this.getOrderBy();
    }

    final SortFieldList getNonEmptyOrderByForDistinct(Configuration configuration) {
        SortFieldList order = new SortFieldList();
        order.addAll(this.getNonEmptyOrderBy(configuration));
        for (Field<?> field : this.getSelect()) {
            order.add(field.asc());
        }
        return order;
    }

    @Override
    public final void addOrderBy(Collection<? extends OrderField<?>> fields) {
        this.getOrderBy().addAll(Tools.sortFields(fields));
    }

    @Override
    public final void addOrderBy(OrderField<?> ... fields) {
        this.addOrderBy(Arrays.asList(fields));
    }

    @Override
    public final void addOrderBy(int ... fieldIndexes) {
        this.addOrderBy(Tools.map(fieldIndexes, v -> DSL.inline(v)));
    }

    @Override
    public final void addSeekAfter(Field<?> ... fields) {
        this.addSeekAfter(Arrays.asList(fields));
    }

    @Override
    public final void addSeekAfter(Collection<? extends Field<?>> fields) {
        if (this.unionOp.size() == 0) {
            this.seekBefore = false;
        } else {
            this.unionSeekBefore = false;
        }
        this.getSeek().addAll((Collection<Field<?>>)fields);
    }

    @Override
    @Deprecated
    public final void addSeekBefore(Field<?> ... fields) {
        this.addSeekBefore(Arrays.asList(fields));
    }

    @Override
    @Deprecated
    public final void addSeekBefore(Collection<? extends Field<?>> fields) {
        if (this.unionOp.size() == 0) {
            this.seekBefore = true;
        } else {
            this.unionSeekBefore = true;
        }
        this.getSeek().addAll((Collection<Field<?>>)fields);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    final void setHint(String hint) {
        this.hint = hint;
    }

    final void setOption(String option) {
        this.option = option;
    }

    @Override
    public final void addFrom(Collection<? extends TableLike<?>> f) {
        for (TableLike<?> provider : f) {
            this.getFrom().add(provider.asTable());
        }
    }

    @Override
    public final void addFrom(TableLike<?> f) {
        this.getFrom().add(f.asTable());
    }

    @Override
    public final void addFrom(TableLike<?> ... f) {
        for (TableLike<?> provider : f) {
            this.getFrom().add(provider.asTable());
        }
    }

    @Override
    public final void addGroupBy(Collection<? extends GroupField> fields) {
        if (fields.isEmpty()) {
            this.groupBy.add(DSL.emptyGroupingSet());
        } else {
            this.groupBy.addAll(fields);
        }
    }

    @Override
    public final void setGroupByDistinct(boolean groupByDistinct) {
        this.groupByDistinct = groupByDistinct;
    }

    @Override
    public final void addGroupBy(GroupField ... fields) {
        this.addGroupBy(Arrays.asList(fields));
    }

    @Override
    public final void addHaving(Condition conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Condition ... conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Operator operator, Condition conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addHaving(Operator operator, Condition ... conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addHaving(Operator operator, Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addWindow(WindowDefinition ... definitions) {
        this.addWindow0(Arrays.asList(definitions));
    }

    @Override
    public final void addWindow(Collection<? extends WindowDefinition> definitions) {
        this.addWindow0(definitions);
    }

    final void addWindow0(Collection<? extends WindowDefinition> definitions) {
        if (this.window == null) {
            this.window = new WindowList();
        }
        this.window.addAll(definitions);
    }

    @Override
    public final void addQualify(Condition conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Condition ... conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Collection<? extends Condition> conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Operator operator, Condition conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    @Override
    public final void addQualify(Operator operator, Condition ... conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    @Override
    public final void addQualify(Operator operator, Collection<? extends Condition> conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    private final SelectQueryImpl<R> combine(CombineOperator op, Select<? extends R> other) {
        if (this == other || other instanceof SelectImpl && this == ((SelectImpl)other).getDelegate()) {
            throw new IllegalArgumentException("In jOOQ 3.x's mutable DSL API, it is not possible to use the same instance of a Select query on both sides of a set operation like s.union(s)");
        }
        int index = this.unionOp.size() - 1;
        if (index == -1 || this.unionOp.get(index) != op || op == CombineOperator.EXCEPT || op == CombineOperator.EXCEPT_ALL) {
            this.unionOp.add(op);
            this.union.add(new QueryPartList());
            ++index;
        }
        this.union.get(index).add(other);
        return this;
    }

    @Override
    public final SelectQueryImpl<R> union(Select<? extends R> other) {
        return this.combine(CombineOperator.UNION, other);
    }

    @Override
    public final SelectQueryImpl<R> unionAll(Select<? extends R> other) {
        return this.combine(CombineOperator.UNION_ALL, other);
    }

    @Override
    public final SelectQueryImpl<R> except(Select<? extends R> other) {
        return this.combine(CombineOperator.EXCEPT, other);
    }

    @Override
    public final SelectQueryImpl<R> exceptAll(Select<? extends R> other) {
        return this.combine(CombineOperator.EXCEPT_ALL, other);
    }

    @Override
    public final SelectQueryImpl<R> intersect(Select<? extends R> other) {
        return this.combine(CombineOperator.INTERSECT, other);
    }

    @Override
    public final SelectQueryImpl<R> intersectAll(Select<? extends R> other) {
        return this.combine(CombineOperator.INTERSECT_ALL, other);
    }

    @Override
    public final void addJoin(TableLike<?> table, Condition conditions) {
        this.addJoin(table, JoinType.JOIN, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, Condition ... conditions) {
        this.addJoin(table, JoinType.JOIN, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, JoinType type, Condition conditions) {
        this.addJoin0(table, type, conditions, null);
    }

    @Override
    public final void addJoin(TableLike<?> table, JoinType type, Condition ... conditions) {
        this.addJoin0(table, type, conditions, null);
    }

    private final void addJoin0(TableLike<?> table, JoinType type, Object conditions, Field<?>[] partitionBy) {
        int index = this.getFrom().size() - 1;
        Table<Record> joined = null;
        switch (type) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case STRAIGHT_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                TableOptionalOnStep<Record> o = ((Table)this.getFrom().get(index)).join(table, type);
                if (conditions instanceof Condition) {
                    Condition c = (Condition)conditions;
                    joined = o.on(c);
                    break;
                }
                joined = o.on((Condition[])conditions);
                break;
            }
            case LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: {
                TablePartitionByStep p;
                TablePartitionByStep o = p = (TablePartitionByStep)((Object)((Table)this.getFrom().get(index)).join(table, type));
                if (conditions instanceof Condition) {
                    Condition c = (Condition)conditions;
                    joined = o.on(c);
                    break;
                }
                joined = o.on((Condition[])conditions);
                break;
            }
            case CROSS_APPLY: 
            case OUTER_APPLY: 
            case NATURAL_LEFT_OUTER_JOIN: 
            case NATURAL_RIGHT_OUTER_JOIN: 
            case NATURAL_FULL_OUTER_JOIN: 
            case CROSS_JOIN: 
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad join type: " + String.valueOf((Object)type));
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + String.valueOf((Object)type) + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, TableField<?, ?> ... keyFields) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey(keyFields);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + String.valueOf((Object)type) + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, ForeignKey<?, ?> key) {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey(key);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + String.valueOf((Object)type) + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, Collection<? extends Field<?>> fields) {
        this.addJoinUsing(table, JoinType.JOIN, fields);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, JoinType type, Collection<? extends Field<?>> fields) {
        int index = this.getFrom().size() - 1;
        Table<Record> joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).using(fields);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + String.valueOf((Object)type) + " is not supported with the addJoinUsing() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addHint(String h) {
        this.setHint(h);
    }

    @Override
    public final void addOption(String o) {
        this.setOption(o);
    }

    @Override
    public final WithImpl $with() {
        return this.with;
    }

    @Override
    public final SelectQueryImpl<?> $with(QOM.With newWith) {
        return this.copy(s -> {}, (WithImpl)newWith);
    }

    @Override
    public final QOM.UnmodifiableList<SelectFieldOrAsterisk> $select() {
        return QOM.unmodifiable(this.select);
    }

    @Override
    public final SelectQueryImpl<?> $select(Collection<? extends SelectFieldOrAsterisk> newSelect) {
        return this.copy(s -> {
            s.select.clear();
            s.select.addAll(newSelect);
        });
    }

    @Override
    public final boolean $distinct() {
        return this.distinct;
    }

    @Override
    public final Select<R> $distinct(boolean newDistinct) {
        if (this.$distinct() == newDistinct) {
            return this;
        }
        return this.copy(s -> {
            s.distinct = newDistinct;
        });
    }

    @Override
    public final QOM.UnmodifiableList<SelectFieldOrAsterisk> $distinctOn() {
        return QOM.unmodifiable(this.distinctOn);
    }

    @Override
    public final Select<R> $distinctOn(Collection<? extends SelectFieldOrAsterisk> newDistinctOn) {
        return this.copy(s -> {
            s.distinctOn.clear();
            s.distinctOn.addAll((Collection<SelectFieldOrAsterisk>)newDistinctOn);
        });
    }

    @Override
    public final QOM.UnmodifiableList<Table<?>> $from() {
        return QOM.unmodifiable(this.from);
    }

    @Override
    public final SelectQueryImpl<R> $from(Collection<? extends Table<?>> newFrom) {
        return this.copy(s -> {
            s.from.clear();
            s.from.addAll(newFrom);
        });
    }

    @Override
    public final Condition $where() {
        return this.condition.getWhereOrNull();
    }

    @Override
    public final Select<R> $where(Condition newWhere) {
        if (this.$where() == newWhere) {
            return this;
        }
        return this.copy(s -> s.condition.setWhere(newWhere));
    }

    @Override
    public final QOM.UnmodifiableList<GroupField> $groupBy() {
        return QOM.unmodifiable(this.groupBy);
    }

    @Override
    public final Select<R> $groupBy(Collection<? extends GroupField> newGroupBy) {
        return this.copy(s -> {
            s.groupBy.clear();
            s.groupBy.addAll(newGroupBy);
        });
    }

    @Override
    public final boolean $groupByDistinct() {
        return this.groupByDistinct;
    }

    @Override
    public final Select<R> $groupByDistinct(boolean newGroupByDistinct) {
        if (this.$groupByDistinct() == newGroupByDistinct) {
            return this;
        }
        return this.copy(s -> {
            s.groupByDistinct = newGroupByDistinct;
        });
    }

    @Override
    public final Condition $having() {
        return this.having.getWhereOrNull();
    }

    @Override
    public final Select<R> $having(Condition newHaving) {
        if (this.$having() == newHaving) {
            return this;
        }
        return this.copy(s -> s.having.setWhere(newHaving));
    }

    @Override
    public final QOM.UnmodifiableList<? extends WindowDefinition> $window() {
        return QOM.unmodifiable(this.window == null ? QueryPartList.emptyList() : this.window);
    }

    @Override
    public final Select<R> $window(Collection<? extends WindowDefinition> newWindow) {
        return this.copy(s -> {
            s.window.clear();
            s.window.addAll(newWindow);
        });
    }

    @Override
    public final Condition $qualify() {
        return this.qualify.getWhereOrNull();
    }

    @Override
    public final Select<R> $qualify(Condition newQualify) {
        if (this.$qualify() == newQualify) {
            return this;
        }
        return this.copy(s -> s.qualify.setWhere(newQualify));
    }

    @Override
    public final QOM.UnmodifiableList<SortField<?>> $orderBy() {
        return QOM.unmodifiable(this.orderBy);
    }

    @Override
    public final Select<R> $orderBy(Collection<? extends SortField<?>> newOrderBy) {
        return this.copy(s -> {
            s.orderBy.clear();
            s.orderBy.addAll(newOrderBy);
        });
    }

    @Override
    public final Field<? extends Number> $limit() {
        return this.getLimit().limit;
    }

    @Override
    public final Select<R> $limit(Field<? extends Number> newLimit) {
        if (this.$limit() == newLimit) {
            return this;
        }
        return this.copy(s -> s.getLimit().setLimit(newLimit));
    }

    @Override
    public final boolean $limitPercent() {
        return this.getLimit().percent;
    }

    @Override
    public final Select<R> $limitPercent(boolean newLimitPercent) {
        if (this.$limitPercent() == newLimitPercent) {
            return this;
        }
        return this.copy(s -> s.getLimit().setPercent(newLimitPercent));
    }

    @Override
    public final boolean $limitWithTies() {
        return this.getLimit().withTies;
    }

    @Override
    public final Select<R> $limitWithTies(boolean newLimitWithTies) {
        if (this.$limitPercent() == newLimitWithTies) {
            return this;
        }
        return this.copy(s -> s.getLimit().setWithTies(newLimitWithTies));
    }

    @Override
    public final Field<? extends Number> $offset() {
        return this.getLimit().offset;
    }

    @Override
    public final Select<R> $offset(Field<? extends Number> newOffset) {
        if (this.$limit() == newOffset) {
            return this;
        }
        return this.copy(s -> s.getLimit().setOffset(newOffset));
    }

    private static enum CopyClause {
        START,
        WHERE,
        QUALIFY,
        END;


        final boolean between(CopyClause startInclusive, CopyClause endExclusive) {
            return this.compareTo(startInclusive) >= 0 && this.compareTo(endExclusive) < 0;
        }
    }

    private record SelectFieldIndexes(boolean mapped, int[] mapping, int[] projectionSizes) {
    }
}

