/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeadersUtil;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends HttpCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final Logger logger = Logger.getLogger(HttpCommonAttributesGetter.class.getName());
    final GETTER getter;
    private final List<String> capturedRequestHeaders;
    private final List<String> capturedResponseHeaders;

    HttpCommonAttributesExtractor(GETTER getter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        this.getter = getter;
        this.capturedRequestHeaders = CapturedHttpHeadersUtil.lowercase(capturedRequestHeaders);
        this.capturedResponseHeaders = CapturedHttpHeadersUtil.lowercase(capturedResponseHeaders);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_METHOD, (Object)this.getter.getMethod(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.USER_AGENT_ORIGINAL, (Object)this.userAgent(request));
        for (String name : this.capturedRequestHeaders) {
            List<String> values = this.getter.getRequestHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.requestAttributeKey(name), values);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)this.requestContentLength(request));
        if (response != null) {
            Integer statusCode = this.getter.getStatusCode(request, response, error);
            if (statusCode != null && statusCode > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_STATUS_CODE, (Object)statusCode);
            }
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, (Object)this.responseContentLength(request, response));
            for (String name : this.capturedResponseHeaders) {
                List<String> values = this.getter.getResponseHeader(request, response, name);
                if (values.isEmpty()) continue;
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CapturedHttpHeadersUtil.responseAttributeKey(name), values);
            }
        }
    }

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getRequestHeader(request, "user-agent"));
    }

    @Nullable
    private Long requestContentLength(REQUEST request) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getRequestHeader(request, "content-length")));
    }

    @Nullable
    private Long responseContentLength(REQUEST request, RESPONSE response) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getResponseHeader(request, response, "content-length")));
    }

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }

    @Nullable
    private static Long parseNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static final class HttpNetNamePortGetter<REQUEST>
    implements FallbackNamePortGetter<REQUEST> {
        private final HttpCommonAttributesGetter<REQUEST, ?> getter;

        HttpNetNamePortGetter(HttpCommonAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        @Nullable
        public String name(REQUEST request) {
            String host = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getRequestHeader(request, "host"));
            if (host == null) {
                return null;
            }
            int hostHeaderSeparator = host.indexOf(58);
            return hostHeaderSeparator == -1 ? host : host.substring(0, hostHeaderSeparator);
        }

        @Override
        @Nullable
        public Integer port(REQUEST request) {
            String host = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getRequestHeader(request, "host"));
            if (host == null) {
                return null;
            }
            int hostHeaderSeparator = host.indexOf(58);
            if (hostHeaderSeparator == -1) {
                return null;
            }
            try {
                return Integer.parseInt(host.substring(hostHeaderSeparator + 1));
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return null;
            }
        }
    }
}

