/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.hazelcast.HazelcastCacheResolver;
import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnMissingBean(value={AsyncCacheResolver.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="hazelcast-reactive", matchIfMissing=true)
public class HazelcastReactiveBucket4jCacheConfiguration {
    private HazelcastInstance hazelcastInstance;

    public HazelcastReactiveBucket4jCacheConfiguration(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Bean
    public AsyncCacheResolver hazelcastCacheResolver() {
        return new HazelcastCacheResolver(this.hazelcastInstance, true);
    }
}

