/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheResolver;
import org.infinispan.manager.CacheContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={CacheContainer.class})
@ConditionalOnBean(value={CacheContainer.class})
@ConditionalOnMissingBean(value={AsyncCacheResolver.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="infinispan", matchIfMissing=true)
public class InfinispanBucket4jCacheConfiguration {
    private CacheContainer cacheContainer;

    public InfinispanBucket4jCacheConfiguration(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    @Bean
    public AsyncCacheResolver infinispanCacheResolver() {
        return new InfinispanCacheResolver(this.cacheContainer);
    }
}

