/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.exception.JCacheNotFoundException;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.grid.infinispan.InfinispanProxyManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.manager.CacheContainer;

public class InfinispanJCacheCacheResolver
implements SyncCacheResolver {
    private CacheContainer cacheContainer;

    public InfinispanJCacheCacheResolver(CacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    @Override
    public ProxyManagerWrapper resolve(String cacheName) {
        Cache cache = this.cacheContainer.getCache(cacheName);
        if (cache == null) {
            throw new JCacheNotFoundException(cacheName);
        }
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)cache.getAdvancedCache());
        InfinispanProxyManager infinispanProxyManager = new InfinispanProxyManager(ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap));
        return (key, numTokens, bucketConfiguration, metricsListener) -> {
            BucketProxy bucket = infinispanProxyManager.builder().build((Object)key, bucketConfiguration).toListenable((BucketListener)metricsListener);
            return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()));
        };
    }
}

