/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.lettuce;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.redis.lettuce.LettuceCacheResolver;
import io.github.bucket4j.redis.lettuce.cas.LettuceBasedProxyManager;
import io.lettuce.core.RedisClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={LettuceBasedProxyManager.class})
@ConditionalOnBean(value={RedisClient.class})
@ConditionalOnProperty(prefix="bucket4j", name={"cache-to-use"}, havingValue="redis-lettuce", matchIfMissing=true)
public class LettuceBucket4jConfiguration {
    @Bean
    public AsyncCacheResolver bucket4RedisResolver(RedisClient redisClient) {
        return new LettuceCacheResolver(redisClient);
    }
}

