/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class CreatorSheet
extends AbstractSheet {
    private static final int COL_WIDTH = 50;

    public CreatorSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < 25) {
            sheet.setColumnWidth(i, 12800);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            Cell headerCell = header.getCell(i);
            headerCell.setCellValue(docNames[i]);
            Object[] creators = comparer.getSpdxDoc(i).getCreationInfo().getCreators();
            Arrays.sort(creators);
            int j = 0;
            while (j < creators.length) {
                Cell creatorCell = null;
                while (j + 1 > this.getNumDataRows()) {
                    this.addRow();
                }
                creatorCell = this.sheet.getRow(j + 1).createCell(i);
                creatorCell.setCellValue((String)creators[j]);
                ++j;
            }
            ++i;
        }
    }
}

