/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class DocumentRelationshipSheet
extends AbstractSheet {
    RelationshipComparator relationshipComparator = new RelationshipComparator();
    static final int TYPE_COL = 0;
    static final int TYPE_COL_WIDTH = 25;
    static final String TYPE_COL_TEXT_TITLE = "Type";
    static final int FIRST_RELATIONSHIP_COL = 1;
    static final int FIRST_RELATIONSHIP_COL_WIDTH = 60;

    public DocumentRelationshipSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 6400);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell typeHeaderCell = row.createCell(0);
        typeHeaderCell.setCellStyle(headerStyle);
        typeHeaderCell.setCellValue(TYPE_COL_TEXT_TITLE);
        int i = 1;
        while (i < 25) {
            sheet.setColumnWidth(i, 15360);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] relationshipsIndexes = new int[comparer.getNumSpdxDocs()];
        Relationship[][] relationships = new Relationship[comparer.getNumSpdxDocs()][];
        int i = 0;
        while (i < relationships.length) {
            Cell headerCell = header.getCell(1 + i);
            headerCell.setCellValue(docNames[i]);
            Relationship[] docRelationships = comparer.getSpdxDoc(i).getRelationships();
            Arrays.sort(docRelationships, this.relationshipComparator);
            relationships[i] = docRelationships;
            relationshipsIndexes[i] = 0;
            ++i;
        }
        while (!this.allRelationshipsExhausted(relationships, relationshipsIndexes)) {
            Row currentRow = this.addRow();
            Relationship nextRelationship = this.getNexRelationship(relationships, relationshipsIndexes);
            Cell typeCell = currentRow.createCell(0);
            typeCell.setCellValue(nextRelationship.getRelationshipType().toTag());
            int i2 = 0;
            while (i2 < relationships.length) {
                Relationship compareRelationship;
                if (relationships[i2].length > relationshipsIndexes[i2] && this.relationshipComparator.compare(nextRelationship, compareRelationship = relationships[i2][relationshipsIndexes[i2]]) == 0) {
                    Cell relationshipCell = currentRow.createCell(1 + i2);
                    relationshipCell.setCellValue(CompareHelper.relationshipToString(relationships[i2][relationshipsIndexes[i2]]));
                    int n = i2;
                    relationshipsIndexes[n] = relationshipsIndexes[n] + 1;
                }
                ++i2;
            }
        }
    }

    private Relationship getNexRelationship(Relationship[][] relationships, int[] relationshipsIndexes) {
        Relationship retval = null;
        int i = 0;
        while (i < relationships.length) {
            if (relationships[i].length > relationshipsIndexes[i]) {
                Relationship candidate = relationships[i][relationshipsIndexes[i]];
                if (retval == null || this.relationshipComparator.compare(retval, candidate) > 0) {
                    retval = candidate;
                }
            }
            ++i;
        }
        return retval;
    }

    private boolean allRelationshipsExhausted(Relationship[][] relationships, int[] relationshipsIndexes) {
        int i = 0;
        while (i < relationships.length) {
            if (relationshipsIndexes[i] < relationships[i].length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String verify() {
        return null;
    }

    private static class RelationshipComparator
    implements Comparator<Relationship>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RelationshipComparator() {
        }

        @Override
        public int compare(Relationship o1, Relationship o2) {
            if (o1 != null) {
                if (o2 != null) {
                    Relationship r1 = o1;
                    Relationship r2 = o2;
                    int retval = r1.getRelationshipType().toString().compareTo(r2.getRelationshipType().toString());
                    if (retval != 0) {
                        return retval;
                    }
                    if (r1.getRelatedSpdxElement().equivalent(r2.getRelatedSpdxElement())) {
                        return 0;
                    }
                    if (r1.getRelatedSpdxElement().getName() != null && r2.getRelatedSpdxElement().getName() != null) {
                        return r1.getRelatedSpdxElement().getName().compareTo(r2.getRelatedSpdxElement().getName());
                    }
                    return r1.getRelatedSpdxElement().getId().compareTo(r2.getRelatedSpdxElement().getId());
                }
                return 1;
            }
            return -1;
        }
    }
}

