/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class DocumentSheet
extends AbstractSheet {
    int NUM_COLS = 12;
    int DOCUMENT_NAME_COL = 0;
    int SPDX_VERSION_COL = this.DOCUMENT_NAME_COL + 1;
    int DATA_LICENSE_COL = this.SPDX_VERSION_COL + 1;
    int SPDX_IDENTIFIER_COL = this.DATA_LICENSE_COL + 1;
    int DOCUMENT_NAMESPACE_COL = this.SPDX_IDENTIFIER_COL + 1;
    int SPDX_DOCUMENT_CONTENT_COL = this.DOCUMENT_NAMESPACE_COL + 1;
    int DOCUMENT_COMMENT_COL = this.SPDX_DOCUMENT_CONTENT_COL + 1;
    int CREATION_DATE_COL = this.DOCUMENT_COMMENT_COL + 1;
    int CREATOR_COMMENT_COL = this.CREATION_DATE_COL + 1;
    int LICENSE_LIST_VERSION_COL = this.CREATOR_COMMENT_COL + 1;
    int ANNOTATION_COL = this.LICENSE_LIST_VERSION_COL + 1;
    int RELATIONSHIP_COL = this.ANNOTATION_COL + 1;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    private static final String DIFFERENT_STRING = "Diff";
    private static final String EQUAL_STRING = "Equals";

    static {
        boolean[] blArray = new boolean[12];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[7] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"Document Name", "SPDX Version", "Data License", "ID", "Document Namespace", "Document Describes", "Document Comment", "Creation Date", "Creator Comment", "Lic. List. Ver.", "Annotations", "Relationships"};
        COLUMN_WIDTHS = new int[]{30, 15, 15, 15, 60, 40, 60, 22, 60, 22, 80, 80};
    }

    public DocumentSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        block5: {
            if (this.sheet != null) break block5;
            return "Worksheet for SPDX Package Info does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < this.NUM_COLS) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX Package Info worksheet";
                }
                ++i;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Package Info work sheet: " + ex.getMessage();
        }
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        int i = 0;
        while (i < docNames.length + 1) {
            this.addRow();
            ++i;
        }
        this.importDocumentNames(comparer);
        this.importSpdxVersion(comparer);
        this.importDataLicense(comparer);
        this.importSpdxId(comparer);
        this.importDocumentNamespace(comparer);
        this.importDocumentDescribes(comparer);
        this.importDocumentComments(comparer);
        this.importCreationDate(comparer);
        this.importCreatorComment(comparer);
        this.importLicenseListVersions(comparer);
        this.importAnnotations(comparer);
        this.importRelationships(comparer);
    }

    private void importRelationships(SpdxComparer comparer) throws SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.ANNOTATION_COL);
        if (comparer.isDocumentAnnotationsEquals()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.ANNOTATION_COL);
            cell.setCellValue(CompareHelper.annotationsToString(comparer.getSpdxDoc(i).getAnnotations()));
            ++i;
        }
    }

    private void importAnnotations(SpdxComparer comparer) throws SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.RELATIONSHIP_COL);
        if (comparer.isDocumentRelationshipsEquals()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.RELATIONSHIP_COL);
            cell.setCellValue(CompareHelper.relationshipsToString(comparer.getSpdxDoc(i).getRelationships()));
            ++i;
        }
    }

    private void importDocumentDescribes(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.SPDX_DOCUMENT_CONTENT_COL);
        if (comparer.isDocumentContentsEquals()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.SPDX_DOCUMENT_CONTENT_COL);
            cell.setCellValue(CompareHelper.formatSpdxElementList(comparer.getSpdxDoc(i).getDocumentDescribes()));
            ++i;
        }
    }

    private void importDocumentNamespace(SpdxComparer comparer) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DOCUMENT_NAMESPACE_COL);
        cell.setCellValue("N/A");
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DOCUMENT_NAMESPACE_COL);
            if (comparer.getSpdxDoc(i).getDocumentNamespace() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getDocumentNamespace());
            }
            ++i;
        }
    }

    private void importSpdxId(SpdxComparer comparer) throws SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.SPDX_IDENTIFIER_COL);
        cell.setCellValue("N/A");
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.SPDX_IDENTIFIER_COL);
            if (comparer.getSpdxDoc(i).getId() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getId());
            }
            ++i;
        }
    }

    private void importLicenseListVersions(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.LICENSE_LIST_VERSION_COL);
        if (comparer.isLicenseListVersionEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.LICENSE_LIST_VERSION_COL);
            if (comparer.getSpdxDoc(i).getCreationInfo().getLicenseListVersion() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getCreationInfo().getLicenseListVersion());
            }
            ++i;
        }
    }

    private void importSpdxVersion(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.SPDX_VERSION_COL);
        if (comparer.isSpdxVersionEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.SPDX_VERSION_COL);
            if (comparer.getSpdxDoc(i).getSpecVersion() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getSpecVersion());
            }
            ++i;
        }
    }

    private void importDataLicense(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DATA_LICENSE_COL);
        if (comparer.isDataLicenseEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DATA_LICENSE_COL);
            if (comparer.getSpdxDoc(i).getDataLicense() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getDataLicense().toString());
            }
            ++i;
        }
    }

    private void importDocumentComments(SpdxComparer comparer) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DOCUMENT_COMMENT_COL);
        if (comparer.isDocumentCommentsEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DOCUMENT_COMMENT_COL);
            if (comparer.getSpdxDoc(i).getComment() != null) {
                cell.setCellValue(comparer.getSpdxDoc(i).getComment());
            }
            ++i;
        }
    }

    private void importCreatorComment(SpdxComparer comparer) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.CREATOR_COMMENT_COL);
        if (comparer.isCreatorInformationEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.CREATOR_COMMENT_COL);
            cell.setCellValue(comparer.getSpdxDoc(i).getCreationInfo().getComment());
            ++i;
        }
    }

    private void importCreationDate(SpdxComparer comparer) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.CREATION_DATE_COL);
        if (comparer.isCreatorInformationEqual()) {
            this.setCellEqualValue(cell);
        } else {
            this.setCellDifferentValue(cell);
        }
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.CREATION_DATE_COL);
            cell.setCellValue(comparer.getSpdxDoc(i).getCreationInfo().getCreated());
            ++i;
        }
    }

    private void setCellDifferentValue(Cell cell) {
        cell.setCellValue(DIFFERENT_STRING);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellEqualValue(Cell cell) {
        cell.setCellValue(EQUAL_STRING);
        cell.setCellStyle(this.greenWrapped);
    }

    private void importDocumentNames(SpdxComparer comparer) throws SpdxCompareException {
        Cell cell = this.sheet.getRow(this.getFirstDataRow()).createCell(this.DOCUMENT_NAME_COL);
        cell.setCellValue("Compare Results");
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            cell = this.sheet.getRow(this.getFirstDataRow() + i + 1).createCell(this.DOCUMENT_NAME_COL);
            cell.setCellValue(comparer.getSpdxDoc(i).getName());
            ++i;
        }
    }
}

