/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.SpdxFile;

public class FileLicenseInfoSheet
extends AbstractFileCompareSheet {
    private static final int LICENSE_COL_WIDTH = 60;

    public FileLicenseInfoSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        if (spdxFile.getLicenseInfoFromFiles() == null || spdxFile.getLicenseInfoFromFiles().length == 0) {
            return "";
        }
        StringBuilder sb = spdxFile.getLicenseInfoFromFiles()[0] == null ? new StringBuilder("NULL") : new StringBuilder(spdxFile.getLicenseInfoFromFiles()[0].toString());
        int i = 1;
        while (i < spdxFile.getLicenseInfoFromFiles().length) {
            sb.append(", ");
            if (spdxFile.getLicenseInfoFromFiles()[i] == null) {
                sb.append("NULL");
            } else {
                sb.append(spdxFile.getLicenseInfoFromFiles()[i].toString());
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        AnyLicenseInfo[] licenseInfosB;
        AnyLicenseInfo[] licenseInfosA = fileA.getLicenseInfoFromFiles();
        if (licenseInfosA.length != (licenseInfosB = fileB.getLicenseInfoFromFiles()).length) {
            return false;
        }
        int i = 0;
        while (i < licenseInfosA.length) {
            boolean found = false;
            int j = 0;
            while (j < licenseInfosB.length) {
                if (comparer.compareLicense(docIndexA, licenseInfosA[i], docIndexB, licenseInfosB[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

