/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxPackageComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class PackageSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(PackageSheet.class);
    private static final int COL_WIDTH = 60;
    protected static final int FIELD_COL = 0;
    protected static final int EQUALS_COL = 1;
    protected static final int FIRST_DOC_COL = 2;
    private static final int FIELD_COL_WIDTH = 20;
    private static final int EQUALS_COL_WIDTH = 7;
    protected static final String FIELD_HEADER_TEXT = "Package Property";
    protected static final String EQUALS_HEADER_TEXT = "Equals";
    protected static final String DESCRIPTION_FIELD_TEXT = "Description";
    protected static final String SUMMARY_FIELD_TEXT = "Summary";
    protected static final String COPYRIGHT_FIELD_TEXT = "Copyright";
    protected static final String LICENSE_COMMENT_FIELD_TEXT = "License Comment";
    protected static final String DECLARED_LICENSE_FIELD_TEXT = "Declared License";
    protected static final String LICENSE_INFOS_FROM_FILES_FIELD_TEXT = "License From Files";
    protected static final String CONCLUDED_LICENSE_FIELD_TEXT = "Concluded License";
    protected static final String SOURCEINFO_FIELD_TEXT = "Source Info";
    protected static final String CHECKSUM_FIELD_TEXT = "Checksum";
    protected static final String VERIFICATION_EXCLUDED_FIELD_TEXT = "Verification Excluded";
    protected static final String VERIFICATION_FIELD_TEXT = "Verification Value";
    protected static final String DOWNLOAD_FIELD_TEXT = "Dowload Location";
    protected static final String ORIGINATOR_FIELD_TEXT = "Originator";
    protected static final String SUPPLIER_FIELD_TEXT = "Supplier";
    protected static final String FILE_NAME_FIELD_TEXT = "File Name";
    protected static final String VERSION_FIELD_TEXT = "Version";
    protected static final String PACKAGE_NAME_FIELD_TEXT = "Package Name";
    protected static final String DIFFERENT_STRING = "Diff";
    protected static final String EQUAL_STRING = "Equal";
    protected static final String MISSING_STRING = "Equal*";
    protected static final String HOMEPAGE_FIELD_TEXT = "Home Page";
    protected static final String ID_FIELD_TEXT = "SPDX ID";
    protected static final String ANNOTATION_FIELD_TEXT = "Annotations";
    protected static final String RELATIONSHIPS_FIELD_TEXT = "Relationships";
    protected static final String ATTRIBUTION_FIELD_TEXT = "Attributions";
    private static final String NO_PACKAGE = "[No Package]";
    private static final String FILES_ANALYZED_FIELD_TEXT = "Files Analyzed";
    private static final String EXTERNAL_REFS_FIELD_TEXT = "External Refs";
    private static final String NO_VALUE = "[No Value]";

    public PackageSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row headerRow = sheet.createRow(0);
        sheet.setColumnWidth(0, 5120);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell fieldCell = headerRow.createCell(0);
        fieldCell.setCellStyle(headerStyle);
        fieldCell.setCellValue(FIELD_HEADER_TEXT);
        sheet.setColumnWidth(1, 1792);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell equalsCell = headerRow.createCell(1);
        equalsCell.setCellStyle(headerStyle);
        equalsCell.setCellValue(EQUALS_HEADER_TEXT);
        int i = 2;
        while (i < 27) {
            sheet.setColumnWidth(i, 15360);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(headerStyle);
            ++i;
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int i = 0;
        while (i < comparer.getNumSpdxDocs()) {
            Cell headerCell = header.getCell(2 + i);
            headerCell.setCellValue(docNames[i]);
            ++i;
        }
        SpdxPackageComparer[] packagComparers = comparer.getPackageComparers();
        Arrays.sort(packagComparers, new Comparator<SpdxPackageComparer>(){

            @Override
            public int compare(SpdxPackageComparer o1, SpdxPackageComparer o2) {
                try {
                    return o1.getPackageName().compareTo(o2.getPackageName());
                }
                catch (SpdxCompareException e) {
                    logger.error("Error getting package names during compare", (Throwable)e);
                    return 0;
                }
            }
        });
        int i2 = 0;
        while (i2 < packagComparers.length) {
            this.addPackageToSheet(packagComparers[i2], comparer.getSpdxDocuments());
            ++i2;
        }
    }

    private void addPackageToSheet(SpdxPackageComparer comparer, SpdxDocument[] docs) throws InvalidSPDXAnalysisException, SpdxCompareException {
        Row packageNameRow = this.addRow();
        boolean allDocsPresent = comparer.getNumPackages() == docs.length;
        packageNameRow.createCell(0).setCellValue(PACKAGE_NAME_FIELD_TEXT);
        this.setCellEqualValue(packageNameRow.createCell(1), allDocsPresent);
        Row idRow = this.addRow();
        idRow.createCell(0).setCellValue(ID_FIELD_TEXT);
        this.setCellEqualValue(idRow.createCell(1), allDocsPresent);
        Row annotationsRow = this.addRow();
        annotationsRow.createCell(0).setCellValue(ANNOTATION_FIELD_TEXT);
        if (comparer.isAnnotationsEquals()) {
            this.setCellEqualValue(annotationsRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(annotationsRow.createCell(1));
        }
        Row relationshipsRow = this.addRow();
        relationshipsRow.createCell(0).setCellValue(RELATIONSHIPS_FIELD_TEXT);
        if (comparer.isRelationshipsEquals()) {
            this.setCellEqualValue(relationshipsRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(relationshipsRow.createCell(1));
        }
        Row versionRow = this.addRow();
        versionRow.createCell(0).setCellValue(VERSION_FIELD_TEXT);
        if (comparer.isPackageVersionsEquals()) {
            this.setCellEqualValue(versionRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(versionRow.createCell(1));
        }
        Row fileNameRow = this.addRow();
        fileNameRow.createCell(0).setCellValue(FILE_NAME_FIELD_TEXT);
        if (comparer.isPackageFilenamesEquals()) {
            this.setCellEqualValue(fileNameRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(fileNameRow.createCell(1));
        }
        Row supplierRow = this.addRow();
        supplierRow.createCell(0).setCellValue(SUPPLIER_FIELD_TEXT);
        if (comparer.isPackageSuppliersEquals()) {
            this.setCellEqualValue(supplierRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(supplierRow.createCell(1));
        }
        Row originatorRow = this.addRow();
        originatorRow.createCell(0).setCellValue(ORIGINATOR_FIELD_TEXT);
        if (comparer.isPackageOriginatorsEqual()) {
            this.setCellEqualValue(originatorRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(originatorRow.createCell(1));
        }
        Row downloadRow = this.addRow();
        downloadRow.createCell(0).setCellValue(DOWNLOAD_FIELD_TEXT);
        if (comparer.isPackageDownloadLocationsEquals()) {
            this.setCellEqualValue(downloadRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(downloadRow.createCell(1));
        }
        Row verificationRow = this.addRow();
        verificationRow.createCell(0).setCellValue(VERIFICATION_FIELD_TEXT);
        if (comparer.isPackageVerificationCodesEquals()) {
            this.setCellEqualValue(verificationRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(verificationRow.createCell(1));
        }
        Row verificationExcludedRow = this.addRow();
        verificationExcludedRow.createCell(0).setCellValue(VERIFICATION_EXCLUDED_FIELD_TEXT);
        if (comparer.isPackageVerificationCodesEquals()) {
            this.setCellEqualValue(verificationExcludedRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(verificationExcludedRow.createCell(1));
        }
        Row checksumRow = this.addRow();
        checksumRow.createCell(0).setCellValue(CHECKSUM_FIELD_TEXT);
        if (comparer.isPackageChecksumsEquals()) {
            this.setCellEqualValue(checksumRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(checksumRow.createCell(1));
        }
        Row homePageRow = this.addRow();
        homePageRow.createCell(0).setCellValue(HOMEPAGE_FIELD_TEXT);
        if (comparer.isPackageHomePagesEquals()) {
            this.setCellEqualValue(homePageRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(homePageRow.createCell(1));
        }
        Row sourceInfoRow = this.addRow();
        sourceInfoRow.createCell(0).setCellValue(SOURCEINFO_FIELD_TEXT);
        if (comparer.isPackageSourceInfosEquals()) {
            this.setCellEqualValue(sourceInfoRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(sourceInfoRow.createCell(1));
        }
        Row concludedLicenseRow = this.addRow();
        concludedLicenseRow.createCell(0).setCellValue(CONCLUDED_LICENSE_FIELD_TEXT);
        if (comparer.isConcludedLicenseEquals()) {
            this.setCellEqualValue(concludedLicenseRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(concludedLicenseRow.createCell(1));
        }
        Row licenseInfosFromFilesRow = this.addRow();
        licenseInfosFromFilesRow.createCell(0).setCellValue(LICENSE_INFOS_FROM_FILES_FIELD_TEXT);
        if (comparer.isSeenLicenseEquals()) {
            this.setCellEqualValue(licenseInfosFromFilesRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(licenseInfosFromFilesRow.createCell(1));
        }
        Row declaredLicenseRow = this.addRow();
        declaredLicenseRow.createCell(0).setCellValue(DECLARED_LICENSE_FIELD_TEXT);
        if (comparer.isDeclaredLicensesEquals()) {
            this.setCellEqualValue(declaredLicenseRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(declaredLicenseRow.createCell(1));
        }
        Row licenseCommentRow = this.addRow();
        licenseCommentRow.createCell(0).setCellValue(LICENSE_COMMENT_FIELD_TEXT);
        if (comparer.isLicenseCommmentsEquals()) {
            this.setCellEqualValue(licenseCommentRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(licenseCommentRow.createCell(1));
        }
        Row copyrightRow = this.addRow();
        copyrightRow.createCell(0).setCellValue(COPYRIGHT_FIELD_TEXT);
        if (comparer.isCopyrightsEquals()) {
            this.setCellEqualValue(copyrightRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(copyrightRow.createCell(1));
        }
        Row attributionRow = this.addRow();
        attributionRow.createCell(0).setCellValue(ATTRIBUTION_FIELD_TEXT);
        if (comparer.isAnnotationsEquals()) {
            this.setCellEqualValue(attributionRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(attributionRow.createCell(1));
        }
        Row summaryRow = this.addRow();
        summaryRow.createCell(0).setCellValue(SUMMARY_FIELD_TEXT);
        if (comparer.isPackageSummaryEquals()) {
            this.setCellEqualValue(summaryRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(summaryRow.createCell(1));
        }
        Row descriptionRow = this.addRow();
        descriptionRow.createCell(0).setCellValue(DESCRIPTION_FIELD_TEXT);
        if (comparer.isPackageDescriptionsEquals()) {
            this.setCellEqualValue(descriptionRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(descriptionRow.createCell(1));
        }
        Row filesAnalyzedRow = this.addRow();
        filesAnalyzedRow.createCell(0).setCellValue(FILES_ANALYZED_FIELD_TEXT);
        if (comparer.isFilesAnalyzedEquals()) {
            this.setCellEqualValue(filesAnalyzedRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(filesAnalyzedRow.createCell(1));
        }
        Row externalRefsRow = this.addRow();
        externalRefsRow.createCell(0).setCellValue(EXTERNAL_REFS_FIELD_TEXT);
        if (comparer.isExternalRefsEquals()) {
            this.setCellEqualValue(externalRefsRow.createCell(1), allDocsPresent);
        } else {
            this.setCellDifferentValue(externalRefsRow.createCell(1));
        }
        int i = 0;
        while (i < docs.length) {
            SpdxPackage pkg = comparer.getDocPackage(docs[i]);
            if (pkg != null) {
                packageNameRow.createCell(2 + i).setCellValue(pkg.getName());
                idRow.createCell(2 + i).setCellValue(pkg.getId());
                annotationsRow.createCell(2 + i).setCellValue(CompareHelper.annotationsToString(pkg.getAnnotations()));
                relationshipsRow.createCell(2 + i).setCellValue(CompareHelper.relationshipsToString(pkg.getRelationships()));
                versionRow.createCell(2 + i).setCellValue(pkg.getVersionInfo());
                fileNameRow.createCell(2 + i).setCellValue(pkg.getPackageFileName());
                supplierRow.createCell(2 + i).setCellValue(pkg.getSupplier());
                originatorRow.createCell(2 + i).setCellValue(pkg.getOriginator());
                downloadRow.createCell(2 + i).setCellValue(pkg.getDownloadLocation());
                SpdxPackageVerificationCode verificationCode = pkg.getPackageVerificationCode();
                if (verificationCode != null) {
                    verificationRow.createCell(2 + i).setCellValue(pkg.getPackageVerificationCode().getValue());
                    verificationExcludedRow.createCell(2 + i).setCellValue(this.exludeFilesToString(pkg.getPackageVerificationCode().getExcludedFileNames()));
                } else {
                    verificationRow.createCell(2 + i).setCellValue(NO_VALUE);
                    verificationExcludedRow.createCell(2 + i).setCellValue(NO_VALUE);
                }
                checksumRow.createCell(2 + i).setCellValue(CompareHelper.checksumsToString(pkg.getChecksums()));
                homePageRow.createCell(2 + i).setCellValue(pkg.getHomepage());
                sourceInfoRow.createCell(2 + i).setCellValue(pkg.getSourceInfo());
                concludedLicenseRow.createCell(2 + i).setCellValue(pkg.getLicenseConcluded().toString());
                licenseInfosFromFilesRow.createCell(2 + i).setCellValue(CompareHelper.licenseInfosToString(pkg.getLicenseInfoFromFiles()));
                declaredLicenseRow.createCell(2 + i).setCellValue(pkg.getLicenseDeclared().toString());
                licenseCommentRow.createCell(2 + i).setCellValue(pkg.getLicenseComments());
                copyrightRow.createCell(2 + i).setCellValue(pkg.getCopyrightText());
                attributionRow.createCell(2 + i).setCellValue(CompareHelper.attributionsToString(pkg.getAttributionText()));
                summaryRow.createCell(2 + i).setCellValue(pkg.getSummary());
                descriptionRow.createCell(2 + i).setCellValue(pkg.getDescription());
                filesAnalyzedRow.createCell(2 + i).setCellValue(pkg.isFilesAnalyzed());
                externalRefsRow.createCell(2 + i).setCellValue(CompareHelper.externalRefsToString(pkg.getExternalRefs(), docs[i].getDocumentNamespace()));
            } else {
                packageNameRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                idRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                annotationsRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                relationshipsRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                versionRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                fileNameRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                supplierRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                originatorRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                downloadRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                verificationRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                verificationExcludedRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                checksumRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                homePageRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                sourceInfoRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                concludedLicenseRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                licenseInfosFromFilesRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                declaredLicenseRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                licenseCommentRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                copyrightRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                summaryRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                descriptionRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                filesAnalyzedRow.createCell(2 + i).setCellValue(NO_PACKAGE);
                externalRefsRow.createCell(2 + i).setCellValue(NO_PACKAGE);
            }
            ++i;
        }
    }

    protected String exludeFilesToString(String[] excludedFileNames) {
        if (excludedFileNames == null || excludedFileNames.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(excludedFileNames[0]);
        int i = 1;
        while (i < excludedFileNames.length) {
            sb.append(", ");
            sb.append(excludedFileNames[i]);
            ++i;
        }
        return sb.toString();
    }

    private void setCellDifferentValue(Cell cell) {
        cell.setCellValue(DIFFERENT_STRING);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellEqualValue(Cell cell, boolean allPkgsPresent) {
        if (allPkgsPresent) {
            cell.setCellValue(EQUAL_STRING);
        } else {
            cell.setCellValue(MISSING_STRING);
        }
        cell.setCellStyle(this.greenWrapped);
    }
}

