/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxLicenseDifference;
import org.spdx.compare.SpdxPackageComparer;
import org.spdx.compare.SpdxSnippetComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;

public class SpdxComparer {
    private SpdxDocument[] spdxDocs = null;
    private boolean differenceFound = false;
    private boolean compareInProgress = false;
    private boolean spdxVersionsEqual = true;
    private boolean documentCommentsEqual = true;
    private boolean dataLicenseEqual = true;
    private boolean licenseListVersionEquals = true;
    private boolean documentContentsEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, SPDXReview[]>> uniqueReviews = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SPDXReviewDifference[]>> reviewerDifferences = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, ExtractedLicenseInfo[]>> uniqueExtractedLicenses = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxLicenseDifference[]>> licenseDifferences = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap = Maps.newHashMap();
    private boolean creatorInformationEquals;
    private Map<SpdxDocument, Map<SpdxDocument, String[]>> uniqueCreators = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxFile[]>> uniqueFiles = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxFileDifference[]>> fileDifferences = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxPackage[]>> uniquePackages = Maps.newHashMap();
    private Map<String, SpdxPackageComparer> packageComparers = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, Annotation[]>> uniqueDocumentAnnotations = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, Relationship[]>> uniqueDocumentRelationships = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, ExternalDocumentRef[]>> uniqueExternalDocumentRefs = Maps.newHashMap();
    private Map<SpdxDocument, Map<SpdxDocument, SpdxSnippet[]>> uniqueSnippets = Maps.newHashMap();
    private Map<String, SpdxSnippetComparer> snippetComparers = Maps.newHashMap();

    public void compare(SpdxDocument spdxDoc1, SpdxDocument spdxDoc2) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compare(new SpdxDocument[]{spdxDoc1, spdxDoc2});
    }

    public synchronized void compare(SpdxDocument[] spdxDocuments) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.clearCompareResults();
        this.spdxDocs = spdxDocuments;
        this.differenceFound = false;
        this.performCompare();
    }

    private void performCompare() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compareInProgress = true;
        this.differenceFound = false;
        this.compareExtractedLicenseInfos();
        this.compareDocumentFields();
        this.compareSnippets();
        this.compareFiles();
        this.comparePackages();
        this.compareReviewers();
        this.compareCreators();
        this.compareDocumentAnnotations();
        this.compareDocumentRelationships();
        this.compareExternalDocumentRefs();
        this.compareInProgress = false;
    }

    private void compareSnippets() throws SpdxCompareException {
        if (this.spdxDocs == null || this.spdxDocs.length < 1) {
            return;
        }
        this.uniqueSnippets.clear();
        this.snippetComparers.clear();
        int i = 0;
        while (i < this.spdxDocs.length) {
            List<SpdxSnippet> snippetsA;
            try {
                snippetsA = this.spdxDocs[i].getDocumentContainer().findAllSnippets();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("Error collecting snippets from SPDX document " + this.spdxDocs[i].getName(), e);
            }
            Collections.sort(snippetsA);
            this.addSnippetComparers(this.spdxDocs[i], snippetsA, this.extractedLicenseIdMap);
            HashMap uniqueAMap = this.uniqueSnippets.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (j != i) {
                    List<SpdxSnippet> snippetsB;
                    try {
                        snippetsB = this.spdxDocs[j].getDocumentContainer().findAllSnippets();
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new SpdxCompareException("Error collecting snippets from SPDX document " + this.spdxDocs[i].getName(), e);
                    }
                    Collections.sort(snippetsB);
                    SpdxSnippet[] uniqueAB = this.findUniqueSnippets(snippetsA, snippetsB);
                    if (uniqueAB != null && uniqueAB.length > 0) {
                        uniqueAMap.put(this.spdxDocs[j], uniqueAB);
                    }
                }
                ++j;
            }
            if (!uniqueAMap.isEmpty()) {
                this.uniqueSnippets.put(this.spdxDocs[i], uniqueAMap);
            }
            ++i;
        }
        if (!this._isSnippetsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private SpdxSnippet[] findUniqueSnippets(List<SpdxSnippet> snippetsA, List<SpdxSnippet> snippetsB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList alRetval = Lists.newArrayList();
        while (aIndex < snippetsA.size()) {
            if (bIndex >= snippetsB.size()) {
                alRetval.add(snippetsA.get(aIndex));
                ++aIndex;
                continue;
            }
            int compareVal = snippetsA.get(aIndex).compareTo(snippetsB.get(bIndex));
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(snippetsA.get(aIndex));
            ++aIndex;
        }
        return alRetval.toArray(new SpdxSnippet[alRetval.size()]);
    }

    private void addSnippetComparers(SpdxDocument spdxDocument, List<SpdxSnippet> snippets, Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap2) throws SpdxCompareException {
        for (SpdxSnippet snippet : snippets) {
            SpdxSnippetComparer comparer = this.snippetComparers.get(snippet.toString());
            if (comparer == null) {
                comparer = new SpdxSnippetComparer(this.extractedLicenseIdMap);
                this.snippetComparers.put(snippet.toString(), comparer);
            }
            comparer.addDocumentSnippet(spdxDocument, snippet);
        }
    }

    private void compareExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        int i = 0;
        while (i < this.spdxDocs.length) {
            ExternalDocumentRef[] externalDocRefsA = this.spdxDocs[i].getExternalDocumentRefs();
            HashMap uniqueAMap = this.uniqueExternalDocumentRefs.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                ExternalDocumentRef[] externalDocRefsB;
                ExternalDocumentRef[] uniqueA;
                if (j != i && (uniqueA = SpdxComparer.findUniqueExternalDocumentRefs(externalDocRefsA, externalDocRefsB = this.spdxDocs[j].getExternalDocumentRefs())) != null && uniqueA.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueA);
                }
                ++j;
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueExternalDocumentRefs.put(this.spdxDocs[i], uniqueAMap);
            }
            ++i;
        }
        if (!this._isExternalDcoumentRefsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentRelationships() {
        int i = 0;
        while (i < this.spdxDocs.length) {
            Relationship[] relationshipsA = this.spdxDocs[i].getRelationships();
            HashMap uniqueAMap = this.uniqueDocumentRelationships.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                Relationship[] relationshipsB;
                Relationship[] uniqueA;
                if (j != i && (uniqueA = SpdxComparer.findUniqueRelationships(relationshipsA, relationshipsB = this.spdxDocs[j].getRelationships())) != null && uniqueA.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueA);
                }
                ++j;
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueDocumentRelationships.put(this.spdxDocs[i], uniqueAMap);
            }
            ++i;
        }
        if (!this._isDocumentRelationshipsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentAnnotations() {
        int i = 0;
        while (i < this.spdxDocs.length) {
            Annotation[] annotationsA = this.spdxDocs[i].getAnnotations();
            HashMap uniqueAMap = this.uniqueDocumentAnnotations.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                Annotation[] annotationsB;
                Annotation[] uniqueA;
                if (j != i && (uniqueA = SpdxComparer.findUniqueAnnotations(annotationsA, annotationsB = this.spdxDocs[j].getAnnotations())) != null && uniqueA.length > 0) {
                    uniqueAMap.put(this.spdxDocs[j], uniqueA);
                }
                ++j;
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueDocumentAnnotations.put(this.spdxDocs[i], uniqueAMap);
            }
            ++i;
        }
        if (!this._isDocumentAnnotationsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareFiles() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.uniqueFiles.clear();
        this.fileDifferences.clear();
        int i = 0;
        while (i < this.spdxDocs.length) {
            HashMap diffMap;
            Object[] filesA = this.collectAllFiles(this.spdxDocs[i]);
            Arrays.sort(filesA);
            HashMap uniqueAMap = this.uniqueFiles.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            if ((diffMap = this.fileDifferences.get(this.spdxDocs[i])) == null) {
                diffMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (j != i) {
                    SpdxFileDifference[] differences;
                    Object[] filesB = this.collectAllFiles(this.spdxDocs[j]);
                    Arrays.sort(filesB);
                    SpdxFile[] uniqueAB = SpdxComparer.findUniqueFiles((SpdxFile[])filesA, (SpdxFile[])filesB);
                    if (uniqueAB != null && uniqueAB.length > 0) {
                        uniqueAMap.put(this.spdxDocs[j], uniqueAB);
                    }
                    if ((differences = SpdxComparer.findFileDifferences(this.spdxDocs[i], this.spdxDocs[j], (SpdxFile[])filesA, (SpdxFile[])filesB, this.extractedLicenseIdMap)) != null && differences.length > 0) {
                        diffMap.put(this.spdxDocs[j], differences);
                    }
                }
                ++j;
            }
            if (!uniqueAMap.isEmpty()) {
                this.uniqueFiles.put(this.spdxDocs[i], uniqueAMap);
            }
            if (!diffMap.isEmpty()) {
                this.fileDifferences.put(this.spdxDocs[i], diffMap);
            }
            ++i;
        }
        if (!this._isFilesEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void addAllRelatedFiles(SpdxElement element, Set<SpdxFile> files, Set<SpdxElement> visitedElements) throws InvalidSPDXAnalysisException {
        if (element == null || visitedElements.contains(element)) {
            return;
        }
        visitedElements.add(element);
        Relationship[] relationships = element.getRelationships();
        if (relationships != null) {
            int j = 0;
            while (j < relationships.length) {
                SpdxFile[] pkgFiles;
                if (relationships[j] != null && relationships[j].getRelatedSpdxElement() instanceof SpdxFile && !files.contains(relationships[j].getRelatedSpdxElement())) {
                    files.add((SpdxFile)relationships[j].getRelatedSpdxElement());
                } else if (relationships[j] != null && relationships[j].getRelatedSpdxElement() instanceof SpdxPackage && (pkgFiles = ((SpdxPackage)relationships[j].getRelatedSpdxElement()).getFiles()) != null) {
                    int k = 0;
                    while (k < pkgFiles.length) {
                        files.add(pkgFiles[k]);
                        ++k;
                    }
                }
                this.addAllRelatedFiles(relationships[j].getRelatedSpdxElement(), files, visitedElements);
                ++j;
            }
        }
    }

    private void addAllRelatedPackages(SpdxElement element, Set<SpdxPackage> pkgs, Set<SpdxElement> visitedElements) throws InvalidSPDXAnalysisException {
        if (element == null || visitedElements.contains(element)) {
            return;
        }
        visitedElements.add(element);
        Relationship[] relationships = element.getRelationships();
        if (relationships != null) {
            int j = 0;
            while (j < relationships.length) {
                if (relationships[j] != null && relationships[j].getRelatedSpdxElement() instanceof SpdxPackage && !pkgs.contains(relationships[j].getRelatedSpdxElement())) {
                    pkgs.add((SpdxPackage)relationships[j].getRelatedSpdxElement());
                }
                this.addAllRelatedPackages(relationships[j].getRelatedSpdxElement(), pkgs, visitedElements);
                ++j;
            }
        }
    }

    protected SpdxPackage[] collectAllPackages(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        HashSet retval = Sets.newHashSet();
        SpdxItem[] items = spdxDocument.getDocumentDescribes();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof SpdxPackage) {
                retval.add((SpdxPackage)items[i]);
            }
            this.addAllRelatedPackages(items[i], retval, Sets.newHashSet());
            ++i;
        }
        return retval.toArray(new SpdxPackage[retval.size()]);
    }

    protected SpdxFile[] collectAllFiles(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        HashSet retval = Sets.newHashSet();
        SpdxItem[] items = spdxDocument.getDocumentDescribes();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof SpdxFile) {
                retval.add((SpdxFile)items[i]);
            } else if (items[i] instanceof SpdxPackage) {
                SpdxFile[] pkgFiles = ((SpdxPackage)items[i]).getFiles();
                int j = 0;
                while (j < pkgFiles.length) {
                    retval.add(pkgFiles[j]);
                    ++j;
                }
            }
            this.addAllRelatedFiles(items[i], retval, Sets.newHashSet());
            ++i;
        }
        return retval.toArray(new SpdxFile[retval.size()]);
    }

    static SpdxFileDifference[] findFileDifferences(SpdxDocument docA, SpdxDocument docB, SpdxFile[] filesA, SpdxFile[] filesB, Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> licenseIdXlationMap) throws SpdxCompareException {
        ArrayList alRetval = Lists.newArrayList();
        int aIndex = 0;
        int bIndex = 0;
        while (aIndex < filesA.length && bIndex < filesB.length) {
            int compare = filesA[aIndex].getName().compareTo(filesB[bIndex].getName());
            if (compare == 0) {
                SpdxFileComparer fileComparer = new SpdxFileComparer(licenseIdXlationMap);
                fileComparer.addDocumentFile(docA, filesA[aIndex]);
                fileComparer.addDocumentFile(docB, filesB[bIndex]);
                if (fileComparer.isDifferenceFound()) {
                    alRetval.add(fileComparer.getFileDifference(docA, docB));
                }
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                ++bIndex;
                continue;
            }
            ++aIndex;
        }
        SpdxFileDifference[] retval = alRetval.toArray(new SpdxFileDifference[alRetval.size()]);
        return retval;
    }

    static SpdxPackage[] findUniquePackages(SpdxPackage[] pkgsA, SpdxPackage[] pkgsB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList alRetval = Lists.newArrayList();
        while (aIndex < pkgsA.length) {
            if (bIndex >= pkgsB.length) {
                alRetval.add(pkgsA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = pkgsA[aIndex].compareTo(pkgsB[bIndex]);
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(pkgsA[aIndex]);
            ++aIndex;
        }
        SpdxPackage[] retval = alRetval.toArray(new SpdxPackage[alRetval.size()]);
        return retval;
    }

    static SpdxFile[] findUniqueFiles(SpdxFile[] filesA, SpdxFile[] filesB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList alRetval = Lists.newArrayList();
        while (aIndex < filesA.length) {
            if (bIndex >= filesB.length) {
                alRetval.add(filesA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = filesA[aIndex].getName().compareTo(filesB[bIndex].getName());
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(filesA[aIndex]);
            ++aIndex;
        }
        SpdxFile[] retval = alRetval.toArray(new SpdxFile[alRetval.size()]);
        return retval;
    }

    private void compareCreators() throws InvalidSPDXAnalysisException {
        this.creatorInformationEquals = true;
        this.licenseListVersionEquals = true;
        int i = 0;
        while (i < this.spdxDocs.length) {
            SPDXCreatorInformation creatorInfoA = this.spdxDocs[i].getCreationInfo();
            String[] creatorsA = creatorInfoA.getCreators();
            HashMap uniqueAMap = this.uniqueCreators.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (j != i) {
                    SPDXCreatorInformation creatorInfoB = this.spdxDocs[j].getCreationInfo();
                    String[] creatorsB = creatorInfoB.getCreators();
                    String[] uniqueA = this.findUniqueString(creatorsA, creatorsB);
                    if (uniqueA != null && uniqueA.length > 0) {
                        uniqueAMap.put(this.spdxDocs[j], uniqueA);
                    }
                    if (!SpdxComparer.stringsEqual(creatorInfoA.getComment(), creatorInfoB.getComment())) {
                        this.creatorInformationEquals = false;
                    }
                    if (!SpdxComparer.stringsEqual(creatorInfoA.getCreated(), creatorInfoB.getCreated())) {
                        this.creatorInformationEquals = false;
                    }
                    if (!SpdxComparer.stringsEqual(creatorInfoA.getLicenseListVersion(), creatorInfoB.getLicenseListVersion())) {
                        this.creatorInformationEquals = false;
                        this.licenseListVersionEquals = false;
                    }
                }
                ++j;
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueCreators.put(this.spdxDocs[i], uniqueAMap);
                this.creatorInformationEquals = false;
            }
            ++i;
        }
        if (!this.creatorInformationEquals) {
            this.differenceFound = true;
        }
    }

    private String[] findUniqueString(String[] stringsA, String[] stringsB) {
        if (stringsA == null) {
            return new String[0];
        }
        if (stringsB == null) {
            return Arrays.copyOf(stringsA, stringsA.length);
        }
        ArrayList al = Lists.newArrayList();
        int i = 0;
        while (i < stringsA.length) {
            boolean found = false;
            int j = 0;
            while (j < stringsB.length) {
                if (stringsA[i].trim().equals(stringsB[j].trim())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                al.add(stringsA[i]);
            }
            ++i;
        }
        return al.toArray(new String[al.size()]);
    }

    private void comparePackages() throws SpdxCompareException {
        if (this.spdxDocs == null || this.spdxDocs.length < 1) {
            return;
        }
        this.uniquePackages.clear();
        this.packageComparers.clear();
        int i = 0;
        while (i < this.spdxDocs.length) {
            Object[] pkgsA;
            try {
                pkgsA = this.collectAllPackages(this.spdxDocs[i]);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("Error collecting packages from SPDX document " + this.spdxDocs[i].getName(), e);
            }
            Arrays.sort(pkgsA);
            this.addPackageComparers(this.spdxDocs[i], (SpdxPackage[])pkgsA, this.extractedLicenseIdMap);
            HashMap uniqueAMap = this.uniquePackages.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (j != i) {
                    Object[] pkgsB;
                    try {
                        pkgsB = this.collectAllPackages(this.spdxDocs[j]);
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new SpdxCompareException("Error collecting packages from SPDX document " + this.spdxDocs[i].getName(), e);
                    }
                    Arrays.sort(pkgsB);
                    SpdxPackage[] uniqueAB = SpdxComparer.findUniquePackages((SpdxPackage[])pkgsA, (SpdxPackage[])pkgsB);
                    if (uniqueAB != null && uniqueAB.length > 0) {
                        uniqueAMap.put(this.spdxDocs[j], uniqueAB);
                    }
                }
                ++j;
            }
            if (!uniqueAMap.isEmpty()) {
                this.uniquePackages.put(this.spdxDocs[i], uniqueAMap);
            }
            ++i;
        }
        if (!this._isPackagesEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void addPackageComparers(SpdxDocument spdxDocument, SpdxPackage[] pkgs, Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) throws SpdxCompareException {
        int i = 0;
        while (i < pkgs.length) {
            SpdxPackageComparer mpc = this.packageComparers.get(pkgs[i].getName());
            if (mpc == null) {
                mpc = new SpdxPackageComparer(extractedLicenseIdMap);
                this.packageComparers.put(pkgs[i].getName(), mpc);
            }
            mpc.addDocumentPackage(spdxDocument, pkgs[i]);
            ++i;
        }
    }

    public boolean compareLicense(int doc1, AnyLicenseInfo license1, int doc2, AnyLicenseInfo license2) throws SpdxCompareException {
        this.checkDocsIndex(doc1);
        this.checkDocsIndex(doc2);
        Map<SpdxDocument, Map<String, String>> hm = this.extractedLicenseIdMap.get(this.spdxDocs[doc1]);
        if (hm == null) {
            throw new SpdxCompareException("Compare License Error - Extracted license id map has not been initialized.");
        }
        Map<String, String> xlationMap = hm.get(this.spdxDocs[doc2]);
        if (xlationMap == null) {
            throw new SpdxCompareException("Compare License Exception - Extracted license id map has not been initialized.");
        }
        return LicenseCompareHelper.isLicenseEqual(license1, license2, xlationMap);
    }

    static boolean compareVerificationCodes(SpdxPackageVerificationCode verificationCode, SpdxPackageVerificationCode verificationCode2) {
        if (verificationCode == null) {
            return verificationCode2 == null;
        }
        if (verificationCode2 == null) {
            return false;
        }
        if (!SpdxComparer.stringsEqual(verificationCode.getValue(), verificationCode2.getValue())) {
            return false;
        }
        return SpdxComparer.stringArraysEqual(verificationCode.getExcludedFileNames(), verificationCode2.getExcludedFileNames());
    }

    private void compareDocumentFields() throws SpdxCompareException {
        this.compareDataLicense();
        this.compareDocumentComments();
        this.compareSpdxVerions();
        this.compareDocumentContents();
        if (!(this.dataLicenseEqual && this.spdxVersionsEqual && this.documentCommentsEqual)) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentContents() throws SpdxCompareException {
        this.documentContentsEquals = true;
        try {
            int i = 0;
            while (i < this.spdxDocs.length) {
                IRdfModel[] itemsA = this.spdxDocs[i].getDocumentDescribes();
                int j = i;
                while (j < this.spdxDocs.length) {
                    IRdfModel[] itemsB = this.spdxDocs[j].getDocumentDescribes();
                    if (!this.spdxDocs[i].arraysEquivalent(itemsA, itemsB)) {
                        this.documentContentsEquals = false;
                        this.differenceFound = true;
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new SpdxCompareException("Error getting SPDX document items: " + ex.getMessage());
        }
    }

    private void compareSpdxVerions() throws SpdxCompareException {
        String docVer1 = this.spdxDocs[0].getSpecVersion();
        this.spdxVersionsEqual = true;
        int i = 1;
        while (i < this.spdxDocs.length) {
            if (!this.spdxDocs[i].getSpecVersion().equals(docVer1)) {
                this.spdxVersionsEqual = false;
                break;
            }
            ++i;
        }
    }

    private void compareDocumentComments() throws SpdxCompareException {
        String comment1 = this.spdxDocs[0].getComment();
        this.documentCommentsEqual = true;
        int i = 1;
        while (i < this.spdxDocs.length) {
            String comment2 = this.spdxDocs[i].getComment();
            if (!SpdxComparer.stringsEqual(comment1, comment2)) {
                this.documentCommentsEqual = false;
                break;
            }
            ++i;
        }
    }

    private void compareDataLicense() throws SpdxCompareException {
        try {
            AnyLicenseInfo lic1 = this.spdxDocs[0].getDataLicense();
            this.dataLicenseEqual = true;
            int i = 1;
            while (i < this.spdxDocs.length) {
                if (!lic1.equals(this.spdxDocs[i].getDataLicense())) {
                    this.dataLicenseEqual = false;
                    break;
                }
                ++i;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX analysis error during compare data license: " + e.getMessage(), e);
        }
    }

    private void compareExtractedLicenseInfos() throws InvalidSPDXAnalysisException, SpdxCompareException {
        int i = 0;
        while (i < this.spdxDocs.length) {
            ExtractedLicenseInfo[] extractedLicensesA = this.spdxDocs[i].getExtractedLicenseInfos();
            HashMap uniqueMap = Maps.newHashMap();
            HashMap differenceMap = Maps.newHashMap();
            HashMap licenseIdMap = Maps.newHashMap();
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (i != j) {
                    HashMap idMap = Maps.newHashMap();
                    ArrayList alDifferences = Lists.newArrayList();
                    ExtractedLicenseInfo[] extractedLicensesB = this.spdxDocs[j].getExtractedLicenseInfos();
                    ArrayList uniqueLicenses = Lists.newArrayList();
                    this.compareLicenses(extractedLicensesA, extractedLicensesB, idMap, alDifferences, uniqueLicenses);
                    if (uniqueLicenses.size() > 0) {
                        uniqueMap.put(this.spdxDocs[j], uniqueLicenses.toArray(new ExtractedLicenseInfo[uniqueLicenses.size()]));
                    }
                    if (alDifferences.size() > 0) {
                        differenceMap.put(this.spdxDocs[j], alDifferences.toArray(new SpdxLicenseDifference[alDifferences.size()]));
                    }
                    licenseIdMap.put(this.spdxDocs[j], idMap);
                }
                ++j;
            }
            if (uniqueMap.keySet().size() > 0) {
                this.uniqueExtractedLicenses.put(this.spdxDocs[i], uniqueMap);
            }
            if (differenceMap.keySet().size() > 0) {
                this.licenseDifferences.put(this.spdxDocs[i], differenceMap);
            }
            this.extractedLicenseIdMap.put(this.spdxDocs[i], licenseIdMap);
            ++i;
        }
        if (!this._isExtractedLicensingInfoEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareLicenses(ExtractedLicenseInfo[] extractedLicensesA, ExtractedLicenseInfo[] extractedLicensesB, Map<String, String> idMap, List<SpdxLicenseDifference> alDifferences, List<ExtractedLicenseInfo> uniqueLicenses) {
        idMap.clear();
        alDifferences.clear();
        uniqueLicenses.clear();
        int k = 0;
        while (k < extractedLicensesA.length) {
            boolean foundMatch = false;
            boolean foundTextMatch = false;
            int q = 0;
            while (q < extractedLicensesB.length) {
                if (LicenseCompareHelper.isLicenseTextEquivalent(extractedLicensesA[k].getExtractedText(), extractedLicensesB[q].getExtractedText())) {
                    foundTextMatch = true;
                    if (!foundMatch) {
                        idMap.put(extractedLicensesA[k].getLicenseId(), extractedLicensesB[q].getLicenseId());
                    }
                    if (this.nonTextLicenseFieldsEqual(extractedLicensesA[k], extractedLicensesB[q])) {
                        foundMatch = true;
                    } else {
                        alDifferences.add(new SpdxLicenseDifference(extractedLicensesA[k], extractedLicensesB[q]));
                    }
                }
                ++q;
            }
            if (!foundTextMatch) {
                uniqueLicenses.add(extractedLicensesA[k]);
            }
            ++k;
        }
    }

    private boolean nonTextLicenseFieldsEqual(ExtractedLicenseInfo spdxNonStandardLicenseA, ExtractedLicenseInfo spdxNonStandardLicenseB) {
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getName(), spdxNonStandardLicenseB.getName())) {
            return false;
        }
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getComment(), spdxNonStandardLicenseB.getComment())) {
            return false;
        }
        return SpdxComparer.stringArraysEqual(spdxNonStandardLicenseA.getSeeAlso(), spdxNonStandardLicenseB.getSeeAlso());
    }

    static boolean stringArraysEqual(String[] stringsA, String[] stringsB) {
        if (stringsA == null) {
            if (stringsB != null) {
                return false;
            }
        } else {
            if (stringsB == null) {
                return false;
            }
            if (stringsA.length != stringsB.length) {
                return false;
            }
            HashSet foundIndexes = Sets.newHashSet();
            int i = 0;
            while (i < stringsA.length) {
                boolean found = false;
                int j = 0;
                while (j < stringsB.length) {
                    if (!foundIndexes.contains(j) && SpdxComparer.stringsEqual(stringsA[i], stringsB[j])) {
                        found = true;
                        foundIndexes.add(j);
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static boolean elementsEquivalent(RdfModelObject elementA, RdfModelObject elementB) {
        if (elementA == null) {
            return elementB == null;
        }
        return elementA.equivalent(elementB);
    }

    public static boolean arraysEqual(Object[] a1, Object[] a2) {
        if (a1 == null) {
            if (a2 != null) {
                return false;
            }
        } else {
            if (a2 == null) {
                return false;
            }
            if (a1.length != a2.length) {
                return false;
            }
            int i = 0;
            while (i < a1.length) {
                boolean found = false;
                int j = 0;
                while (j < a2.length) {
                    if (SpdxComparer.objectsEqual(a1[i], a2[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean stringsEqual(String stringA, String stringB) {
        String compA = stringA == null ? "" : stringA.replace("\r\n", "\n").trim();
        String compB = stringB == null ? "" : stringB.replace("\r\n", "\n").trim();
        return compA.equals(compB);
    }

    public static int compareStrings(String stringA, String stringB) {
        if (stringA == null) {
            if (stringB == null) {
                return 0;
            }
            return -1;
        }
        if (stringB == null) {
            return 1;
        }
        return stringA.trim().compareTo(stringB.trim());
    }

    private void compareReviewers() throws InvalidSPDXAnalysisException, SpdxCompareException {
        int i = 0;
        while (i < this.spdxDocs.length) {
            HashMap diffMap;
            SPDXReview[] reviewA = this.spdxDocs[i].getReviewers();
            HashMap uniqueAMap = this.uniqueReviews.get(this.spdxDocs[i]);
            if (uniqueAMap == null) {
                uniqueAMap = Maps.newHashMap();
            }
            if ((diffMap = this.reviewerDifferences.get(this.spdxDocs[i])) == null) {
                diffMap = Maps.newHashMap();
            }
            int j = 0;
            while (j < this.spdxDocs.length) {
                if (j != i) {
                    SPDXReviewDifference[] reviewerDifferences;
                    SPDXReview[] reviewB = this.spdxDocs[j].getReviewers();
                    SPDXReview[] uniqueA = this.findUniqueReviewers(reviewA, reviewB);
                    if (uniqueA != null && uniqueA.length > 0) {
                        uniqueAMap.put(this.spdxDocs[j], uniqueA);
                    }
                    if ((reviewerDifferences = this.findReviewerDifferences(reviewA, reviewB)) != null && reviewerDifferences.length > 0) {
                        diffMap.put(this.spdxDocs[j], reviewerDifferences);
                    }
                }
                ++j;
            }
            if (uniqueAMap.keySet().size() > 0) {
                this.uniqueReviews.put(this.spdxDocs[i], uniqueAMap);
            }
            if (diffMap.keySet().size() > 0) {
                this.reviewerDifferences.put(this.spdxDocs[i], diffMap);
            }
            ++i;
        }
        if (!this._isReviewersEqualNoCheck()) {
            this.differenceFound = true;
        }
    }

    private SPDXReviewDifference[] findReviewerDifferences(SPDXReview[] reviewA, SPDXReview[] reviewB) {
        ArrayList retval = Lists.newArrayList();
        int i = 0;
        while (i < reviewA.length) {
            boolean reviewDifferent = false;
            int differentReviewerIndex = -1;
            int j = 0;
            while (j < reviewB.length) {
                if (reviewA[i].getReviewer().trim().equals(reviewB[j].getReviewer().trim())) {
                    boolean commentsEqual = reviewA[i].getComment().trim().equals(reviewB[j].getComment().trim());
                    boolean datesEqual = reviewA[i].getReviewDate().equals(reviewB[j].getReviewDate());
                    if (commentsEqual && datesEqual) {
                        reviewDifferent = false;
                        break;
                    }
                    reviewDifferent = true;
                    differentReviewerIndex = j;
                }
                ++j;
            }
            if (reviewDifferent) {
                retval.add(new SPDXReviewDifference(reviewA[i], reviewB[differentReviewerIndex]));
            }
            ++i;
        }
        return retval.toArray(new SPDXReviewDifference[retval.size()]);
    }

    private SPDXReview[] findUniqueReviewers(SPDXReview[] reviewA, SPDXReview[] reviewB) {
        ArrayList retval = Lists.newArrayList();
        int i = 0;
        while (i < reviewA.length) {
            boolean found = false;
            int j = 0;
            while (j < reviewB.length) {
                if (reviewA[i].getReviewer().trim().equals(reviewB[j].getReviewer().trim())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                retval.add(reviewA[i]);
            }
            ++i;
        }
        return retval.toArray(new SPDXReview[retval.size()]);
    }

    private void clearCompareResults() {
        this.differenceFound = false;
        this.reviewerDifferences.clear();
        this.uniqueReviews.clear();
        this.licenseDifferences.clear();
        this.uniqueExtractedLicenses.clear();
        this.extractedLicenseIdMap.clear();
        this.uniqueCreators.clear();
    }

    public boolean isDifferenceFound() {
        return this.differenceFound;
    }

    public boolean isSpdxVersionEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.spdxVersionsEqual;
    }

    private void checkInProgress() throws SpdxCompareException {
        if (this.compareInProgress) {
            throw new SpdxCompareException("Compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkDocsField() throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (this.spdxDocs.length < 2) {
            throw new SpdxCompareException("Insufficient documents compared - must provide at least 2 SPDX documents");
        }
    }

    private void checkDocsIndex(int index) throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (index < 0) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - must be greater than or equal to zero");
        }
        if (index >= this.spdxDocs.length) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - SPDX document index " + String.valueOf(index) + " does not exist.");
        }
    }

    public SpdxDocument getSpdxDoc(int docIndex) throws SpdxCompareException {
        this.checkDocsField();
        if (this.spdxDocs == null) {
            return null;
        }
        if (docIndex < 0) {
            return null;
        }
        if (docIndex > this.spdxDocs.length) {
            return null;
        }
        return this.spdxDocs[docIndex];
    }

    public boolean isDataLicenseEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.dataLicenseEqual;
    }

    public boolean isDocumentCommentsEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.documentCommentsEqual;
    }

    public boolean isReviewersEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isReviewersEqualNoCheck();
    }

    private boolean _isReviewersEqualNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Object[]>> entryIter;
        for (Map.Entry<SpdxDocument, Map<SpdxDocument, SPDXReview[]>> entry : this.uniqueReviews.entrySet()) {
            entryIter = entry.getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SPDXReview[] val = entryIter.next().getValue();
                if (val == null || val.length <= 0) continue;
                return false;
            }
        }
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, SPDXReviewDifference[]>>> diffIter = this.reviewerDifferences.entrySet().iterator();
        while (diffIter.hasNext()) {
            entryIter = diffIter.next().getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SPDXReviewDifference[] reviewDifferences = (SPDXReviewDifference[])entryIter.next().getValue();
                if (reviewDifferences == null || reviewDifferences.length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean _isExternalDcoumentRefsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, ExternalDocumentRef[]>>> iter = this.uniqueExternalDocumentRefs.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<ExternalDocumentRef[]> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isExternalDcoumentRefsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isExternalDcoumentRefsEqualsNoCheck();
    }

    public boolean isExtractedLicensingInfosEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isExtractedLicensingInfoEqualsNoCheck();
    }

    private boolean _isExtractedLicensingInfoEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Object[]>> entryIter;
        for (Map.Entry<SpdxDocument, Map<SpdxDocument, ExtractedLicenseInfo[]>> entry : this.uniqueExtractedLicenses.entrySet()) {
            entryIter = entry.getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                ExtractedLicenseInfo[] licenses = entryIter.next().getValue();
                if (licenses == null || licenses.length <= 0) continue;
                return false;
            }
        }
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, SpdxLicenseDifference[]>>> diffIterator = this.licenseDifferences.entrySet().iterator();
        while (diffIterator.hasNext()) {
            entryIter = diffIterator.next().getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                SpdxLicenseDifference[] differences = (SpdxLicenseDifference[])entryIter.next().getValue();
                if (differences == null || differences.length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public SPDXReview[] getUniqueReviewers(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, SPDXReview[]> uniques = this.uniqueReviews.get(this.spdxDocs[docindex1]);
        if (uniques != null) {
            SPDXReview[] retval = uniques.get(this.spdxDocs[docindex2]);
            if (retval != null) {
                return retval;
            }
            return new SPDXReview[0];
        }
        return new SPDXReview[0];
    }

    public SPDXReviewDifference[] getReviewerDifferences(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, SPDXReviewDifference[]> doc1Differences = this.reviewerDifferences.get(this.spdxDocs[docindex1]);
        if (doc1Differences == null) {
            return new SPDXReviewDifference[0];
        }
        SPDXReviewDifference[] retval = doc1Differences.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SPDXReviewDifference[0];
        }
        return retval;
    }

    public ExtractedLicenseInfo[] getUniqueExtractedLicenses(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        Map<SpdxDocument, ExtractedLicenseInfo[]> uniques = this.uniqueExtractedLicenses.get(this.spdxDocs[docIndexA]);
        if (uniques != null) {
            ExtractedLicenseInfo[] retval = uniques.get(this.spdxDocs[docIndexB]);
            if (retval != null) {
                return retval;
            }
            return new ExtractedLicenseInfo[0];
        }
        return new ExtractedLicenseInfo[0];
    }

    public SpdxLicenseDifference[] getExtractedLicenseDifferences(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        Map<SpdxDocument, SpdxLicenseDifference[]> differences = this.licenseDifferences.get(this.spdxDocs[docIndexA]);
        if (differences != null) {
            SpdxLicenseDifference[] retval = differences.get(this.spdxDocs[docIndexB]);
            if (retval != null) {
                return retval;
            }
            return new SpdxLicenseDifference[0];
        }
        return new SpdxLicenseDifference[0];
    }

    public boolean isCreatorInformationEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.creatorInformationEquals;
    }

    public String[] getUniqueCreators(int doc1index, int doc2index) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        Map<SpdxDocument, String[]> uniques = this.uniqueCreators.get(this.getSpdxDoc(doc1index));
        if (uniques == null) {
            return new String[0];
        }
        String[] retval = uniques.get(this.getSpdxDoc(doc2index));
        if (retval == null) {
            return new String[0];
        }
        return retval;
    }

    public boolean isfilesEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isFilesEqualsNoCheck();
    }

    public boolean isPackagesEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isPackagesEqualsNoCheck();
    }

    public boolean isDocumentAnnotationsEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isDocumentAnnotationsEqualsNoCheck();
    }

    private boolean _isDocumentAnnotationsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, Annotation[]>>> iter = this.uniqueDocumentAnnotations.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<Annotation[]> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDocumentRelationshipsEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isDocumentRelationshipsEqualsNoCheck();
    }

    private boolean _isDocumentRelationshipsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, Relationship[]>>> iter = this.uniqueDocumentRelationships.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<Relationship[]> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean _isFilesEqualsNoCheck() {
        if (!this.uniqueFiles.isEmpty()) {
            return false;
        }
        return this.fileDifferences.isEmpty();
    }

    private boolean _isPackagesEqualsNoCheck() throws SpdxCompareException {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, SpdxPackage[]>>> iter = this.uniquePackages.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<SpdxPackage[]> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().length <= 0) continue;
                return false;
            }
        }
        Iterator<SpdxPackageComparer> diffIter = this.packageComparers.values().iterator();
        while (diffIter.hasNext()) {
            if (!diffIter.next().isDifferenceFound()) continue;
            return false;
        }
        return true;
    }

    public SpdxFile[] getUniqueFiles(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, SpdxFile[]> uniqueMap = this.uniqueFiles.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new SpdxFile[0];
        }
        SpdxFile[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SpdxFile[0];
        }
        return retval;
    }

    public SpdxFileDifference[] getFileDifferences(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, SpdxFileDifference[]> uniqueMap = this.fileDifferences.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new SpdxFileDifference[0];
        }
        SpdxFileDifference[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SpdxFileDifference[0];
        }
        return retval;
    }

    public SpdxPackage[] getUniquePackages(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, SpdxPackage[]> uniqueMap = this.uniquePackages.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new SpdxPackage[0];
        }
        SpdxPackage[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new SpdxPackage[0];
        }
        return retval;
    }

    public ExternalDocumentRef[] getUniqueExternalDocumentRefs(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, ExternalDocumentRef[]> uniqueMap = this.uniqueExternalDocumentRefs.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new ExternalDocumentRef[0];
        }
        ExternalDocumentRef[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new ExternalDocumentRef[0];
        }
        return retval;
    }

    public Annotation[] getUniqueDocumentAnnotations(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, Annotation[]> uniqueMap = this.uniqueDocumentAnnotations.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new Annotation[0];
        }
        Annotation[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new Annotation[0];
        }
        return retval;
    }

    public Relationship[] getUniqueDocumentRelationship(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, Relationship[]> uniqueMap = this.uniqueDocumentRelationships.get(this.spdxDocs[docindex1]);
        if (uniqueMap == null) {
            return new Relationship[0];
        }
        Relationship[] retval = uniqueMap.get(this.spdxDocs[docindex2]);
        if (retval == null) {
            return new Relationship[0];
        }
        return retval;
    }

    public SpdxPackageComparer[] getPackageDifferences() throws SpdxCompareException {
        Collection<SpdxPackageComparer> comparers = this.packageComparers.values();
        Iterator<SpdxPackageComparer> iter = comparers.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (!iter.next().isDifferenceFound()) continue;
            ++count;
        }
        SpdxPackageComparer[] retval = new SpdxPackageComparer[count];
        iter = comparers.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SpdxPackageComparer comparer = iter.next();
            if (!comparer.isDifferenceFound()) continue;
            retval[i++] = comparer;
        }
        return retval;
    }

    public SpdxPackageComparer[] getPackageComparers() {
        return this.packageComparers.values().toArray(new SpdxPackageComparer[this.packageComparers.values().size()]);
    }

    public int getNumSpdxDocs() {
        return this.spdxDocs.length;
    }

    public boolean isLicenseListVersionEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.licenseListVersionEquals;
    }

    public static Checksum[] findUniqueChecksums(Checksum[] checksumsA, Checksum[] checksumsB) {
        ArrayList retval = Lists.newArrayList();
        if (checksumsA != null) {
            int i = 0;
            while (i < checksumsA.length) {
                if (checksumsA[i] != null) {
                    boolean found = false;
                    if (checksumsB != null) {
                        int j = 0;
                        while (j < checksumsB.length) {
                            if (checksumsA[i].equivalent(checksumsB[j])) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!found) {
                        retval.add(checksumsA[i]);
                    }
                }
                ++i;
            }
        }
        return retval.toArray(new Checksum[retval.size()]);
    }

    public static Annotation[] findUniqueAnnotations(Annotation[] annotationsA, Annotation[] annotationsB) {
        ArrayList retval = Lists.newArrayList();
        if (annotationsA != null) {
            int i = 0;
            while (i < annotationsA.length) {
                if (annotationsA[i] != null) {
                    boolean found = false;
                    if (annotationsB != null) {
                        int j = 0;
                        while (j < annotationsB.length) {
                            if (annotationsA[i].equivalent(annotationsB[j])) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!found) {
                        retval.add(annotationsA[i]);
                    }
                }
                ++i;
            }
        }
        return retval.toArray(new Annotation[retval.size()]);
    }

    public static boolean elementsEquivalent(RdfModelObject[] elementsA, RdfModelObject[] elementsB) {
        if (elementsA == null) {
            return elementsB == null;
        }
        if (elementsB == null) {
            return false;
        }
        if (elementsA.length != elementsB.length) {
            return false;
        }
        HashSet matchedIndexes = Sets.newHashSet();
        int i = 0;
        while (i < elementsA.length) {
            boolean found = false;
            int j = 0;
            while (j < elementsB.length) {
                if (!matchedIndexes.contains(j) && elementsA[i].equivalent(elementsB[j])) {
                    found = true;
                    matchedIndexes.add(j);
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Relationship[] findUniqueRelationships(Relationship[] relationshipsA, Relationship[] relationshipsB) {
        ArrayList retval = Lists.newArrayList();
        if (relationshipsA == null) {
            return new Relationship[0];
        }
        int i = 0;
        while (i < relationshipsA.length) {
            if (relationshipsA[i] != null) {
                boolean found = false;
                if (relationshipsB != null) {
                    int j = 0;
                    while (j < relationshipsB.length) {
                        if (relationshipsA[i].equivalent(relationshipsB[j])) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    retval.add(relationshipsA[i]);
                }
            }
            ++i;
        }
        return retval.toArray(new Relationship[retval.size()]);
    }

    public static ExternalDocumentRef[] findUniqueExternalDocumentRefs(ExternalDocumentRef[] externalDocRefsA, ExternalDocumentRef[] externalDocRefsB) throws InvalidSPDXAnalysisException {
        ArrayList retval = Lists.newArrayList();
        if (externalDocRefsA == null) {
            return new ExternalDocumentRef[0];
        }
        int i = 0;
        while (i < externalDocRefsA.length) {
            if (externalDocRefsA[i] != null) {
                boolean found = false;
                if (externalDocRefsB != null) {
                    int j = 0;
                    while (j < externalDocRefsB.length) {
                        if (SpdxComparer.compareStrings(externalDocRefsA[i].getSpdxDocumentNamespace(), externalDocRefsB[j].getSpdxDocumentNamespace()) == 0 && SpdxComparer.elementsEquivalent(externalDocRefsA[i].getChecksum(), externalDocRefsB[j].getChecksum())) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    retval.add(externalDocRefsA[i]);
                }
            }
            ++i;
        }
        return retval.toArray(new ExternalDocumentRef[retval.size()]);
    }

    public SpdxDocument[] getSpdxDocuments() {
        return this.spdxDocs;
    }

    public boolean isDocumentContentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.documentContentsEquals;
    }

    public boolean isSnippetsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isSnippetsEqualsNoCheck();
    }

    private boolean _isSnippetsEqualsNoCheck() throws SpdxCompareException {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, SpdxSnippet[]>>> iter = this.uniqueSnippets.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<SpdxSnippet[]> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().length <= 0) continue;
                return false;
            }
        }
        Iterator<SpdxSnippetComparer> diffIter = this.snippetComparers.values().iterator();
        while (diffIter.hasNext()) {
            if (!diffIter.next().isDifferenceFound()) continue;
            return false;
        }
        return true;
    }

    public SpdxSnippetComparer[] getSnippetComparers() {
        return this.snippetComparers.values().toArray(new SpdxSnippetComparer[this.snippetComparers.values().size()]);
    }

    public static class SPDXReviewDifference {
        boolean commentsEqual;
        boolean datesEqual;
        String comment1;
        String comment2;
        String date1;
        String date2;
        String reviewer;

        public SPDXReviewDifference(SPDXReview spdxReview, SPDXReview spdxReview2) {
            this.commentsEqual = spdxReview.getComment().trim().equals(spdxReview2.getComment().trim());
            this.datesEqual = spdxReview.getReviewDate().equals(spdxReview2.getReviewDate());
            this.comment1 = spdxReview.getComment();
            this.comment2 = spdxReview2.getComment();
            this.date1 = spdxReview.getReviewDate();
            this.date2 = spdxReview2.getReviewDate();
            this.reviewer = spdxReview.getReviewer();
        }

        public boolean isDateEqual() {
            return this.datesEqual;
        }

        public String getReviewer() {
            return this.reviewer;
        }

        public String getDate(int i) throws SpdxCompareException {
            if (i == 0) {
                return this.date1;
            }
            if (i == 1) {
                return this.date2;
            }
            throw new SpdxCompareException("Invalid index for get reviewer date");
        }

        public boolean isCommentEqual() {
            return this.commentsEqual;
        }

        public String getComment(int i) throws SpdxCompareException {
            if (i == 0) {
                return this.comment1;
            }
            if (i == 1) {
                return this.comment2;
            }
            throw new SpdxCompareException("Invalid index for get reviewer date");
        }
    }
}

