/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.spdx.html.AnnotationContext;
import org.spdx.html.RelationshipContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.rdfparser.model.pointer.StartEndPointer;

public class SnippetContext {
    private SpdxSnippet snippet;
    private Map<String, String> spdxIdToUrl;
    private Exception error = null;

    public SnippetContext(SpdxSnippet snippet, Map<String, String> spdxIdToUrl) {
        this.snippet = snippet;
        this.spdxIdToUrl = spdxIdToUrl;
    }

    public SnippetContext(InvalidSPDXAnalysisException e) {
        this.error = e;
    }

    public String spdxId() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getId();
    }

    public String byteRange() {
        StartEndPointer byteRange;
        block4: {
            if (this.snippet == null) {
                return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
            }
            try {
                byteRange = this.snippet.getByteRange();
                if (byteRange != null) break block4;
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX snippet byte range: " + e.getMessage();
            }
        }
        return byteRange.toString();
    }

    public String lineRange() {
        StartEndPointer lineRange;
        block4: {
            if (this.snippet == null) {
                return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
            }
            try {
                lineRange = this.snippet.getLineRange();
                if (lineRange != null) break block4;
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                return "Error getting SPDX snippet line range: " + e.getMessage();
            }
        }
        return lineRange.toString();
    }

    public String licenseConcluded() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getLicenseConcluded().toString();
    }

    public String licenseComments() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getLicenseComments();
    }

    public List<String> licenseInfoInSnippet() {
        ArrayList retval = Lists.newArrayList();
        if (this.snippet == null && this.error != null) {
            retval.add("Error getting SPDX snippet information: " + this.error.getMessage());
        }
        if (this.snippet != null) {
            AnyLicenseInfo[] licenseInfos = this.snippet.getLicenseInfoFromFiles();
            int i = 0;
            while (i < licenseInfos.length) {
                retval.add(licenseInfos[i].toString());
                ++i;
            }
        }
        return retval;
    }

    public String copyrightText() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getCopyrightText();
    }

    public String comment() {
        if (this.snippet != null) {
            return this.snippet.getComment();
        }
        return null;
    }

    public List<RelationshipContext> snippetRelationships() {
        Object[] relationships;
        ArrayList retval = Lists.newArrayList();
        if (this.snippet != null && (relationships = this.snippet.getRelationships()) != null) {
            Arrays.sort(relationships);
            Object[] objectArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                Object relationship = objectArray[n2];
                retval.add(new RelationshipContext((Relationship)relationship, this.spdxIdToUrl));
                ++n2;
            }
        }
        return retval;
    }

    public List<AnnotationContext> snippetAnnotations() {
        Object[] annotations;
        ArrayList retval = Lists.newArrayList();
        if (this.snippet != null && (annotations = this.snippet.getAnnotations()) != null) {
            Arrays.sort(annotations);
            Object[] objectArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Object annotation = objectArray[n2];
                retval.add(new AnnotationContext((Annotation)annotation));
                ++n2;
            }
        }
        return retval;
    }

    public String snippetFromFile() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        try {
            SpdxFile fromFile = this.snippet.getSnippetFromFile();
            if (fromFile.getId() != null && fromFile.getName() != null) {
                return String.valueOf(fromFile.getName()) + " (" + fromFile.getId() + ")";
            }
            return "[UNKNOWN]";
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting SPDX snippet from file: " + e.getMessage();
        }
    }
}

