/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.model.IRdfModel;

public final class RdfModelHelper {
    private RdfModelHelper() {
    }

    public static boolean arraysEqual(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        HashSet foundIndexes = Sets.newHashSet();
        int i = 0;
        while (i < array1.length) {
            boolean found = false;
            int j = 0;
            while (j < array2.length) {
                if (!foundIndexes.contains(j) && Objects.equal((Object)array1[i], (Object)array2[j])) {
                    found = true;
                    foundIndexes.add(j);
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean stringsEquivalent(String s1, String s2) {
        if (Objects.equal((Object)s1, (Object)s2)) {
            return true;
        }
        if (s1 == null && s2.isEmpty()) {
            return true;
        }
        if (s2 == null && s1.isEmpty()) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        String s1norm = s1.replace("\r\n", "\n").trim();
        String s2norm = s2.replace("\r\n", "\n").trim();
        return s1norm.equals(s2norm);
    }

    public static boolean arraysEquivalent(IRdfModel[] array1, IRdfModel[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        HashSet foundIndexes = Sets.newHashSet();
        int i = 0;
        while (i < array1.length) {
            boolean found = false;
            int j = 0;
            while (j < array2.length) {
                if (!foundIndexes.contains(j) && RdfModelHelper.equivalentConsideringNull(array1[i], array2[j])) {
                    found = true;
                    foundIndexes.add(j);
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equivalentConsideringNull(IRdfModel o1, IRdfModel o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equivalent(o2);
    }

    public static Resource findDuplicateResource(IModelContainer modelContainer, String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        Resource retval = ResourceFactory.createResource((String)uri);
        if (modelContainer.getModel().containsResource((RDFNode)retval)) {
            return modelContainer.getModel().getResource(uri);
        }
        return null;
    }
}

