/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.DisjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.LicenseParserException;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.rdfparser.license.WithExceptionOperator;

public class LicenseExpressionParser {
    static final String LEFT_PAREN = "(";
    static final String RIGHT_PAREN = ")";
    static final Map<String, Operator> OPERATOR_MAP = Maps.newHashMap();

    static {
        OPERATOR_MAP.put("+", Operator.OR_LATER);
        OPERATOR_MAP.put("and", Operator.AND);
        OPERATOR_MAP.put("or", Operator.OR);
        OPERATOR_MAP.put("with", Operator.WITH);
    }

    static AnyLicenseInfo parseLicenseExpression(String expression, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (expression == null || expression.trim().isEmpty()) {
            throw new LicenseParserException("Empty license expression");
        }
        String[] tokens = LicenseExpressionParser.tokenizeExpression(expression);
        if (tokens.length == 1 && tokens[0].toLowerCase().equals("NOASSERTION".toLowerCase())) {
            return new SpdxNoAssertionLicense();
        }
        if (tokens.length == 1 && tokens[0].toLowerCase().equals("NONE".toLowerCase())) {
            return new SpdxNoneLicense();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(tokens, container);
        }
        catch (EmptyStackException ex) {
            throw new LicenseParserException("Invalid license expression - check that every operator (e.g. AND and OR) has operators and that parenthesis are matched");
        }
    }

    private static String[] tokenizeExpression(String expression) {
        String[] startTokens = expression.split("\\s");
        ArrayList endTokens = Lists.newArrayList();
        String[] stringArray = startTokens;
        int n = startTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            LicenseExpressionParser.processPreToken(token, endTokens);
            ++n2;
        }
        return endTokens.toArray(new String[endTokens.size()]);
    }

    private static void processPreToken(String preToken, List<String> tokenList) {
        if (preToken.isEmpty()) {
            return;
        }
        if (preToken.startsWith(LEFT_PAREN)) {
            tokenList.add(LEFT_PAREN);
            LicenseExpressionParser.processPreToken(preToken.substring(1), tokenList);
        } else if (preToken.endsWith(RIGHT_PAREN)) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add(RIGHT_PAREN);
        } else if (preToken.endsWith("+")) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add("+");
        } else {
            tokenList.add(preToken);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static AnyLicenseInfo parseLicenseExpression(String[] tokens, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (tokens == null || tokens.length == 0) {
            throw new LicenseParserException("Expected license expression");
        }
        operandStack = new Stack<AnyLicenseInfo>();
        operatorStack = new Stack<Operator>();
        tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            if ("(".equals(token = tokens[tokenIndex++])) {
                rightParenIndex = LicenseExpressionParser.findMatchingParen(tokens, tokenIndex);
                if (rightParenIndex < 0) {
                    throw new LicenseParserException("Missing right parenthesis");
                }
                nestedTokens = Arrays.copyOfRange(tokens, tokenIndex, rightParenIndex);
                operandStack.push(LicenseExpressionParser.parseLicenseExpression(nestedTokens, container));
                tokenIndex = rightParenIndex + 1;
                continue;
            }
            if (LicenseExpressionParser.OPERATOR_MAP.get(token.toLowerCase()) == null) {
                operandStack.push(LicenseExpressionParser.parseSimpleLicenseToken(token, container));
                continue;
            }
            operator = LicenseExpressionParser.OPERATOR_MAP.get(token.toLowerCase());
            if (operator != Operator.WITH) ** GOTO lbl40
            if (!operatorStack.isEmpty() && Operator.OR_LATER.equals(operatorStack.peek())) {
                tosOperator = (Operator)operatorStack.pop();
                LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
            }
            if (tokenIndex >= tokens.length) {
                throw new LicenseParserException("Missing exception clause");
            }
            token = tokens[tokenIndex++];
            licenseException = null;
            licenseException = LicenseInfoFactory.isSPdxListedExceptionID(token) != false ? LicenseInfoFactory.getListedExceptionById(token) : new LicenseException(token);
            operand = operandStack.pop();
            if (operand == null) {
                throw new LicenseParserException("Missing license for with clause");
            }
            if (!(operand instanceof SimpleLicensingInfo) && !(operand instanceof OrLaterOperator)) {
                throw new LicenseParserException("License with exception is not of type SimpleLicensingInfo or OrLaterOperator");
            }
            operandStack.push(new WithExceptionOperator(operand, licenseException));
            continue;
lbl-1000:
            // 1 sources

            {
                tosOperator = (Operator)operatorStack.pop();
                LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
lbl40:
                // 2 sources

                ** while (!operatorStack.isEmpty() && ((Operator)operatorStack.peek()).ordinal() <= operator.ordinal())
            }
lbl41:
            // 1 sources

            operatorStack.push(operator);
        }
        while (!operatorStack.isEmpty()) {
            tosOperator = (Operator)operatorStack.pop();
            LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
        }
        retval = (AnyLicenseInfo)operandStack.pop();
        if (!operandStack.isEmpty()) {
            throw new LicenseParserException("Invalid license expression.  Expecting more operands.");
        }
        return retval;
    }

    private static int findMatchingParen(String[] tokens, int startToken) {
        if (tokens == null) {
            return -1;
        }
        int nestCount = 0;
        int i = startToken;
        while (i < tokens.length) {
            if (LEFT_PAREN.equals(tokens[i])) {
                ++nestCount;
            } else if (RIGHT_PAREN.equals(tokens[i])) {
                if (nestCount == 0) {
                    return i;
                }
                --nestCount;
            }
            ++i;
        }
        return -1;
    }

    private static AnyLicenseInfo parseSimpleLicenseToken(String token, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (LicenseInfoFactory.isSpdxListedLicenseID(token)) {
            return LicenseInfoFactory.getListedLicenseById(token);
        }
        ExtractedLicenseInfo retval = null;
        if (container != null) {
            if (container.extractedLicenseExists(token)) {
                retval = container.getExtractedLicense(token);
            } else {
                retval = new ExtractedLicenseInfo(token, null);
                container.addNewExtractedLicenseInfo(retval);
            }
        } else {
            retval = new ExtractedLicenseInfo(token, null);
        }
        return retval;
    }

    private static void evaluateExpression(Operator operator, Stack<AnyLicenseInfo> operandStack) throws InvalidSPDXAnalysisException {
        if (operator == Operator.OR_LATER) {
            AnyLicenseInfo license = operandStack.pop();
            if (!(license instanceof SimpleLicensingInfo)) {
                throw new LicenseParserException("Missing license for the '+' or later operator");
            }
            operandStack.push(new OrLaterOperator((SimpleLicensingInfo)license));
        } else {
            AnyLicenseInfo operand2 = operandStack.pop();
            AnyLicenseInfo operand1 = operandStack.pop();
            if (operand1 == null || operand2 == null) {
                throw new LicenseParserException("Missing operands for the " + operator.toString() + " operator");
            }
            operandStack.push(LicenseExpressionParser.evaluateBinary(operator, operand1, operand2));
        }
    }

    private static AnyLicenseInfo evaluateBinary(Operator tosOperator, AnyLicenseInfo operand1, AnyLicenseInfo operand2) throws InvalidSPDXAnalysisException {
        if (tosOperator == Operator.AND) {
            if (operand1 instanceof ConjunctiveLicenseSet) {
                AnyLicenseInfo[] origMembers = ((ConjunctiveLicenseSet)operand1).getMembers();
                AnyLicenseInfo[] newMembers = Arrays.copyOf(origMembers, origMembers.length + 1);
                newMembers[origMembers.length] = operand2;
                ((ConjunctiveLicenseSet)operand1).setMembers(newMembers);
                return operand1;
            }
            AnyLicenseInfo[] members = new AnyLicenseInfo[]{operand1, operand2};
            return new ConjunctiveLicenseSet(members);
        }
        if (tosOperator == Operator.OR) {
            if (operand1 instanceof DisjunctiveLicenseSet) {
                AnyLicenseInfo[] origMembers = ((DisjunctiveLicenseSet)operand1).getMembers();
                AnyLicenseInfo[] newMembers = Arrays.copyOf(origMembers, origMembers.length + 1);
                newMembers[origMembers.length] = operand2;
                ((DisjunctiveLicenseSet)operand1).setMembers(newMembers);
                return operand1;
            }
            AnyLicenseInfo[] members = new AnyLicenseInfo[]{operand1, operand2};
            return new DisjunctiveLicenseSet(members);
        }
        throw new LicenseParserException("Unknown operator " + tosOperator.toString());
    }

    static enum Operator {
        OR_LATER,
        WITH,
        AND,
        OR;

    }
}

