/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.SpdxElement;

public class Relationship
extends RdfModelObject
implements Comparable<Relationship> {
    static final Logger logger = LoggerFactory.getLogger(RdfModelObject.class);
    private RelationshipType relationshipType;
    private String comment;
    private SpdxElement relatedSpdxElement;

    public Relationship(SpdxElement relatedSpdxElement, RelationshipType relationshipType, String comment) {
        this.relatedSpdxElement = relatedSpdxElement;
        this.relationshipType = relationshipType;
        this.comment = comment;
        this.refreshOnGet = true;
    }

    public Relationship(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.relatedSpdxElement = this.findElementPropertyValue("http://spdx.org/rdf/terms#", "relatedSpdxElement");
        this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        String relationshipTypeUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "relationshipType");
        if (relationshipTypeUri != null) {
            String relationshipString = relationshipTypeUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.relationshipType = RelationshipType.fromString(relationshipString);
            }
            catch (Exception ex) {
                logger.error("Invalid relationship type found in the model - " + relationshipString);
                throw new InvalidSPDXAnalysisException("Invalid relationship type: " + relationshipString);
            }
        }
    }

    @Override
    public List<String> verify() {
        List<Object> retval;
        if (this.relatedSpdxElement == null) {
            retval = Lists.newArrayList();
            retval.add("Missing related SPDX element");
        } else {
            retval = this.relatedSpdxElement.verify();
        }
        if (this.relationshipType == null) {
            retval.add("Missing relationship type");
        }
        return retval;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#Relationship");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.comment != null) {
            this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", this.comment);
        }
        if (this.relatedSpdxElement != null) {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "relatedSpdxElement", this.relatedSpdxElement, false);
        }
        if (this.relationshipType != null) {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "relationshipType", "http://spdx.org/rdf/terms#" + this.relationshipType.toString());
        }
    }

    @Override
    public String getUri(IModelContainer modelContainer) {
        return null;
    }

    public RelationshipType getRelationshipType() {
        String relationshipTypeUri;
        if (this.model != null && this.refreshOnGet && (relationshipTypeUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "relationshipType")) != null) {
            String relationshipString = relationshipTypeUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.relationshipType = RelationshipType.fromString(relationshipString);
            }
            catch (Exception ex) {
                logger.error("Invalid relationship type found in the model - " + relationshipString);
            }
        }
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        this.relationshipType = relationshipType;
        if (relationshipType != null) {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "relationshipType", "http://spdx.org/rdf/terms#" + this.relationshipType.toString());
        } else {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "relationshipType");
        }
    }

    public String getComment() {
        if (this.resource != null && this.refreshOnGet) {
            this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", comment);
    }

    public SpdxElement getRelatedSpdxElement() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                SpdxElement refresh = this.findElementPropertyValue("http://spdx.org/rdf/terms#", "relatedSpdxElement");
                if (refresh == null || !refresh.equivalent(this.relatedSpdxElement, false)) {
                    this.relatedSpdxElement = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid related SPDX element found in the model", (Throwable)e);
            }
        }
        return this.relatedSpdxElement;
    }

    public void setRelatedSpdxElement(SpdxElement relatedSpdxElement) throws InvalidSPDXAnalysisException {
        this.relatedSpdxElement = relatedSpdxElement;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "relatedSpdxElement", relatedSpdxElement);
    }

    public Relationship clone() {
        return this.clone(Maps.newHashMap());
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship comp = (Relationship)o;
        if (this.relatedSpdxElement == null) {
            if (comp.getRelatedSpdxElement() != null) {
                return false;
            }
            return Objects.equal((Object)((Object)this.relationshipType), (Object)((Object)comp.getRelationshipType())) && Objects.equal((Object)this.comment, (Object)comp.getComment());
        }
        return this.relatedSpdxElement.equivalent(comp.getRelatedSpdxElement(), false) && Objects.equal((Object)((Object)this.relationshipType), (Object)((Object)comp.getRelationshipType())) && Objects.equal((Object)this.comment, (Object)comp.getComment());
    }

    public Relationship clone(Map<String, SpdxElement> clonedElementIds) {
        return new Relationship(this.relatedSpdxElement.clone(clonedElementIds), this.relationshipType, this.comment);
    }

    @Override
    public int compareTo(Relationship o) {
        if (o.getRelationshipType() == null && this.relationshipType != null) {
            return 1;
        }
        if (this.relationshipType == null) {
            return -1;
        }
        int retval = this.relationshipType.toString().compareTo(o.getRelationshipType().toString());
        if (retval != 0) {
            return retval;
        }
        SpdxElement compareRelatedElement = o.getRelatedSpdxElement();
        if ((compareRelatedElement == null || compareRelatedElement.getId() == null) && this.relatedSpdxElement != null && this.relatedSpdxElement.getId() != null) {
            return 1;
        }
        if (this.relatedSpdxElement == null || this.relatedSpdxElement.getId() == null) {
            return -1;
        }
        retval = this.relatedSpdxElement.getId().compareTo(compareRelatedElement.getId());
        if (retval != 0) {
            return retval;
        }
        if (o.getComment() == null && this.comment != null) {
            return 1;
        }
        if (this.comment == null) {
            return -1;
        }
        return this.comment.compareTo(o.getComment());
    }

    public static enum RelationshipType {
        DESCRIBES("relationshipType_describes"),
        DESCRIBED_BY("relationshipType_describedBy"),
        ANCESTOR_OF("relationshipType_ancestorOf"),
        BUILD_TOOL_OF("relationshipType_buildToolOf"),
        CONTAINED_BY("relationshipType_containedBy"),
        CONTAINS("relationshipType_contains"),
        COPY_OF("relationshipType_copyOf"),
        DATA_FILE_OF("relationshipType_dataFile"),
        DESCENDANT_OF("relationshipType_descendantOf"),
        DISTRIBUTION_ARTIFACT("relationshipType_distributionArtifact"),
        DOCUMENTATION_OF("relationshipType_documentation"),
        DYNAMIC_LINK("relationshipType_dynamicLink"),
        EXPANDED_FROM_ARCHIVE("relationshipType_expandedFromArchive"),
        FILE_ADDED("relationshipType_fileAdded"),
        FILE_DELETED("relationshipType_fileDeleted"),
        FILE_MODIFIED("relationshipType_fileModified"),
        GENERATED_FROM("relationshipType_generatedFrom"),
        GENERATES("relationshipType_generates"),
        METAFILE_OF("relationshipType_metafileOf"),
        OPTIONAL_COMPONENT_OF("relationshipType_optionalComponentOf"),
        OTHER("relationshipType_other"),
        PACKAGE_OF("relationshipType_packageOf"),
        PATCH_APPLIED("relationshipType_patchApplied"),
        PATCH_FOR("relationshipType_patchFor"),
        AMENDS("relationshipType_amends"),
        STATIC_LINK("relationshipType_staticLink"),
        TEST_CASE_OF("relationshipType_testcaseOf"),
        PREREQUISITE_FOR("relationshipType_prerequisiteFor"),
        HAS_PREREQUISITE("relationshipType_hasPrerequisite"),
        VARIANT_OF("relationshipType_variantOf"),
        BUILD_DEPENDENCY_OF("relationshipType_buildDependencyOf"),
        DEPENDENCY_MANIFEST_OF("relationshipType_dependencyManifestOf"),
        DEPENDENCY_OF("relationshipType_dependencyOf"),
        DEPENDS_ON("relationshipType_dependsOn"),
        DEV_DEPENDENCY_OF("relationshipType_devDependencyOf"),
        DEV_TOOL_OF("relationshipType_devToolOf"),
        EXAMPLE_OF("relationshipType_exampleOf"),
        OPTIONAL_DEPENDENCY_OF("relationshipType_optionalDependencyOf"),
        PROVIDED_DEPENDENCY_OF("relationshipType_providedDependencyOf"),
        RUNTIME_DEPENDENCY_OF("relationshipType_runtimeDependencyOf"),
        TEST_DEPENDENCY_OF("relationshipType_testDependencyOf"),
        TEST_OF("relationshipType_testOf"),
        TEST_TOOL_OF("relationshipType_testToolOf"),
        NONE("relationshipType_none"),
        NOASSERTION("relationshipType_noAssertion");

        private static final Map<String, RelationshipType> STRING_TO_TYPE;
        private String rdfString;

        static {
            ImmutableMap.Builder stringToTypeBuilder = new ImmutableMap.Builder();
            RelationshipType[] relationshipTypeArray = RelationshipType.values();
            int n = relationshipTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RelationshipType type = relationshipTypeArray[n2];
                stringToTypeBuilder.put((Object)type.toString(), (Object)type);
                ++n2;
            }
            STRING_TO_TYPE = stringToTypeBuilder.build();
        }

        private RelationshipType(String rdfString) {
            this.rdfString = rdfString;
        }

        public String toString() {
            return this.rdfString;
        }

        public static RelationshipType fromString(String rdfString) {
            return STRING_TO_TYPE.get(rdfString);
        }

        @Deprecated
        public String getTag() {
            return this.toTag();
        }

        public String toTag() {
            return this.name();
        }

        public static RelationshipType fromTag(String tag) {
            return RelationshipType.valueOf(tag);
        }
    }
}

