/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;

public class SpdxItem
extends SpdxElement {
    AnyLicenseInfo licenseConcluded;
    AnyLicenseInfo[] licenseInfoFromFiles;
    String copyrightText;
    String licenseComments;
    String[] attributionText = new String[0];

    public SpdxItem(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    private void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.copyrightText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "copyrightText");
        this.licenseComments = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseComments");
        this.licenseConcluded = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "licenseConcluded");
        this.licenseInfoFromFiles = this.findAnyLicenseInfoPropertyValues("http://spdx.org/rdf/terms#", this.getLicenseInfoFromFilesPropertyName());
        this.attributionText = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "attributionText");
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    public SpdxItem(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfoFromFiles, String copyrightText, String licenseComment, String[] attributionText) {
        this(name, comment, annotations, relationships, licenseConcluded, licenseInfoFromFiles, copyrightText, licenseComment);
        this.attributionText = attributionText;
    }

    public SpdxItem(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfoFromFiles, String copyrightText, String licenseComment) {
        super(name, comment, annotations, relationships);
        this.licenseConcluded = licenseConcluded;
        this.licenseInfoFromFiles = licenseInfoFromFiles;
        if (this.licenseInfoFromFiles == null) {
            this.licenseInfoFromFiles = new AnyLicenseInfo[0];
        }
        this.copyrightText = copyrightText;
        this.licenseComments = licenseComment;
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        if (this.resource != null) {
            if (this.licenseConcluded != null) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseConcluded", this.licenseConcluded);
            }
            if (this.licenseInfoFromFiles != null) {
                this.setPropertyValues("http://spdx.org/rdf/terms#", this.getLicenseInfoFromFilesPropertyName(), this.licenseInfoFromFiles);
            }
            if (this.copyrightText != null) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "copyrightText", this.copyrightText);
            }
            if (this.licenseComments != null) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseComments", this.licenseComments);
            }
            if (this.attributionText != null) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "attributionText", this.attributionText);
            }
        }
    }

    protected String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoFromFiles";
    }

    public AnyLicenseInfo getLicenseConcluded() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                AnyLicenseInfo refresh = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "licenseConcluded");
                if (refresh == null || !refresh.equals(this.licenseConcluded)) {
                    this.licenseConcluded = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid licenseConcluded in model", (Throwable)e);
            }
        }
        return this.licenseConcluded;
    }

    public void setLicenseConcluded(AnyLicenseInfo licenseConcluded) throws InvalidSPDXAnalysisException {
        this.licenseConcluded = licenseConcluded;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseConcluded", licenseConcluded);
    }

    public AnyLicenseInfo[] getLicenseInfoFromFiles() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                Object[] refresh = this.findAnyLicenseInfoPropertyValues("http://spdx.org/rdf/terms#", this.getLicenseInfoFromFilesPropertyName());
                if (!RdfModelHelper.arraysEqual(refresh, this.licenseInfoFromFiles)) {
                    this.licenseInfoFromFiles = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid licenseDeclared in model", (Throwable)e);
            }
        }
        return this.licenseInfoFromFiles;
    }

    public void setLicenseInfosFromFiles(AnyLicenseInfo[] licenseInfoFromFiles) throws InvalidSPDXAnalysisException {
        this.licenseInfoFromFiles = licenseInfoFromFiles;
        this.setPropertyValues("http://spdx.org/rdf/terms#", this.getLicenseInfoFromFilesPropertyName(), licenseInfoFromFiles);
    }

    public String getCopyrightText() {
        if (this.resource != null && this.refreshOnGet) {
            this.copyrightText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "copyrightText");
        }
        return this.copyrightText;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "copyrightText", copyrightText);
    }

    public void setAttributionText(String[] attributionText) {
        this.attributionText = Objects.isNull(attributionText) ? new String[0] : attributionText;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "attributionText", attributionText);
    }

    public String[] getAttributionText() {
        if (this.resource != null && this.refreshOnGet) {
            this.attributionText = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "attributionText");
        }
        return this.attributionText;
    }

    public String getLicenseComments() {
        if (this.resource != null && this.refreshOnGet) {
            this.licenseComments = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseComments");
        }
        return this.licenseComments;
    }

    @Deprecated
    public String getLicenseComment() {
        return this.getLicenseComments();
    }

    public void setLicenseComments(String licenseComments) {
        this.licenseComments = licenseComments;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseComments", licenseComments);
    }

    @Deprecated
    public void setLicenseComment(String licenseComment) {
        this.setLicenseComments(licenseComment);
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#SpdxItem");
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpdxItem)) {
            return false;
        }
        SpdxItem comp = (SpdxItem)o;
        if (!super.equivalent(comp, testRelationships)) {
            return false;
        }
        return RdfModelHelper.stringsEquivalent(this.getCopyrightText(), comp.getCopyrightText()) && this.equivalentConsideringNull(this.getLicenseConcluded(), comp.getLicenseConcluded()) && this.arraysEquivalent(this.getLicenseInfoFromFiles(), comp.getLicenseInfoFromFiles(), testRelationships) && RdfModelHelper.stringsEquivalent(this.getLicenseComments(), comp.getLicenseComments());
    }

    protected AnyLicenseInfo cloneLicenseConcluded() {
        if (this.licenseConcluded == null) {
            return null;
        }
        return this.licenseConcluded.clone();
    }

    protected AnyLicenseInfo[] cloneLicenseInfosFromFiles() {
        if (this.licenseInfoFromFiles == null) {
            return new AnyLicenseInfo[0];
        }
        AnyLicenseInfo[] retval = new AnyLicenseInfo[this.licenseInfoFromFiles.length];
        int i = 0;
        while (i < this.licenseInfoFromFiles.length) {
            retval[i] = this.licenseInfoFromFiles[i].clone();
            ++i;
        }
        return retval;
    }

    @Override
    public SpdxItem clone() {
        return this.clone((Map)Maps.newHashMap());
    }

    @Override
    public SpdxItem clone(Map<String, SpdxElement> clonedElementIds) {
        if (clonedElementIds.containsKey(this.getId())) {
            return (SpdxItem)clonedElementIds.get(this.getId());
        }
        SpdxItem retval = new SpdxItem(this.name, this.comment, this.cloneAnnotations(), null, this.cloneLicenseConcluded(), this.cloneLicenseInfosFromFiles(), this.copyrightText, this.licenseComments);
        clonedElementIds.put(this.getId(), retval);
        try {
            retval.setRelationships(this.cloneRelationships(clonedElementIds));
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Unexected error setting relationships during clone", (Throwable)e);
        }
        return retval;
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        String name = "UNKNOWN";
        if (this.name != null) {
            name = this.name;
        }
        if (this.licenseConcluded == null) {
            retval.add("Missing required concluded license for " + name);
        }
        if (this.copyrightText == null || this.copyrightText.isEmpty()) {
            retval.add("Missing required copyright text for " + name);
        }
        this.addNameToWarnings(retval);
        return retval;
    }
}

