/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CompareHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class PerFileSheetV1d1
extends PerFileSheet {
    static final int NUM_COLS = 12;
    static final int FILE_NAME_COL = 0;
    static final int FILE_TYPE_COL = 1;
    static final int SHA1_COL = 2;
    static final int CONCLUDED_LIC_COL = 3;
    static final int LIC_INFO_IN_FILE_COL = 4;
    static final int LIC_COMMENTS_COL = 5;
    static final int SEEN_COPYRIGHT_COL = 6;
    static final int ARTIFACT_OF_PROJECT_COL = 7;
    static final int ARTIFACT_OF_HOMEPAGE_COL = 8;
    static final int ARTIFACT_OF_PROJECT_URL_COL = 9;
    static final int COMMENT_COL = 10;
    static final int USER_DEFINED_COL = 11;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;

    static {
        boolean[] blArray = new boolean[12];
        blArray[0] = true;
        blArray[1] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"File Name", "File Type", "File Checksum", "License Concluded", "License Info in File", "License Comments", "File Copyright Text", "Artifact of Project", "Artifact of Homepage", "Artifact of URL", "File Comment", "User Defined Columns..."};
        COLUMN_WIDTHS = new int[]{60, 10, 25, 30, 30, 40, 40, 25, 60, 60, 60, 60};
        boolean[] blArray2 = new boolean[12];
        blArray2[0] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[12];
        blArray3[1] = true;
        CENTER_NOWRAP = blArray3;
    }

    public PerFileSheetV1d1(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName, version);
    }

    @Override
    public void add(SpdxFile fileInfo, String pkgId) {
        Row row = this.addRow();
        if (fileInfo.getArtifactOf() != null && fileInfo.getArtifactOf().length > 0) {
            DoapProject project = fileInfo.getArtifactOf()[0];
            row.createCell(7).setCellValue(project.getName());
            row.createCell(8).setCellValue(project.getHomePage());
            row.createCell(9).setCellValue(project.getProjectUri());
        }
        if (fileInfo.getLicenseConcluded() != null) {
            row.createCell(3).setCellValue(fileInfo.getLicenseConcluded().toString());
        }
        row.createCell(0).setCellValue(fileInfo.getName());
        if (fileInfo.getSha1() != null && !fileInfo.getSha1().isEmpty()) {
            row.createCell(2).setCellValue(fileInfo.getSha1());
        }
        row.createCell(1).setCellValue(CompareHelper.fileTypesToString(fileInfo.getFileTypes()));
        if (fileInfo.getLicenseComments() != null && !fileInfo.getLicenseComments().isEmpty()) {
            row.createCell(5).setCellValue(fileInfo.getLicenseComments());
        }
        if (fileInfo.getCopyrightText() != null && !fileInfo.getCopyrightText().isEmpty()) {
            row.createCell(6).setCellValue(fileInfo.getCopyrightText());
        }
        if (fileInfo.getLicenseInfoFromFiles() != null && fileInfo.getLicenseInfoFromFiles().length > 0) {
            row.createCell(4).setCellValue(PackageInfoSheet.licensesToString(fileInfo.getLicenseInfoFromFiles()));
        }
        if (fileInfo.getComment() != null && !fileInfo.getComment().isEmpty()) {
            row.createCell(10).setCellValue(fileInfo.getComment());
        }
    }

    @Override
    public SpdxFile getFileInfo(int rowNum, SpdxDocumentContainer container) throws SpreadsheetException {
        DoapProject[] artifactOf;
        AnyLicenseInfo[] seenLicenses;
        SpdxFile.FileType[] types;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String name = row.getCell(0).getStringCellValue();
        String typeStr = row.getCell(1).getStringCellValue();
        try {
            types = CompareHelper.parseFileTypeString(typeStr);
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error converting file types: " + e1.getMessage());
        }
        Cell sha1cell = row.getCell(2);
        String sha1 = sha1cell != null ? sha1cell.getStringCellValue() : "";
        Cell assertedLicenseCell = row.getCell(3);
        AnyLicenseInfo fileLicenses = assertedLicenseCell != null && !assertedLicenseCell.getStringCellValue().isEmpty() ? LicenseInfoFactory.parseSPDXLicenseString(assertedLicenseCell.getStringCellValue(), container) : null;
        Cell seenLicenseCell = row.getCell(4);
        if (seenLicenseCell != null && !seenLicenseCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = seenLicenseCell.getStringCellValue().split(",");
            seenLicenses = new AnyLicenseInfo[licenseStrings.length];
            int i = 0;
            while (i < licenseStrings.length) {
                seenLicenses[i] = LicenseInfoFactory.parseSPDXLicenseString(licenseStrings[i].trim(), container);
                ++i;
            }
        } else {
            seenLicenses = null;
        }
        Cell licCommentCell = row.getCell(5);
        String licenseComments = licCommentCell != null ? licCommentCell.getStringCellValue() : "";
        Cell copyrightCell = row.getCell(6);
        String copyright = copyrightCell != null ? copyrightCell.getStringCellValue() : "";
        Cell artifactOfCell = row.getCell(7);
        if (artifactOfCell != null && !artifactOfCell.getStringCellValue().isEmpty()) {
            String projectName = artifactOfCell.getStringCellValue();
            String homePage = "";
            Cell homePageCell = row.getCell(8);
            if (homePageCell != null) {
                homePage = homePageCell.getStringCellValue();
            }
            Cell uriCell = row.getCell(9);
            String uri = "";
            if (uriCell != null) {
                uri = uriCell.getStringCellValue();
            }
            DoapProject project = new DoapProject(projectName, homePage);
            if (uri != null && !uri.isEmpty()) {
                try {
                    project.setProjectUri(uri);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error setting the URI for the artifact of");
                }
            }
            artifactOf = new DoapProject[]{project};
        } else {
            artifactOf = new DoapProject[]{};
        }
        String comment = null;
        Cell commentCell = row.getCell(10);
        if (commentCell != null) {
            comment = commentCell.getStringCellValue();
        }
        try {
            return new SpdxFile(name, types, sha1, fileLicenses, seenLicenses, licenseComments, copyright, artifactOf, comment);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error creating new SPDX file: " + e.getMessage());
        }
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for SPDX File does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 12) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX File worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX File work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 12) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (REQUIRED[i]) {
                    return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
                }
            } else if (i == 3 || i == 4) {
                try {
                    LicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue(), null);
                }
                catch (SpreadsheetException ex) {
                    if (i == 3) {
                        return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                    }
                    return "Invalid seen license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                }
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    @Override
    public String[] getPackageIds(int row) {
        return new String[0];
    }
}

