/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.TagValueBehavior;

@Deprecated
public class BuildLegacyDocument
implements TagValueBehavior {
    private static final String DEFAULT_SHA1 = "0000000000000000000000000000000000000000";
    private Properties constants;
    private SPDXDocument analysis;
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private SPDXReview lastReviewer = null;
    private ExtractedLicenseInfo lastExtractedLicense = null;
    private SPDXFile lastFile = null;
    private DOAPProject lastProject = null;
    private Map<String, List<SPDXFile>> fileDependencyMap = Maps.newHashMap();

    public BuildLegacyDocument(Model model, SPDXDocument spdxDocument, Properties constants) {
        this.constants = constants;
        this.analysis = spdxDocument;
        try {
            this.analysis.createSpdxAnalysis("http://www.uri.com#SPDXANALYSIS");
            this.analysis.createSpdxPackage();
        }
        catch (InvalidSPDXAnalysisException ex) {
            System.out.print("Error creating SPDX Analysis: " + ex.getMessage());
            return;
        }
    }

    @Override
    public void enter() throws Exception {
    }

    @Override
    public void buildDocument(String tag, String value, int lineNumber) throws Exception {
        tag = String.valueOf(tag.trim()) + " ";
        value = BuildLegacyDocument.trim(value.trim());
        if (tag.equals(this.constants.getProperty("PROP_SPDX_VERSION"))) {
            this.analysis.setSpdxVersion(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_DATA_LICENSE"))) {
            this.analysis.getDataLicense().setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATOR"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            } else {
                ArrayList creators = Lists.newArrayList((Object[])this.analysis.getCreatorInfo().getCreators());
                creators.add(value);
                this.analysis.getCreatorInfo().setCreators(creators.toArray(new String[0]));
            }
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATED"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[0], "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setCreated(value);
        } else if (tag.equals(this.constants.getProperty("PROP_CREATION_COMMENT"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_LIST_VERSION"))) {
            if (this.analysis.getCreatorInfo() == null) {
                SPDXCreatorInformation creator = new SPDXCreatorInformation(new String[]{value}, "", "", "");
                this.analysis.setCreationInfo(creator);
            }
            this.analysis.getCreatorInfo().setLicenseListVersion(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_COMMENT"))) {
            this.analysis.setDocumentComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_REVIEWER"))) {
            this.lastReviewer = new SPDXReview(value, this.format.format(new Date()), "");
            ArrayList reviewers = Lists.newArrayList((Object[])this.analysis.getReviewers());
            reviewers.add(this.lastReviewer);
            this.analysis.setReviewers(reviewers.toArray(new SPDXReview[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_DATE"))) {
            if (this.lastReviewer == null) {
                throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review date");
            }
            this.lastReviewer.setReviewDate(value);
        } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_COMMENT"))) {
            if (this.lastReviewer == null) {
                throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review comment");
            }
            this.lastReviewer.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_ID"))) {
            this.lastExtractedLicense = new ExtractedLicenseInfo(value, "WARNING: TEXT IS REQUIRED", null, null, null);
            Object[] currentNonStdLicenses = this.analysis.getExtractedLicenseInfos();
            ArrayList licenses = Lists.newArrayList((Object[])currentNonStdLicenses);
            licenses.add(this.lastExtractedLicense);
            this.analysis.setExtractedLicenseInfos(licenses.toArray(new ExtractedLicenseInfo[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_EXTRACTED_TEXT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license text");
            }
            this.lastExtractedLicense.setExtractedText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_NAME"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license name");
            }
            this.lastExtractedLicense.setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SOURCE_URLS"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license URL");
            }
            String[] values = value.split(",");
            int i = 0;
            while (i < values.length) {
                values[i] = values[i].trim();
                ++i;
            }
            this.lastExtractedLicense.setSeeAlso(values);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_COMMENT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license comment");
            }
            this.lastExtractedLicense.setComment(value);
        } else {
            SPDXDocument.SPDXPackage spdxPackage = this.analysis.getSpdxPackage();
            this.buildPackage(spdxPackage, tag, value);
        }
    }

    private void buildPackage(SPDXDocument.SPDXPackage pkg, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_NAME"))) {
            pkg.setDeclaredName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERSION_INFO"))) {
            pkg.setVersionInfo(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL"))) {
            pkg.setDownloadUrl(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL"))) {
            pkg.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SHORT_DESC"))) {
            pkg.setShortDescription(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SOURCE_INFO"))) {
            pkg.setSourceInfo(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_FILE_NAME"))) {
            pkg.setFileName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SUPPLIER"))) {
            pkg.setSupplier(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_ORIGINATOR"))) {
            pkg.setOriginator(value);
        } else if (this.constants.getProperty("PROP_PACKAGE_CHECKSUM").startsWith(tag)) {
            pkg.setSha1(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE"))) {
            if (value.contains("(")) {
                String[] verification = value.split("\\(");
                String[] excludedFiles = verification[1].replace(")", "").split(",");
                int i = 0;
                while (i < excludedFiles.length) {
                    excludedFiles[i] = excludedFiles[i].trim();
                    ++i;
                }
                pkg.setVerificationCode(new SpdxPackageVerificationCode(verification[0].trim(), excludedFiles));
            } else {
                pkg.setVerificationCode(new SpdxPackageVerificationCode(value, new String[0]));
            }
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DESCRIPTION"))) {
            pkg.setDescription(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT"))) {
            pkg.setDeclaredCopyright(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value);
            pkg.setDeclaredLicense(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value);
            pkg.setConcludedLicenses(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT"))) {
            pkg.setLicenseComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES"))) {
            AnyLicenseInfo license = LicenseInfoFactory.parseSPDXLicenseString(value);
            ArrayList licenses = Lists.newArrayList((Object[])pkg.getLicenseInfoFromFiles());
            licenses.add(license);
            pkg.setLicenseInfoFromFiles(licenses.toArray(new AnyLicenseInfo[0]));
        } else {
            this.buildFile(pkg, tag, value);
        }
    }

    private void buildFile(SPDXDocument.SPDXPackage pkg, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
            this.lastFile = new SPDXFile(value, "OTHER", DEFAULT_SHA1, new SpdxNoneLicense(), new AnyLicenseInfo[0], "", "", new DOAPProject[0]);
            pkg.addFile(this.lastFile);
        } else {
            if (this.lastFile == null) {
                if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE")) || this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag) || tag.equals(this.constants.getProperty("PROP_FILE_LICENSE")) || tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS")) || tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT")) || tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
                    throw new InvalidSpdxTagFileException("Missing File Name - A file name must be specified before the file properties");
                }
                throw new InvalidSpdxTagFileException("Unrecognized SPDX Tag: " + tag);
            }
            if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE"))) {
                this.lastFile.setType(value);
            } else if (this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag)) {
                this.lastFile.setSha1(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_LICENSE"))) {
                AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value);
                this.lastFile.setConcludedLicenses(licenseSet);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_SEEN_LICENSE"))) {
                AnyLicenseInfo fileLicense = LicenseInfoFactory.parseSPDXLicenseString(value);
                ArrayList seenLicenses = Lists.newArrayList((Object[])this.lastFile.getSeenLicenses());
                seenLicenses.add(fileLicense);
                this.lastFile.setSeenLicenses(seenLicenses.toArray(new AnyLicenseInfo[0]));
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS"))) {
                this.lastFile.setLicenseComments(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT"))) {
                this.lastFile.setCopyright(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
                this.lastFile.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_DEPENDENCY"))) {
                this.addFileDependency(this.lastFile, value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_CONTRIBUTOR"))) {
                this.addFileContributor(this.lastFile, value);
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_NOTICE_TEXT"))) {
                this.lastFile.setNoticeText(value);
            } else {
                this.buildProject(this.lastFile, tag, value);
            }
        }
    }

    private void addFileContributor(SPDXFile file, String contributor) {
        String[] contributors = file.getContributors();
        if (contributors == null) {
            contributors = new String[]{contributor};
        } else {
            contributors = Arrays.copyOf(contributors, contributors.length + 1);
            contributors[contributors.length - 1] = contributor;
        }
        file.setContributors(contributors);
    }

    private void addFileDependency(SPDXFile file, String dependentFileName) {
        ArrayList filesWithThisAsADependency = this.fileDependencyMap.get(dependentFileName);
        if (filesWithThisAsADependency == null) {
            filesWithThisAsADependency = Lists.newArrayList();
            this.fileDependencyMap.put(dependentFileName, filesWithThisAsADependency);
        }
        filesWithThisAsADependency.add(file);
    }

    private void buildProject(SPDXFile file, String tag, String value) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PROJECT_NAME"))) {
            this.lastProject = new DOAPProject(value, null);
            ArrayList projects = Lists.newArrayList((Object[])file.getArtifactOf());
            projects.add(this.lastProject);
            file.setArtifactOf(projects.toArray(new DOAPProject[0]));
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_HOMEPAGE"))) {
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties");
            }
            this.lastProject.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_URI"))) {
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties");
            }
            DOAPProject[] existingProjects = file.getArtifactOf();
            int i = 0;
            while (i < existingProjects.length && !existingProjects[i].equals(this.lastProject)) {
                ++i;
            }
            if (i >= existingProjects.length) {
                existingProjects = Arrays.copyOf(existingProjects, existingProjects.length + 1);
            }
            existingProjects[i] = new DOAPProject(this.lastProject.getName(), this.lastProject.getHomePage());
            existingProjects[i].setUri(value);
            file.setArtifactOf(existingProjects);
            this.lastProject = existingProjects[i];
        } else {
            throw new InvalidSpdxTagFileException("Unrecognized tag: " + tag);
        }
    }

    private static String trim(String value) {
        value = value.trim();
        value = value.replaceAll("<text>", "").replaceAll("</text>", "").replaceAll("SHA1: ", "");
        return value;
    }

    @Override
    public void exit() throws Exception {
        this.fixFileDependencies();
        List<String> warningMessages = this.analysis.verify();
        BuildLegacyDocument.assertEquals("SPDXDocument", 0, warningMessages);
    }

    private void fixFileDependencies() throws InvalidSPDXAnalysisException {
        HashMap filesWithDependencies = Maps.newHashMap();
        SPDXFile[] allFiles = this.analysis.getFileReferences();
        int i = 0;
        while (i < allFiles.length) {
            List<SPDXFile> alFilesHavingThisDependency = this.fileDependencyMap.get(allFiles[i].getName());
            if (alFilesHavingThisDependency != null) {
                int j = 0;
                while (j < alFilesHavingThisDependency.size()) {
                    SPDXFile fileWithDependency = alFilesHavingThisDependency.get(j);
                    List alDepdenciesForThisFile = (List)filesWithDependencies.get(fileWithDependency);
                    if (alDepdenciesForThisFile == null) {
                        alDepdenciesForThisFile = Lists.newArrayList();
                        filesWithDependencies.put(fileWithDependency, alDepdenciesForThisFile);
                    }
                    alDepdenciesForThisFile.add(allFiles[i]);
                    ++j;
                }
                this.fileDependencyMap.remove(allFiles[i].getName());
            }
            ++i;
        }
        for (Map.Entry entry : filesWithDependencies.entrySet()) {
            List alDependencies = (List)entry.getValue();
            if (alDependencies == null || alDependencies.size() <= 0) continue;
            ((SPDXFile)entry.getKey()).setFileDependencies(alDependencies.toArray(new SPDXFile[alDependencies.size()]), this.analysis);
        }
        Set<String> missingDependencies = this.fileDependencyMap.keySet();
        if (missingDependencies != null && missingDependencies.size() > 0) {
            System.out.println("The following file names were listed as file dependencies but were not found in the list of files:");
            Iterator<String> missingIter = missingDependencies.iterator();
            while (missingIter.hasNext()) {
                System.out.println("\t" + missingIter.next());
            }
        }
    }

    private static void assertEquals(String name, int expected, List<String> verify) {
        if (verify.size() > expected) {
            System.out.println("The following verifications failed for the " + name + ":");
            int x = 0;
            while (x < verify.size()) {
                System.out.println("\t" + verify.get(x));
                ++x;
            }
        }
    }
}

