/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxLicenseDifference;
import org.spdx.compare.SpdxPackageComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tools.TagToRDF;

public class CompareSpdxDocs {
    static final Logger logger = LoggerFactory.getLogger((String)CompareSpdxDocs.class.getName());
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 3;
    static final int ERROR_STATUS = 1;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Insufficient arguments");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        if (args.length > 3) {
            System.out.println("Too many arguments specified");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        SpdxDocument spdxDoc1 = null;
        try {
            ArrayList<String> warnings = new ArrayList<String>();
            spdxDoc1 = CompareSpdxDocs.openRdfOrTagDoc(args[0].trim(), warnings);
            if (!warnings.isEmpty()) {
                System.out.println("Verification errors were found in " + args[0].trim() + ":");
                if (!warnings.isEmpty()) {
                    System.out.println("The following warnings and or verification errors were found:");
                    for (String warning : warnings) {
                        System.out.println("\t" + warning);
                    }
                }
            }
        }
        catch (SpdxCompareException e) {
            System.out.println("Error opening " + args[0].trim() + ":" + e.getMessage());
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        SpdxDocument spdxDoc2 = null;
        try {
            ArrayList<String> warnings = new ArrayList<String>();
            spdxDoc2 = CompareSpdxDocs.openRdfOrTagDoc(args[1].trim(), warnings);
            if (!warnings.isEmpty()) {
                System.out.println("Verification errors were found in " + args[0].trim() + ":");
                if (!warnings.isEmpty()) {
                    System.out.println("The following warnings and or verification errors were found:");
                    for (String warning : warnings) {
                        System.out.println("\t" + warning);
                    }
                }
            }
        }
        catch (SpdxCompareException e) {
            System.out.println("Error opening " + args[1].trim() + ":" + e.getMessage());
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        PrintStream output = null;
        if (args.length > 2) {
            File outFile = new File(args[2].trim());
            if (outFile.exists()) {
                System.out.println("Output file " + args[2].trim() + " already exists.");
                System.exit(1);
            }
            try {
                if (!outFile.createNewFile()) {
                    System.out.println("Can not create output file " + args[2].trim());
                    System.exit(1);
                }
            }
            catch (IOException e) {
                System.out.println("Error creating output file " + args[2].trim());
                System.exit(1);
            }
            try {
                output = new PrintStream(outFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("Error opening output file " + args[2].trim() + " for printing (" + e.getMessage());
                System.exit(1);
            }
        } else {
            output = System.out;
        }
        try {
            List<String> doc2VerificationErrors;
            List<String> doc1VerificationErrors = spdxDoc1.verify();
            if (doc1VerificationErrors.size() > 0) {
                output.println("Warning - The SPDX document " + args[0].trim() + " contains the following verification errors:");
                CompareSpdxDocs.printList(doc1VerificationErrors, output);
            }
            if ((doc2VerificationErrors = spdxDoc2.verify()).size() > 0) {
                output.println("Warning - The SPDX document " + args[1].trim() + " contains the following verification errors:");
                CompareSpdxDocs.printList(doc2VerificationErrors, output);
            }
            try {
                SpdxComparer comparer = new SpdxComparer();
                comparer.compare(spdxDoc1, spdxDoc2);
                String docName1 = CompareSpdxDocs.convertDocName(args[0]);
                String docName2 = CompareSpdxDocs.convertDocName(args[1]);
                if (docName1.equals(docName2)) {
                    docName1 = args[0];
                    docName2 = args[1];
                }
                CompareSpdxDocs.printCompareResults(comparer, docName1, docName2, spdxDoc1, spdxDoc2, output);
            }
            catch (SpdxCompareException e) {
                output.println("Error in comparing SPDX documents: " + e.getMessage());
                System.exit(1);
            }
            catch (InvalidSPDXAnalysisException e) {
                output.println("SPDX Analysis Error in comparing SPDX documents: " + e.getMessage());
                System.exit(1);
            }
        }
        finally {
            if (output != System.out) {
                output.close();
            }
        }
        System.exit(0);
    }

    protected static String convertDocName(String docPath) {
        if (docPath.contains(File.separator)) {
            File docFile = new File(docPath);
            return docFile.getName();
        }
        try {
            URI uri = new URI(docPath);
            String path = uri.getPath();
            return path;
        }
        catch (URISyntaxException e) {
            return docPath;
        }
    }

    private static void printList(List<String> list, PrintStream output) {
        int i = 0;
        while (i < list.size()) {
            output.println(list.get(i));
            ++i;
        }
    }

    private static void printCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, SpdxDocument spdxDoc1, SpdxDocument spdxDoc2, PrintStream output) throws SpdxCompareException, InvalidSPDXAnalysisException {
        int i;
        RdfModelObject[] uniqueB;
        RdfModelObject[] uniqueA;
        output.println("Comparing SPDX Documents: " + doc1Name + " and " + doc2Name);
        output.println(String.valueOf(doc1Name) + " Namespace: " + comparer.getSpdxDoc(0).getDocumentNamespace());
        output.println(String.valueOf(doc2Name) + " NamespaceI: " + comparer.getSpdxDoc(1).getDocumentNamespace());
        if (!comparer.isDifferenceFound()) {
            output.println("Both SPDX documents match - no differences found.");
            return;
        }
        if (!comparer.isSpdxVersionEqual()) {
            output.println("SPDX versions differ.");
            output.println("\t" + doc1Name + ":" + comparer.getSpdxDoc(0).getSpecVersion());
            output.println("\t" + doc2Name + ":" + comparer.getSpdxDoc(1).getSpecVersion());
        }
        if (!comparer.isDataLicenseEqual()) {
            output.println("SPDX data license differ.");
            output.println("\t" + doc1Name + ":" + comparer.getSpdxDoc(0).getDataLicense().toString());
            output.println("\t" + doc2Name + ":" + comparer.getSpdxDoc(1).getDataLicense().toString());
        }
        if (!comparer.isExternalDcoumentRefsEquals()) {
            uniqueA = comparer.getUniqueExternalDocumentRefs(0, 1);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following external document references were only found in " + doc1Name);
                int i2 = 0;
                while (i2 < uniqueA.length) {
                    CompareSpdxDocs.printExternalDocumentRef((ExternalDocumentRef)uniqueA[i2], output);
                    ++i2;
                }
            }
            if ((uniqueB = comparer.getUniqueExternalDocumentRefs(1, 0)) != null && uniqueB.length > 0) {
                output.println("The following external document references were only found in " + doc2Name);
                i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printExternalDocumentRef((ExternalDocumentRef)uniqueB[i], output);
                    ++i;
                }
            }
        }
        if (!comparer.isDocumentCommentsEqual()) {
            output.println("SPDX document comments differ.");
            if (comparer.getSpdxDoc(0).getComment() == null) {
                output.println("\t" + doc1Name + ": [No comment]");
            } else {
                output.println("\t" + doc1Name + ":" + comparer.getSpdxDoc(0).getComment());
            }
            if (comparer.getSpdxDoc(1).getComment() == null) {
                output.println("\t" + doc2Name + ": [No comment]");
            } else {
                output.println("\t" + doc2Name + ":" + comparer.getSpdxDoc(1).getComment());
            }
        }
        if (!comparer.isDocumentAnnotationsEquals()) {
            uniqueA = comparer.getUniqueDocumentAnnotations(0, 1);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following document annotations were only found in " + doc1Name);
                int i3 = 0;
                while (i3 < uniqueA.length) {
                    CompareSpdxDocs.printAnnotation((Annotation)uniqueA[i3], output);
                    ++i3;
                }
            }
            if ((uniqueB = comparer.getUniqueDocumentAnnotations(1, 0)) != null && uniqueB.length > 0) {
                output.println("The following document annotations were only found in " + doc2Name);
                i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printAnnotation((Annotation)uniqueB[i], output);
                    ++i;
                }
            }
        }
        CompareSpdxDocs.printCreatorCompareResults(comparer, doc1Name, doc2Name, output);
        if (!comparer.isDocumentRelationshipsEquals()) {
            Relationship[] uniqueB2;
            uniqueA = comparer.getUniqueDocumentRelationship(0, 1);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following document relationships were only found in " + doc1Name);
                int i4 = 0;
                while (i4 < uniqueA.length) {
                    CompareSpdxDocs.printRelationship((Relationship)uniqueA[i4], "SpdxRef-DOCUMENT", output);
                    ++i4;
                }
            }
            if ((uniqueB2 = comparer.getUniqueDocumentRelationship(1, 0)) != null && uniqueB2.length > 0) {
                output.println("The following document relationships were only found in " + doc2Name);
                i = 0;
                while (i < uniqueB2.length) {
                    CompareSpdxDocs.printRelationship(uniqueB2[i], "SpdxRef-DOCUMENT", output);
                    ++i;
                }
            }
        }
        CompareSpdxDocs.printPackageCompareResults(comparer, doc1Name, doc2Name, spdxDoc1, spdxDoc2, output);
        CompareSpdxDocs.printFileCompareResults(comparer, doc1Name, doc2Name, output);
        CompareSpdxDocs.printExtractedLicenseCompareResults(comparer, doc1Name, doc2Name, output);
        CompareSpdxDocs.printReviewerCompareResults(comparer, doc1Name, doc2Name, output);
    }

    private static void printRelationship(Relationship relationship, String elementId, PrintStream output) {
        String relatedElementId = "[NONE]";
        if (relationship.getRelatedSpdxElement() != null) {
            relatedElementId = relationship.getRelatedSpdxElement().getId();
        }
        output.println("\tRelationship: " + elementId + relationship.getRelationshipType().toTag() + " " + relatedElementId);
        if (relationship.getComment() != null && !relationship.getComment().isEmpty()) {
            output.println("\tRelationshipComment: " + relationship.getComment());
        }
    }

    private static void printAnnotation(Annotation annotation, PrintStream output) {
        output.println("\tAnnotator: " + annotation.getAnnotator());
        output.println("\tAnnotationDate: " + annotation.getAnnotationDate());
        output.println("\tAnnotationType: " + annotation.getAnnotationType().getTag());
        output.println("\tAnnotationComment: " + annotation.getComment());
    }

    private static void printExternalDocumentRef(ExternalDocumentRef externalDocumentRef, PrintStream output) throws InvalidSPDXAnalysisException {
        output.println("\tExternalDocumentRef: " + externalDocumentRef.getExternalDocumentId() + " " + externalDocumentRef.getSpdxDocumentNamespace() + " SHA1:" + externalDocumentRef.getChecksum().getValue());
    }

    private static void printFileCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, PrintStream output) throws SpdxCompareException {
        if (!comparer.isfilesEquals()) {
            SpdxFileDifference[] fileDifferences;
            SpdxFile[] inDoc2notInDoc1;
            SpdxFile[] inDoc1notInDoc2 = comparer.getUniqueFiles(0, 1);
            if (inDoc1notInDoc2 != null && inDoc1notInDoc2.length > 0) {
                output.println("The following file(s) are in " + doc1Name + " but not in " + doc2Name);
                int i = 0;
                while (i < inDoc1notInDoc2.length) {
                    CompareSpdxDocs.printSpdxFile(inDoc1notInDoc2[i], output);
                    ++i;
                }
            }
            if ((inDoc2notInDoc1 = comparer.getUniqueFiles(1, 0)) != null && inDoc2notInDoc1.length > 0) {
                output.println("The following file(s) are in " + doc2Name + " but not in " + doc1Name);
                int i = 0;
                while (i < inDoc2notInDoc1.length) {
                    CompareSpdxDocs.printSpdxFile(inDoc2notInDoc1[i], output);
                    ++i;
                }
            }
            if ((fileDifferences = comparer.getFileDifferences(0, 1)) != null && fileDifferences.length > 0) {
                int i = 0;
                while (i < fileDifferences.length) {
                    CompareSpdxDocs.printFileDifference(fileDifferences[i], output, doc1Name, doc2Name);
                    ++i;
                }
            }
        }
    }

    private static void printFileDifference(SpdxFileDifference spdxFileDifference, PrintStream output, String doc1Name, String doc2Name) {
        int i;
        RdfModelObject[] uniqueB;
        RdfModelObject[] uniqueA;
        if (!spdxFileDifference.isConcludedLicenseEquals()) {
            output.println("File concluded license differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + ":" + spdxFileDifference.getConcludedLicenseA());
            output.println("\t" + doc2Name + ":" + spdxFileDifference.getConcludedLicenseB());
        }
        if (!spdxFileDifference.isCopyrightsEqual()) {
            output.println("File copyrights differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + ":" + spdxFileDifference.getCopyrightA());
            output.println("\t" + doc2Name + ":" + spdxFileDifference.getCopyrightB());
        }
        if (!spdxFileDifference.isCommentsEquals()) {
            output.println("File comments differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + ":" + spdxFileDifference.getCommentA());
            output.println("\t" + doc2Name + ":" + spdxFileDifference.getCommentB());
        }
        if (!spdxFileDifference.isChecksumsEquals()) {
            uniqueA = spdxFileDifference.getUniqueChecksumsA();
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("Checksums only in document " + doc1Name + " for file " + spdxFileDifference.getFileName() + ":");
                int i2 = 0;
                while (i2 < uniqueA.length) {
                    CompareSpdxDocs.printChecksum((Checksum)uniqueA[i2], output);
                    ++i2;
                }
            }
            if ((uniqueB = spdxFileDifference.getUniqueChecksumsB()) != null && uniqueB.length > 0) {
                output.println("Checksums only in document " + doc2Name + " for file " + spdxFileDifference.getFileName() + ":");
                i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printChecksum((Checksum)uniqueB[i], output);
                    ++i;
                }
            }
        }
        if (!spdxFileDifference.isTypeEqual()) {
            output.println("File types differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + ":" + CompareSpdxDocs.formatFileTypes(spdxFileDifference.getFileTypeA()));
            output.println("\t" + doc2Name + ":" + CompareSpdxDocs.formatFileTypes(spdxFileDifference.getFileTypeB()));
        }
        if (!spdxFileDifference.isContributorsEqual()) {
            output.println("File contributors differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + ":" + spdxFileDifference.getContributorsAAsString());
            output.println("\t" + doc2Name + ":" + spdxFileDifference.getContributorsBAsString());
        }
        if (!spdxFileDifference.isFileDependenciesEqual()) {
            output.println("File contributors differ for file " + spdxFileDifference.getFileName() + ":");
            output.println("\t" + doc1Name + "dependencies:" + spdxFileDifference.getFileDependenciesAAsString());
            output.println("\t" + doc2Name + ":" + spdxFileDifference.getFileDependenciesBAsString());
        }
        if (!spdxFileDifference.isSeenLicensesEquals()) {
            if (spdxFileDifference.getUniqueSeenLicensesA() != null && spdxFileDifference.getUniqueSeenLicensesA().length > 0) {
                output.println("The following license information was only found in " + doc1Name + " for file " + spdxFileDifference.getFileName());
                int i3 = 0;
                while (i3 < spdxFileDifference.getUniqueSeenLicensesA().length) {
                    output.println("\t" + spdxFileDifference.getUniqueSeenLicensesA()[i3].toString());
                    ++i3;
                }
            }
            if (spdxFileDifference.getUniqueSeenLicensesB() != null && spdxFileDifference.getUniqueSeenLicensesB().length > 0) {
                output.println("The following license information was only found in " + doc2Name + " for file " + spdxFileDifference.getFileName());
                int i4 = 0;
                while (i4 < spdxFileDifference.getUniqueSeenLicensesB().length) {
                    output.println("\t" + spdxFileDifference.getUniqueSeenLicensesB()[i4].toString());
                    ++i4;
                }
            }
        }
        if (!spdxFileDifference.isArtifactOfsEquals()) {
            if (spdxFileDifference.getUniqueArtifactOfA() != null && spdxFileDifference.getUniqueArtifactOfA().length > 0) {
                output.println("The following artifactOf information was only found in " + doc1Name + " for file " + spdxFileDifference.getFileName());
                int i5 = 0;
                while (i5 < spdxFileDifference.getUniqueArtifactOfA().length) {
                    CompareSpdxDocs.printDoapProject(spdxFileDifference.getUniqueArtifactOfA()[i5], output);
                    ++i5;
                }
            }
            if (spdxFileDifference.getUniqueArtifactOfB() != null && spdxFileDifference.getUniqueArtifactOfB().length > 0) {
                output.println("The following artifactOf information was only found in " + doc2Name + " for file " + spdxFileDifference.getFileName());
                int i6 = 0;
                while (i6 < spdxFileDifference.getUniqueArtifactOfB().length) {
                    CompareSpdxDocs.printDoapProject(spdxFileDifference.getUniqueArtifactOfB()[i6], output);
                    ++i6;
                }
            }
        }
        if (!spdxFileDifference.isRelationshipsEquals()) {
            uniqueA = spdxFileDifference.getUniqueRelationshipA();
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following relationships are only present in " + doc1Name + ":");
                int i7 = 0;
                while (i7 < uniqueA.length) {
                    CompareSpdxDocs.printRelationship((Relationship)uniqueA[i7], spdxFileDifference.getSpdxIdA(), output);
                    ++i7;
                }
            }
            if ((uniqueB = spdxFileDifference.getUniqueRelationshipB()) != null && uniqueB.length > 0) {
                output.println("The following relationships are only present in " + doc2Name + ":");
                i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printRelationship((Relationship)uniqueB[i], spdxFileDifference.getSpdxIdB(), output);
                    ++i;
                }
            }
        }
        if (!spdxFileDifference.isAnnotationsEquals()) {
            Annotation[] uniqueB2;
            uniqueA = spdxFileDifference.getUniqueAnnotationsA();
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following annotations are only present in " + doc1Name + ":");
                int i8 = 0;
                while (i8 < uniqueA.length) {
                    CompareSpdxDocs.printAnnotation((Annotation)uniqueA[i8], output);
                    ++i8;
                }
            }
            if ((uniqueB2 = spdxFileDifference.getUniqueAnnotationsB()) != null && uniqueB2.length > 0) {
                output.println("The following annotations are only present in " + doc2Name + ":");
                i = 0;
                while (i < uniqueB2.length) {
                    CompareSpdxDocs.printAnnotation(uniqueB2[i], output);
                    ++i;
                }
            }
        }
    }

    private static String formatFileTypes(SpdxFile.FileType[] fileTypes) {
        if (fileTypes == null || fileTypes.length == 0) {
            return "";
        }
        Arrays.sort((Object[])fileTypes);
        StringBuilder sb = new StringBuilder(fileTypes[0].getTag());
        int i = 1;
        while (i < fileTypes.length) {
            sb.append(", ");
            sb.append(fileTypes[i].getTag());
            ++i;
        }
        return sb.toString();
    }

    private static void printChecksum(Checksum checksum, PrintStream output) {
        output.println("\tAlgorithm: " + (String)Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)checksum.getAlgorithm()) + " Value: " + checksum.getValue());
    }

    private static void printDoapProject(DoapProject doapProject, PrintStream output) {
        if (doapProject.getName() != null && !doapProject.getName().isEmpty()) {
            output.println("\tProject Name: " + doapProject.getName());
        }
        if (doapProject.getHomePage() != null && !doapProject.getHomePage().isEmpty()) {
            output.println("\tProject Home Page: " + doapProject.getName());
        }
        if (doapProject.getProjectUri() != null && !doapProject.getProjectUri().isEmpty()) {
            output.println("\tProject URI: " + doapProject.getProjectUri());
        }
    }

    private static void printSpdxFile(SpdxFile spdxFile, PrintStream output) {
        output.println("\t" + spdxFile.getName() + ", checksum:" + spdxFile.getSha1());
    }

    private static void printReviewerCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, PrintStream output) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (!comparer.isReviewersEqual()) {
            SPDXReview[] inDoc2notInDoc1;
            SPDXReview[] inDoc1notInDoc2 = comparer.getUniqueReviewers(0, 1);
            if (inDoc1notInDoc2.length > 0) {
                output.println("The following Reviewer(s) are in " + doc1Name + " but not in " + doc2Name);
                int i = 0;
                while (i < inDoc1notInDoc2.length) {
                    CompareSpdxDocs.printReviewer(inDoc1notInDoc2[i], output);
                    ++i;
                }
            }
            if ((inDoc2notInDoc1 = comparer.getUniqueReviewers(1, 0)).length > 0) {
                output.println("The following Reviewer(s) are in " + doc2Name + " but not in " + doc1Name);
                int i = 0;
                while (i < inDoc2notInDoc1.length) {
                    CompareSpdxDocs.printReviewer(inDoc2notInDoc1[i], output);
                    ++i;
                }
            }
            SpdxComparer.SPDXReviewDifference[] differentReviewerInfo = comparer.getReviewerDifferences(0, 1);
            int i = 0;
            while (i < differentReviewerInfo.length) {
                if (!differentReviewerInfo[i].isDateEqual()) {
                    output.println("Date is different for the SPDX Review by " + differentReviewerInfo[i].getReviewer() + ":");
                    output.println("\t" + doc1Name + ":" + differentReviewerInfo[i].getDate(0));
                    output.println("\t" + doc2Name + ":" + differentReviewerInfo[i].getDate(1));
                }
                if (!differentReviewerInfo[i].isCommentEqual()) {
                    output.println("Comment is different for the SPDX Review by " + differentReviewerInfo[i].getReviewer() + ":");
                    output.println("\t" + doc1Name + ":" + differentReviewerInfo[i].getComment(0));
                    output.println("\t" + doc2Name + ":" + differentReviewerInfo[i].getComment(1));
                }
                ++i;
            }
        }
    }

    private static void printReviewer(SPDXReview spdxReview, PrintStream output) {
        output.println("\tReviewer:\t" + spdxReview.getReviewer());
        output.println("\tReview Date:\t" + spdxReview.getReviewDate());
        if (!spdxReview.getComment().trim().isEmpty()) {
            output.println("\tReview Comment:\t" + spdxReview.getComment());
        }
    }

    private static void printExtractedLicenseCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, PrintStream output) throws SpdxCompareException {
        if (!comparer.isExtractedLicensingInfosEqual()) {
            ExtractedLicenseInfo[] inDoc2notInDoc1;
            ExtractedLicenseInfo[] inDoc1notInDoc2 = comparer.getUniqueExtractedLicenses(0, 1);
            if (inDoc1notInDoc2 != null && inDoc1notInDoc2.length > 0) {
                output.println("The following extracted licensing infos were only found in " + doc1Name);
                int i = 0;
                while (i < inDoc1notInDoc2.length) {
                    CompareSpdxDocs.printSpdxLicenseInfo(inDoc1notInDoc2[i], output);
                    ++i;
                }
            }
            if ((inDoc2notInDoc1 = comparer.getUniqueExtractedLicenses(1, 0)) != null && inDoc2notInDoc1.length > 0) {
                output.println("The following extracted licensing infos were only found in " + doc2Name);
                int i = 0;
                while (i < inDoc2notInDoc1.length) {
                    CompareSpdxDocs.printSpdxLicenseInfo(inDoc2notInDoc1[i], output);
                    ++i;
                }
            }
            SpdxLicenseDifference[] differentLicenses = comparer.getExtractedLicenseDifferences(0, 1);
            int i = 0;
            while (i < differentLicenses.length) {
                if (!differentLicenses[i].isCommentsEqual()) {
                    output.println("The comments differ for the extracted license:");
                    if (differentLicenses[i].getCommentA() == null || differentLicenses[i].getCommentA().length() == 0) {
                        output.println("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + ": [no comment]");
                    } else {
                        output.print("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + ": ");
                        output.println("\"" + differentLicenses[i].getCommentA() + "\"");
                    }
                    if (differentLicenses[i].getCommentB() == null || differentLicenses[i].getCommentB().length() == 0) {
                        output.println("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + ": [no comment]");
                    } else {
                        output.print("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + ": ");
                        output.println("\"" + differentLicenses[i].getCommentB() + "\"");
                    }
                }
                if (!differentLicenses[i].isLicenseNamesEqual()) {
                    output.println("The license names differ for the extracted license:");
                    if (differentLicenses[i].getLicenseNameA() == null || differentLicenses[i].getLicenseNameA().length() == 0) {
                        output.println("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + ": [no license name]");
                    } else {
                        output.println("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + " \"" + differentLicenses[i].getLicenseNameA() + "\"");
                    }
                    if (differentLicenses[i].getLicenseNameB() == null || differentLicenses[i].getLicenseNameB().length() == 0) {
                        output.println("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + ": [no license name]");
                    } else {
                        output.println("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + " \"" + differentLicenses[i].getLicenseNameB() + "\"");
                    }
                }
                if (!differentLicenses[i].isSourceUrlsEqual()) {
                    output.println("The source URL's differ for the extracted license:");
                    String[] sourceUrlsA = differentLicenses[i].getSourceUrlsA();
                    if (sourceUrlsA == null || sourceUrlsA.length == 0) {
                        output.println("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + ": [no source URL]");
                    } else {
                        output.println("\tId " + differentLicenses[i].getIdA() + " in " + doc1Name + " source URLs:");
                        int j = 0;
                        while (j < sourceUrlsA.length) {
                            output.println("\t\t" + sourceUrlsA[j]);
                            ++j;
                        }
                    }
                    String[] sourceUrlsB = differentLicenses[i].getSourceUrlsB();
                    if (sourceUrlsB == null || sourceUrlsB.length == 0) {
                        output.println("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + ": [no source URL]");
                    } else {
                        output.println("\tId " + differentLicenses[i].getIdB() + " in " + doc2Name + " source URLs:");
                        int j = 0;
                        while (j < sourceUrlsB.length) {
                            output.println("\t\t" + sourceUrlsB[j]);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static void printSpdxLicenseInfo(ExtractedLicenseInfo nonStdLicense, PrintStream output) {
        output.println("\tID: " + nonStdLicense.getLicenseId());
        if (nonStdLicense.getComment() != null && !nonStdLicense.getComment().trim().isEmpty()) {
            output.println("\tComment: " + nonStdLicense.getComment());
        }
        if (nonStdLicense.getName() != null && !nonStdLicense.getName().trim().isEmpty()) {
            output.println("\tLicense Name: " + nonStdLicense.getName());
        }
        if (nonStdLicense.getSeeAlso() != null && nonStdLicense.getSeeAlso().length > 0) {
            output.println("\tSource URLs:");
            int i = 0;
            while (i < nonStdLicense.getSeeAlso().length) {
                output.println("\t\t" + nonStdLicense.getSeeAlso()[i]);
                ++i;
            }
        }
        output.println("\tText: \"" + nonStdLicense.getExtractedText() + "\"");
    }

    private static void printPackageCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, SpdxDocument spdxDoc1, SpdxDocument spdxDoc2, PrintStream output) throws SpdxCompareException, InvalidSPDXAnalysisException {
        SpdxPackageComparer[] differences;
        SpdxPackage[] uniqueB;
        SpdxPackage[] uniqueA = comparer.getUniquePackages(0, 1);
        if (uniqueA != null && uniqueA.length > 0) {
            output.println("The following packages are in " + doc1Name + " but not in " + doc2Name + ":");
            int i = 0;
            while (i < uniqueA.length) {
                output.println("\t" + uniqueA[i].getName());
                ++i;
            }
        }
        if ((uniqueB = comparer.getUniquePackages(1, 0)) != null && uniqueB.length > 0) {
            output.println("The following packages are in " + doc2Name + " but not in " + doc1Name + ":");
            int i = 0;
            while (i < uniqueB.length) {
                output.println("\t" + uniqueB[i].getName());
                ++i;
            }
        }
        if ((differences = comparer.getPackageDifferences()) != null && differences.length > 0) {
            int i = 0;
            while (i < differences.length) {
                output.println("Differences were found in the package " + differences[i].getDocPackage(spdxDoc1).getName());
                CompareSpdxDocs.printPackageDifference(differences[i], doc1Name, doc2Name, spdxDoc1, spdxDoc2, output);
                ++i;
            }
        }
    }

    private static void printPackageDifference(SpdxPackageComparer spdxPackageComparer, String doc1Name, String doc2Name, SpdxDocument spdxDoc1, SpdxDocument spdxDoc2, PrintStream output) throws SpdxCompareException, InvalidSPDXAnalysisException {
        RdfModelObject[] uniqueB;
        RdfModelObject[] uniqueA;
        String s2;
        String s1;
        if (!spdxPackageComparer.isPackageVersionsEquals()) {
            output.println("Package versions differ.");
            output.print("\t" + doc1Name + ": ");
            if (spdxPackageComparer.getDocPackage(spdxDoc1).getVersionInfo() != null) {
                output.println(spdxPackageComparer.getDocPackage(spdxDoc1).getVersionInfo());
            } else {
                output.println("[none]");
            }
            output.print("\t" + doc2Name + ": ");
            if (spdxPackageComparer.getDocPackage(spdxDoc2).getVersionInfo() != null) {
                output.println(spdxPackageComparer.getDocPackage(spdxDoc2).getVersionInfo());
            } else {
                output.println("[none]");
            }
        }
        if (!spdxPackageComparer.isPackageSuppliersEquals()) {
            output.println("Package supplier information differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getSupplier();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no supplier information]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getSupplier();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no supplier information]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isPackageOriginatorsEqual()) {
            output.println("Package originator information differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getOriginator();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no originator information]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getOriginator();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no originator information]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isPackageDownloadLocationsEquals()) {
            output.println("Package download locations differ.");
            output.println("\t" + doc1Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc1).getDownloadLocation());
            output.println("\t" + doc2Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc2).getDownloadLocation());
        }
        if (!spdxPackageComparer.isPackageHomePagesEquals()) {
            output.println("Package home page differ.");
            if (spdxPackageComparer.getDocPackage(spdxDoc1).getHomepage() == null) {
                output.println("\t" + doc1Name + ": [No home page information]");
            } else {
                output.println("\t" + doc1Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc1).getHomepage());
            }
            if (spdxPackageComparer.getDocPackage(spdxDoc2).getHomepage() == null) {
                output.println("\t" + doc2Name + ": [No home page information]");
            } else {
                output.println("\t" + doc2Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc2).getHomepage());
            }
        }
        if (!spdxPackageComparer.isPackageVerificationCodesEquals()) {
            output.println("Package verification codees differ.");
            CompareSpdxDocs.printVerificationCode(spdxPackageComparer.getDocPackage(spdxDoc1).getPackageVerificationCode(), doc1Name, output);
            CompareSpdxDocs.printVerificationCode(spdxPackageComparer.getDocPackage(spdxDoc2).getPackageVerificationCode(), doc2Name, output);
        }
        if (!spdxPackageComparer.isPackageChecksumsEquals()) {
            uniqueA = spdxPackageComparer.getUniqueChecksums(spdxDoc1, spdxDoc2);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("Checksums for package only in document " + doc1Name + ":");
                int i = 0;
                while (i < uniqueA.length) {
                    CompareSpdxDocs.printChecksum(uniqueA[i], output);
                    ++i;
                }
            }
            if ((uniqueB = spdxPackageComparer.getUniqueChecksums(spdxDoc2, spdxDoc1)) != null && uniqueB.length > 0) {
                output.println("Checksums only in document " + doc2Name + ":");
                int i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printChecksum(uniqueB[i], output);
                    ++i;
                }
            }
        }
        if (!spdxPackageComparer.isPackageSourceInfosEquals()) {
            output.println("Package source information differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getSourceInfo();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no source information]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getSourceInfo();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no source information]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isDeclaredLicensesEquals()) {
            output.println("Declared licenses differ.");
            output.println("\t" + doc1Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc1).getLicenseDeclared().toString());
            output.println("\t" + doc2Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc2).getLicenseDeclared().toString());
        }
        if (!spdxPackageComparer.isConcludedLicenseEquals()) {
            output.println("Concluded licenses differ.");
            output.println("\t" + doc1Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc1).getLicenseConcluded().toString());
            output.println("\t" + doc2Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc2).getLicenseConcluded().toString());
        }
        if (!spdxPackageComparer.isSeenLicenseEquals()) {
            output.println("License information from files differ.");
            Object[] fromFiles1 = spdxPackageComparer.getDocPackage(spdxDoc1).getLicenseInfoFromFiles();
            StringBuilder sb = new StringBuilder();
            if (fromFiles1 != null && fromFiles1.length > 0) {
                sb.append(Joiner.on((String)", ").skipNulls().join(fromFiles1));
            }
            output.println("\t" + doc1Name + ": " + sb.toString());
            sb = new StringBuilder();
            Object[] fromFiles2 = spdxPackageComparer.getDocPackage(spdxDoc2).getLicenseInfoFromFiles();
            if (fromFiles2 != null && fromFiles2.length > 0) {
                sb.append(Joiner.on((String)", ").skipNulls().join(fromFiles2));
            }
            output.println("\t" + doc2Name + ": " + sb.toString());
        }
        if (!spdxPackageComparer.isLicenseCommmentsEquals()) {
            output.println("Package license comments differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getLicenseComments();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no license comments]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getLicenseComments();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no license comments]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isCopyrightsEquals()) {
            output.println("Copyright texts differ.");
            output.println("\t" + doc1Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc1).getCopyrightText());
            output.println("\t" + doc2Name + ": " + spdxPackageComparer.getDocPackage(spdxDoc2).getCopyrightText());
        }
        if (!spdxPackageComparer.isPackageSummaryEquals()) {
            output.println("Package summaries differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getSummary();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no package summary]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getSummary();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no package summary]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isPackageDescriptionsEquals()) {
            output.println("Package detailed descriptions differ.");
            s1 = spdxPackageComparer.getDocPackage(spdxDoc1).getDescription();
            if (s1 == null || s1.trim().isEmpty()) {
                output.println("\t" + doc1Name + ": [no package detailed description]");
            } else {
                output.println("\t" + doc1Name + ": " + s1);
            }
            s2 = spdxPackageComparer.getDocPackage(spdxDoc2).getDescription();
            if (s2 == null || s2.trim().isEmpty()) {
                output.println("\t" + doc2Name + ": [no package detailed description]");
            } else {
                output.println("\t" + doc2Name + ": " + s2);
            }
        }
        if (!spdxPackageComparer.isRelationshipsEquals()) {
            uniqueA = spdxPackageComparer.getUniqueRelationship(spdxDoc1, spdxDoc2);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following relationships are only present in " + doc1Name + ":");
                int i = 0;
                while (i < uniqueA.length) {
                    CompareSpdxDocs.printRelationship((Relationship)uniqueA[i], spdxPackageComparer.getDocPackage(spdxDoc1).getId(), output);
                    ++i;
                }
            }
            if ((uniqueB = spdxPackageComparer.getUniqueRelationship(spdxDoc2, spdxDoc1)) != null && uniqueB.length > 0) {
                output.println("The following relationships are only present in " + doc2Name + ":");
                int i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printRelationship((Relationship)uniqueB[i], spdxPackageComparer.getDocPackage(spdxDoc2).getId(), output);
                    ++i;
                }
            }
        }
        if (!spdxPackageComparer.isAnnotationsEquals()) {
            uniqueA = spdxPackageComparer.getUniqueAnnotations(spdxDoc1, spdxDoc2);
            if (uniqueA != null && uniqueA.length > 0) {
                output.println("The following annotations are only present in " + doc1Name + ":");
                int i = 0;
                while (i < uniqueA.length) {
                    CompareSpdxDocs.printAnnotation((Annotation)uniqueA[i], output);
                    ++i;
                }
            }
            if ((uniqueB = spdxPackageComparer.getUniqueAnnotations(spdxDoc2, spdxDoc1)) != null && uniqueB.length > 0) {
                output.println("The following annotations are only present in " + doc2Name + ":");
                int i = 0;
                while (i < uniqueB.length) {
                    CompareSpdxDocs.printAnnotation((Annotation)uniqueB[i], output);
                    ++i;
                }
            }
        }
        if (!spdxPackageComparer.isPackageFilesEquals()) {
            if (spdxPackageComparer.getUniqueFiles(spdxDoc1, spdxDoc2).length > 0) {
                output.println("The following files are only present in " + spdxPackageComparer.getDocPackage(spdxDoc1).getName() + " in " + doc1Name + ":");
                int i = 0;
                while (i < spdxPackageComparer.getUniqueFiles(spdxDoc1, spdxDoc2).length) {
                    output.println("\t" + spdxPackageComparer.getUniqueFiles(spdxDoc1, spdxDoc2)[i].getName());
                    ++i;
                }
            }
            if (spdxPackageComparer.getUniqueFiles(spdxDoc2, spdxDoc1).length > 0) {
                output.println("The following files are only present in " + spdxPackageComparer.getDocPackage(spdxDoc2).getName() + " in " + doc2Name + ":");
                int i = 0;
                while (i < spdxPackageComparer.getUniqueFiles(spdxDoc2, spdxDoc1).length) {
                    output.println("\t" + spdxPackageComparer.getUniqueFiles(spdxDoc2, spdxDoc1)[i].getName());
                    ++i;
                }
            }
            if (spdxPackageComparer.getFileDifferences(spdxDoc2, spdxDoc1).length > 0) {
                output.println("The following file differences were found in " + spdxPackageComparer.getDocPackage(spdxDoc2).getName());
                int i = 0;
                while (i < spdxPackageComparer.getFileDifferences(spdxDoc2, spdxDoc1).length) {
                    CompareSpdxDocs.printFileDifference(spdxPackageComparer.getFileDifferences(spdxDoc2, spdxDoc1)[i], output, doc1Name, doc2Name);
                    ++i;
                }
            }
        }
    }

    private static void printVerificationCode(SpdxPackageVerificationCode verificationCode, String docName, PrintStream output) {
        output.println("Verification code value for " + docName + ": " + verificationCode.getValue());
        if (verificationCode.getExcludedFileNames() != null && verificationCode.getExcludedFileNames().length > 0) {
            output.println("The following files were excluded from the verification code for " + docName + ":");
            int i = 0;
            while (i < verificationCode.getExcludedFileNames().length) {
                output.println("\t" + verificationCode.getExcludedFileNames()[i]);
                ++i;
            }
        }
    }

    private static void printCreatorCompareResults(SpdxComparer comparer, String doc1Name, String doc2Name, PrintStream output) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (!comparer.isCreatorInformationEqual()) {
            String[] inDoc2NotDoc1;
            String[] inDoc1NotDoc2 = comparer.getUniqueCreators(0, 1);
            if (inDoc1NotDoc2 != null && inDoc1NotDoc2.length > 0) {
                output.println("The following creators are in " + doc1Name + " and not in " + doc2Name);
                int i = 0;
                while (i < inDoc1NotDoc2.length) {
                    output.println("\t" + inDoc1NotDoc2[i]);
                    ++i;
                }
            }
            if ((inDoc2NotDoc1 = comparer.getUniqueCreators(1, 0)) != null && inDoc2NotDoc1.length > 0) {
                output.println("The following creators are in " + doc2Name + " and not in " + doc1Name);
                int i = 0;
                while (i < inDoc2NotDoc1.length) {
                    output.println("\t" + inDoc2NotDoc1[i]);
                    ++i;
                }
            }
            SPDXCreatorInformation doc1CreatorInfo = comparer.getSpdxDoc(0).getCreationInfo();
            SPDXCreatorInformation doc2CreatorInfo = comparer.getSpdxDoc(1).getCreationInfo();
            if (!SpdxComparer.stringsEqual(doc1CreatorInfo.getCreated(), doc2CreatorInfo.getCreated())) {
                output.println("Creator creation dates differ.");
                if (doc1CreatorInfo.getCreated() == null) {
                    output.println("\t" + doc1Name + ": No creation date");
                } else {
                    output.println("\t" + doc1Name + ": " + doc1CreatorInfo.getCreated());
                }
                if (doc2CreatorInfo.getCreated() == null) {
                    output.println("\t" + doc2Name + ": No creation date");
                } else {
                    output.println("\t" + doc2Name + ": " + doc2CreatorInfo.getCreated());
                }
            }
            if (!SpdxComparer.stringsEqual(doc1CreatorInfo.getComment(), doc2CreatorInfo.getComment())) {
                output.println("Creator comments differ.");
                if (doc1CreatorInfo.getComment() == null) {
                    output.println("\t" + doc1Name + ": [No comment]");
                } else {
                    output.println("\t" + doc1Name + ": " + doc1CreatorInfo.getComment());
                }
                if (doc2CreatorInfo.getComment() == null) {
                    output.println("\t" + doc2Name + ": [No comment]");
                } else {
                    output.println("\t" + doc2Name + ": " + doc2CreatorInfo.getComment());
                }
            }
            if (!SpdxComparer.stringsEqual(doc1CreatorInfo.getLicenseListVersion(), doc2CreatorInfo.getLicenseListVersion())) {
                output.println("License list versions differ.");
                if (doc1CreatorInfo.getLicenseListVersion() == null) {
                    output.println("\t" + doc1Name + ": [No license list version]");
                } else {
                    output.println("\t" + doc1Name + ": " + doc1CreatorInfo.getLicenseListVersion());
                }
                if (doc2CreatorInfo.getLicenseListVersion() == null) {
                    output.println("\t" + doc2Name + ": [No license list version]");
                } else {
                    output.println("\t" + doc2Name + ": " + doc2CreatorInfo.getLicenseListVersion());
                }
            }
        }
    }

    protected static SpdxDocument openRdfOrTagDoc(String spdxDocFileName, List<String> warnings) throws SpdxCompareException {
        File spdxDocFile = new File(spdxDocFileName);
        if (!spdxDocFile.exists()) {
            throw new SpdxCompareException("SPDX File " + spdxDocFileName + " does not exist.");
        }
        if (!spdxDocFile.canRead()) {
            throw new SpdxCompareException("SPDX File " + spdxDocFileName + " can not be read.");
        }
        SpdxDocument retval = null;
        String errorDetails1 = "(no error details available)";
        String errorDetails2 = "(no error details available)";
        try {
            retval = CompareSpdxDocs.convertTagValueToRdf(spdxDocFile, warnings);
            logger.info("Document identified as SPDX tag/value.");
        }
        catch (SpdxCompareException e) {
            errorDetails1 = e.getMessage();
            throw new SpdxCompareException("File " + spdxDocFileName + " is not a recognized RDF/XML or tag/value format: " + errorDetails1);
        }
        catch (Exception e) {
            errorDetails1 = e.getMessage();
        }
        if (retval == null) {
            try {
                retval = SPDXDocumentFactory.createSpdxDocument(spdxDocFileName);
                logger.info("Document identified as SPDX RDF/XML.");
            }
            catch (IOException e) {
                errorDetails2 = e.getMessage();
            }
            catch (InvalidSPDXAnalysisException e) {
                errorDetails2 = e.getMessage();
            }
            catch (Exception e) {
                errorDetails2 = e.getMessage();
            }
        }
        if (retval == null) {
            throw new SpdxCompareException("File " + spdxDocFileName + " is not a recognized RDF/XML or tag/value format. While verifying for Tag/Value format: " + errorDetails1 + ". While verifying for RDF/XML format: " + errorDetails2);
        }
        return retval;
    }

    protected static SpdxDocument convertTagValueToRdf(File tagValueFile, List<String> warnings) throws SpdxCompareException, Exception {
        FileInputStream in = null;
        try {
            SpdxDocument result;
            in = new FileInputStream(tagValueFile);
            SpdxDocument spdxDocument = result = TagToRDF.convertTagFileToRdf(in, "RDF/XML-ABBREV", warnings).getSpdxDocument();
            return spdxDocument;
        }
        catch (InvalidSpdxTagFileException e) {
            throw new SpdxCompareException(e.getMessage(), e);
        }
        catch (InvalidFileFormatException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception("Error converting tag/value to RDF/XML format: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.out.println("Error closing Tag/Value file: " + e.getMessage());
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: CompareSpdxDoc doc1 doc2 [output]");
        System.out.println("where doc1 and doc2 are file names of valid SPDX documents ");
        System.out.println("in either tag/value or RDF/XML format");
        System.out.println("and [output] is an optional output text file name");
    }
}

