/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.AnnotationsSheet;
import org.spdx.spdxspreadsheet.DocumentInfoSheet;
import org.spdx.spdxspreadsheet.ExternalRefsSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.RelationshipsSheet;
import org.spdx.spdxspreadsheet.ReviewersSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SnippetSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tools.OnlineToolException;

public class RdfToSpreadsheet {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 2;
    static Pattern datePattern = Pattern.compile(".. ... \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d GMT$");
    public static final String NOT_SUPPORTED_STRING = "This field is not yet supported by SPDX";

    public static void main(String[] args) {
        if (args.length < 2) {
            RdfToSpreadsheet.usage();
            return;
        }
        if (args.length > 2) {
            RdfToSpreadsheet.usage();
            return;
        }
        try {
            RdfToSpreadsheet.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            RdfToSpreadsheet.usage();
            return;
        }
    }

    public static List<String> onlineFunction(String[] args) throws OnlineToolException {
        List<Object> verify;
        block21: {
            File spdxRdfFile = new File(args[0]);
            if (!spdxRdfFile.exists()) {
                throw new OnlineToolException("Error: File " + args[0] + " does not exist.");
            }
            File spdxSpreadsheetFile = new File(args[1]);
            if (spdxSpreadsheetFile.exists()) {
                throw new OnlineToolException("Spreadsheet file already exists - please specify a new file.");
            }
            SpdxDocument doc = null;
            try {
                doc = SPDXDocumentFactory.createSpdxDocument(args[0]);
            }
            catch (InvalidSPDXAnalysisException ex) {
                throw new OnlineToolException("Error creating SPDX Document: " + ex.getMessage());
            }
            catch (IOException e) {
                throw new OnlineToolException("Error creating SPDX Document:" + args[0] + ", " + e.getMessage());
            }
            catch (Exception e) {
                throw new OnlineToolException("Error creating SPDX Document: " + e.getMessage(), e);
            }
            verify = new ArrayList();
            if (doc != null) {
                AbstractSpreadsheet ss = null;
                try {
                    try {
                        ss = new SPDXSpreadsheet(spdxSpreadsheetFile, true, false);
                        RdfToSpreadsheet.copyRdfXmlToSpreadsheet(doc, (SPDXSpreadsheet)ss);
                        verify = doc.verify();
                        if (verify != null && verify.size() > 0) {
                            System.out.println("Warning: The following verifications failed for the resultant SPDX RDF file:");
                            int i = 0;
                            while (i < verify.size()) {
                                System.out.println("\t" + (String)verify.get(i));
                                ++i;
                            }
                        }
                        break block21;
                    }
                    catch (SpreadsheetException e) {
                        throw new OnlineToolException("Error opening or writing to spreadsheet: " + e.getMessage());
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        throw new OnlineToolException("Error translating the RDF file: " + e.getMessage());
                    }
                    catch (Exception ex) {
                        throw new OnlineToolException("Unexpected error translating the RDF to spreadsheet: " + ex.getMessage());
                    }
                }
                finally {
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (SpreadsheetException e) {
                            throw new OnlineToolException("Error closing spreadsheet: " + e.getMessage());
                        }
                    }
                }
            }
            throw new OnlineToolException("Error creating SPDX document reference, null reference returned");
        }
        return verify;
    }

    public static void copyRdfXmlToSpreadsheet(SpdxDocument doc, SPDXSpreadsheet ss) throws InvalidSPDXAnalysisException, SpreadsheetException {
        if (doc == null) {
            System.out.println("Warning: No document to copy");
            return;
        }
        RdfToSpreadsheet.copyOrigins(doc, ss.getOriginsSheet());
        TreeMap<String, ExternalRef[]> externalRefs = new TreeMap<String, ExternalRef[]>();
        Map<String, String> fileIdToPackageId = RdfToSpreadsheet.copyPackageInfo(doc.getDocumentContainer().findAllPackages(), ss.getPackageInfoSheet(), externalRefs);
        RdfToSpreadsheet.copyExternalRefs(externalRefs, ss.getExternalRefsSheet(), doc.getDocumentContainer());
        RdfToSpreadsheet.copyNonStdLicenses(doc.getExtractedLicenseInfos(), ss.getNonStandardLicensesSheet());
        RdfToSpreadsheet.copyPerFileInfo(doc.getDocumentContainer().findAllFiles(), ss.getPerFileSheet(), fileIdToPackageId);
        RdfToSpreadsheet.copySnippetInfo(doc.getDocumentContainer().findAllSnippets(), ss.getSnippetSheet());
        TreeMap<String, Relationship[]> allRelationships = new TreeMap<String, Relationship[]>();
        TreeMap<String, Annotation[]> allAnnotations = new TreeMap<String, Annotation[]>();
        allRelationships.put(doc.getId(), doc.getRelationships());
        allAnnotations.put(doc.getId(), doc.getAnnotations());
        List<SpdxElement> allElements = doc.getDocumentContainer().findAllElements();
        for (SpdxElement element : allElements) {
            allRelationships.put(element.getId(), element.getRelationships());
            allAnnotations.put(element.getId(), element.getAnnotations());
        }
        RdfToSpreadsheet.copyRelationships(allRelationships, ss.getRelationshipsSheet());
        RdfToSpreadsheet.copyAnnotations(allAnnotations, ss.getAnnotationsSheet());
        RdfToSpreadsheet.copyReviewerInfo(doc.getReviewers(), ss.getReviewersSheet());
        ss.resizeRow();
    }

    private static void copyExternalRefs(Map<String, ExternalRef[]> externalRefsMap, ExternalRefsSheet externalRefSheet, SpdxDocumentContainer container) throws SpreadsheetException {
        Object[] keys = externalRefsMap.keySet().toArray(new String[externalRefsMap.keySet().size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object[] externalRefs = externalRefsMap.get(key);
            Arrays.sort(externalRefs);
            Object[] objectArray2 = externalRefs;
            int n3 = externalRefs.length;
            int n4 = 0;
            while (n4 < n3) {
                Object externalRef = objectArray2[n4];
                externalRefSheet.add((String)key, (ExternalRef)externalRef, container);
                ++n4;
            }
            ++n2;
        }
    }

    private static void copyAnnotations(Map<String, Annotation[]> annotationMap, AnnotationsSheet annotationsSheet) {
        for (Map.Entry<String, Annotation[]> entry : annotationMap.entrySet()) {
            Object[] annotations = entry.getValue();
            Arrays.sort(annotations);
            int i = 0;
            while (i < annotations.length) {
                annotationsSheet.add((Annotation)annotations[i], entry.getKey());
                ++i;
            }
        }
    }

    private static void copyRelationships(Map<String, Relationship[]> relationshipMap, RelationshipsSheet relationshipsSheet) {
        Object[] keys = relationshipMap.keySet().toArray(new String[relationshipMap.keySet().size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object[] relationships = relationshipMap.get(key);
            Arrays.sort(relationships);
            int i = 0;
            while (i < relationships.length) {
                relationshipsSheet.add((Relationship)relationships[i], (String)key);
                ++i;
            }
            ++n2;
        }
    }

    private static void copyReviewerInfo(SPDXReview[] reviewers, ReviewersSheet reviewersSheet) throws InvalidSPDXAnalysisException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Arrays.sort(reviewers);
        int i = 0;
        while (i < reviewers.length) {
            String reviewerName = reviewers[i].getReviewer();
            Date reviewDate = null;
            String dateString = reviewers[i].getReviewDate();
            if (dateString != null && !dateString.isEmpty()) {
                try {
                    dateString = dateString.trim();
                    reviewDate = dateFormat.parse(dateString);
                }
                catch (Exception ex) {
                    throw new InvalidSPDXAnalysisException("Invalid reviewer date format for reviewer " + reviewers[i]);
                }
            }
            reviewersSheet.addReviewer(reviewerName, reviewDate, reviewers[i].getComment());
            ++i;
        }
    }

    private static void copyPerFileInfo(List<SpdxFile> fileList, PerFileSheet perFileSheet, Map<String, String> fileIdToPackageId) {
        Collections.sort(fileList);
        for (SpdxFile file : fileList) {
            perFileSheet.add(file, fileIdToPackageId.get(file.getId()));
        }
    }

    private static void copySnippetInfo(List<SpdxSnippet> snippets, SnippetSheet snippetSheet) throws SpreadsheetException {
        Collections.sort(snippets);
        for (SpdxSnippet snippet : snippets) {
            snippetSheet.add(snippet);
        }
    }

    private static void copyNonStdLicenses(ExtractedLicenseInfo[] nonStandardLicenses, NonStandardLicensesSheet nonStandardLicensesSheet) {
        Arrays.sort(nonStandardLicenses, new Comparator<ExtractedLicenseInfo>(){

            @Override
            public int compare(ExtractedLicenseInfo o1, ExtractedLicenseInfo o2) {
                int result = 0;
                result = o1.getName() != null && !o1.getName().trim().isEmpty() ? (o2.getName() != null && !o2.getName().trim().isEmpty() ? o1.getName().compareToIgnoreCase(o2.getName()) : 1) : -1;
                if (result == 0) {
                    result = o1.getLicenseId().compareToIgnoreCase(o2.getLicenseId());
                }
                return result;
            }
        });
        int i = 0;
        while (i < nonStandardLicenses.length) {
            nonStandardLicensesSheet.add(nonStandardLicenses[i].getLicenseId(), nonStandardLicenses[i].getExtractedText(), nonStandardLicenses[i].getName(), nonStandardLicenses[i].getSeeAlso(), nonStandardLicenses[i].getComment());
            ++i;
        }
    }

    private static Map<String, String> copyPackageInfo(List<SpdxPackage> packages, PackageInfoSheet packageInfoSheet, Map<String, ExternalRef[]> externalRefs) throws InvalidSPDXAnalysisException {
        HashMap fileIdToPkgId = Maps.newHashMap();
        Collections.sort(packages);
        for (SpdxPackage pkg : packages) {
            String pkgId = pkg.getId();
            SpdxFile[] files = pkg.getFiles();
            int i = 0;
            while (i < files.length) {
                String fileId = files[i].getId();
                String pkgIdsForFile = (String)fileIdToPkgId.get(fileId);
                pkgIdsForFile = pkgIdsForFile == null ? pkgId : String.valueOf(pkgIdsForFile) + ", " + pkgId;
                fileIdToPkgId.put(fileId, pkgIdsForFile);
                ++i;
            }
            ExternalRef[] pkgExternalRefs = pkg.getExternalRefs();
            if (pkgExternalRefs != null && pkgExternalRefs.length > 0) {
                externalRefs.put(pkgId, pkgExternalRefs);
            }
            packageInfoSheet.add(pkg);
        }
        return fileIdToPkgId;
    }

    private static void copyOrigins(SpdxDocument doc, DocumentInfoSheet originsSheet) throws SpreadsheetException {
        originsSheet.addDocument(doc);
    }

    private static void usage() {
        System.out.println("Usage: RdfToSpreadsheet rdfxmlfile.rdf spreadsheetfile.xls\nwhere rdfxmlfile.rdf is a valid SPDX RDF XML file and spreadsheetfile.xls is\nthe output SPDX spreadsheeet file.");
    }
}

