/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.spdx.compare.SpdxCompareException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.tools.CompareSpdxDocs;
import org.spdx.tools.SpdxVerificationException;

public class Verify {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 1;
    static final int ERROR_STATUS = 1;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n Verify file\nwhere file is the file path to an SPDX RDF XML or an SPDX Tag/Value file");
            System.exit(1);
        }
        if (args.length > 1) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        List<String> verify = null;
        try {
            verify = Verify.verify(args[0]);
        }
        catch (SpdxVerificationException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (verify.size() > 0) {
            System.out.println("This SPDX Document is not valid due to:");
            int i = 0;
            while (i < verify.size()) {
                System.out.print("\t" + verify.get(i) + "\n");
                ++i;
            }
            System.exit(1);
        } else {
            System.out.println("This SPDX Document is valid.");
        }
    }

    public static List<String> verify(String filePath) throws SpdxVerificationException {
        SpdxDocument doc = null;
        ArrayList<String> parserWarnings = new ArrayList<String>();
        try {
            doc = CompareSpdxDocs.openRdfOrTagDoc(filePath, parserWarnings);
        }
        catch (SpdxCompareException e) {
            throw new SpdxVerificationException("Unable to parse the file: " + e.getMessage(), e);
        }
        List<String> verify = doc.verify();
        ArrayList<String> retval = new ArrayList<String>();
        if (!verify.isEmpty()) {
            retval.addAll(parserWarnings);
            for (String verifyMsg : verify) {
                boolean found = false;
                for (String parserWarning : parserWarnings) {
                    if (!parserWarning.contains(verifyMsg)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                retval.add(verifyMsg);
            }
        }
        return retval;
    }

    public static List<String> verifyTagFile(String filePath) throws SpdxVerificationException {
        SpdxDocument doc = null;
        ArrayList<String> parserWarnings = new ArrayList<String>();
        File spdxDocFile = new File(filePath);
        if (!spdxDocFile.exists()) {
            throw new SpdxVerificationException("SPDX File " + filePath + " does not exist.");
        }
        if (!spdxDocFile.canRead()) {
            throw new SpdxVerificationException("SPDX File " + filePath + " can not be read.");
        }
        try {
            doc = CompareSpdxDocs.convertTagValueToRdf(spdxDocFile, parserWarnings);
        }
        catch (SpdxCompareException e) {
            throw new SpdxVerificationException("Unable to parse the file: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SpdxVerificationException("Not a valid SPDX Tag Value File Format.");
        }
        List<String> verify = doc.verify();
        ArrayList<String> retval = new ArrayList<String>();
        if (!verify.isEmpty()) {
            retval.addAll(parserWarnings);
            for (String verifyMsg : verify) {
                boolean found = false;
                for (String parserWarning : parserWarnings) {
                    if (!parserWarning.contains(verifyMsg)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                retval.add(verifyMsg);
            }
        }
        return retval;
    }

    public static List<String> verifyRDFFile(String filePath) throws SpdxVerificationException {
        SpdxDocument doc = null;
        File spdxDocFile = new File(filePath);
        if (!spdxDocFile.exists()) {
            throw new SpdxVerificationException("SPDX File " + filePath + " does not exist.");
        }
        if (!spdxDocFile.canRead()) {
            throw new SpdxVerificationException("SPDX File " + filePath + " can not be read.");
        }
        try {
            doc = SPDXDocumentFactory.createSpdxDocument(filePath);
        }
        catch (IOException e) {
            throw new SpdxVerificationException("Unable to parse the file: " + e.getMessage(), e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxVerificationException("Unable to parse the file: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SpdxVerificationException("Unable to parse the file: " + e.getMessage(), e);
        }
        List<String> retval = doc.verify();
        return retval;
    }
}

