/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.erhlc;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.data.elasticsearch.client.NoReachableHostException;
import org.springframework.data.elasticsearch.client.erhlc.HostProvider;
import org.springframework.data.elasticsearch.client.erhlc.WebClientProvider;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

@Deprecated
class MultiNodeHostProvider
implements HostProvider<MultiNodeHostProvider> {
    private static final Log LOGGER = LogFactory.getLog(MultiNodeHostProvider.class);
    private final WebClientProvider clientProvider;
    private final Map<InetSocketAddress, ElasticsearchHost> hosts;

    MultiNodeHostProvider(WebClientProvider clientProvider, InetSocketAddress ... endpoints) {
        this.clientProvider = clientProvider;
        this.hosts = new ConcurrentHashMap<InetSocketAddress, ElasticsearchHost>();
        for (InetSocketAddress endpoint : endpoints) {
            this.hosts.put(endpoint, new ElasticsearchHost(endpoint, ElasticsearchHost.State.UNKNOWN));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("initialized with " + this.hosts));
        }
    }

    @Override
    public Mono<HostProvider.ClusterInformation> clusterInfo() {
        return this.checkNodes(null).map(this::updateNodeState).buffer(this.hosts.size()).then(Mono.just((Object)new HostProvider.ClusterInformation(new LinkedHashSet<ElasticsearchHost>(this.hosts.values()))));
    }

    @Override
    public WebClient createWebClient(InetSocketAddress endpoint) {
        return this.clientProvider.get(endpoint);
    }

    @Override
    public Mono<InetSocketAddress> lookupActiveHost(HostProvider.Verification verification) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("lookupActiveHost " + verification + " from " + this.hosts()));
        }
        if (HostProvider.Verification.LAZY.equals((Object)verification)) {
            for (ElasticsearchHost entry : this.hosts()) {
                if (!entry.isOnline()) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("lookupActiveHost returning " + entry));
                }
                return Mono.just((Object)entry.getEndpoint());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)"no online host found with LAZY");
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"searching for active host");
        }
        return this.findActiveHostInKnownActives().switchIfEmpty(this.findActiveHostInUnresolved()).switchIfEmpty(this.findActiveHostInDead()).switchIfEmpty(Mono.error(() -> new NoReachableHostException(new LinkedHashSet<ElasticsearchHost>(this.getCachedHostState()))));
    }

    Collection<ElasticsearchHost> getCachedHostState() {
        return this.hosts.values();
    }

    private Mono<InetSocketAddress> findActiveHostInKnownActives() {
        return this.findActiveForState(ElasticsearchHost.State.ONLINE);
    }

    private Mono<InetSocketAddress> findActiveHostInUnresolved() {
        return this.findActiveForState(ElasticsearchHost.State.UNKNOWN);
    }

    private Mono<InetSocketAddress> findActiveHostInDead() {
        return this.findActiveForState(ElasticsearchHost.State.OFFLINE);
    }

    private Mono<InetSocketAddress> findActiveForState(ElasticsearchHost.State state) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("findActiveForState state " + state + ", current hosts: " + this.hosts));
        }
        return this.checkNodes(state).map(this::updateNodeState).filter(ElasticsearchHost::isOnline).map(elasticsearchHost -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("findActiveForState returning host " + elasticsearchHost));
            }
            return elasticsearchHost;
        }).map(ElasticsearchHost::getEndpoint).takeLast(1).next();
    }

    private ElasticsearchHost updateNodeState(Tuple2<InetSocketAddress, ElasticsearchHost.State> tuple2) {
        ElasticsearchHost.State state = (ElasticsearchHost.State)((Object)tuple2.getT2());
        ElasticsearchHost elasticsearchHost = new ElasticsearchHost((InetSocketAddress)tuple2.getT1(), state);
        this.hosts.put((InetSocketAddress)tuple2.getT1(), elasticsearchHost);
        return elasticsearchHost;
    }

    private Flux<Tuple2<InetSocketAddress, ElasticsearchHost.State>> checkNodes(@Nullable ElasticsearchHost.State state) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("checkNodes() with state " + state));
        }
        return Flux.fromIterable(this.hosts()).filter(entry -> state == null || entry.getState().equals((Object)state)).map(ElasticsearchHost::getEndpoint).concatMap(host -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("checking host " + host));
            }
            Mono clientResponseMono = this.createWebClient((InetSocketAddress)host).head().uri("/", new Object[0]).exchangeToMono(Mono::just).timeout(Duration.ofSeconds(1L)).doOnError(throwable -> {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("error checking host " + host + ", " + throwable.getMessage()));
                }
                this.hosts.put((InetSocketAddress)host, new ElasticsearchHost((InetSocketAddress)host, ElasticsearchHost.State.OFFLINE));
                this.clientProvider.getErrorListener().accept((Throwable)throwable);
            });
            return Mono.just((Object)host).zipWith(clientResponseMono.flatMap(it -> it.releaseBody().thenReturn((Object)(it.statusCode().isError() ? ElasticsearchHost.State.OFFLINE : ElasticsearchHost.State.ONLINE))));
        }).map(tuple -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("check result " + tuple));
            }
            return tuple;
        }).onErrorContinue((throwable, o) -> this.clientProvider.getErrorListener().accept((Throwable)throwable));
    }

    private List<ElasticsearchHost> hosts() {
        ArrayList<ElasticsearchHost> hosts = new ArrayList<ElasticsearchHost>(this.hosts.values());
        Collections.shuffle(hosts);
        return hosts;
    }
}

