/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.elasticsearch.core.convert.AbstractPropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public abstract class AbstractRangePropertyValueConverter<T>
extends AbstractPropertyValueConverter {
    protected static final String LT_FIELD = "lt";
    protected static final String LTE_FIELD = "lte";
    protected static final String GT_FIELD = "gt";
    protected static final String GTE_FIELD = "gte";

    public AbstractRangePropertyValueConverter(PersistentProperty<?> property) {
        super(property);
    }

    @Override
    public Object read(Object value) {
        Assert.notNull((Object)value, (String)"value must not be null.");
        Assert.isInstanceOf(Map.class, (Object)value, (String)"value must be instance of Map.");
        try {
            Map source = (Map)value;
            Range.Bound lowerBound = source.containsKey(GTE_FIELD) ? Range.Bound.inclusive(this.parse((String)source.get(GTE_FIELD))) : (source.containsKey(GT_FIELD) ? Range.Bound.exclusive(this.parse((String)source.get(GT_FIELD))) : Range.Bound.unbounded());
            Range.Bound upperBound = source.containsKey(LTE_FIELD) ? Range.Bound.inclusive(this.parse((String)source.get(LTE_FIELD))) : (source.containsKey(LT_FIELD) ? Range.Bound.exclusive(this.parse((String)source.get(LT_FIELD))) : Range.Bound.unbounded());
            return Range.of((Range.Bound)lowerBound, (Range.Bound)upperBound);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Unable to convert value '%s' of property '%s'", value, this.getProperty().getName()), e);
        }
    }

    @Override
    public Object write(Object value) {
        Assert.notNull((Object)value, (String)"value must not be null.");
        if (!Range.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        try {
            Range range = (Range)value;
            Range.Bound lowerBound = range.getLowerBound();
            Range.Bound upperBound = range.getUpperBound();
            LinkedHashMap<String, String> target = new LinkedHashMap<String, String>();
            if (lowerBound.getValue().isPresent()) {
                String lowerBoundValue = this.format(lowerBound.getValue().get());
                if (lowerBound.isInclusive()) {
                    target.put(GTE_FIELD, lowerBoundValue);
                } else {
                    target.put(GT_FIELD, lowerBoundValue);
                }
            }
            if (upperBound.getValue().isPresent()) {
                String upperBoundValue = this.format(upperBound.getValue().get());
                if (upperBound.isInclusive()) {
                    target.put(LTE_FIELD, upperBoundValue);
                } else {
                    target.put(LT_FIELD, upperBoundValue);
                }
            }
            return target;
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Unable to convert value '%s' of property '%s'", value, this.getProperty().getName()), e);
        }
    }

    protected abstract String format(T var1);

    protected Class<?> getGenericType() {
        return ((TypeInformation)this.getProperty().getTypeInformation().getTypeArguments().get(0)).getType();
    }

    protected abstract T parse(String var1);
}

