/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Incubating;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public interface UserType<J> {
    public int getSqlType();

    public Class<J> returnedClass();

    public boolean equals(J var1, J var2);

    public int hashCode(J var1);

    public J nullSafeGet(ResultSet var1, int var2, SharedSessionContractImplementor var3, Object var4) throws SQLException;

    public void nullSafeSet(PreparedStatement var1, J var2, int var3, SharedSessionContractImplementor var4) throws SQLException;

    public J deepCopy(J var1);

    public boolean isMutable();

    public Serializable disassemble(J var1);

    public J assemble(Serializable var1, Object var2);

    default public J replace(J detached, J managed, Object owner) {
        return this.deepCopy(detached);
    }

    default public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 255L;
    }

    default public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 19;
    }

    default public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 2;
    }

    @Incubating
    default public JdbcType getJdbcType(TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.getSqlType());
    }

    @Incubating
    default public BasicValueConverter<J, Object> getValueConverter() {
        return null;
    }
}

