/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.CalendarEvent;
import co.elastic.clients.elasticsearch.ml.PostCalendarEventsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PostCalendarEventsRequest
extends RequestBase
implements JsonpSerializable {
    private final String calendarId;
    private final List<CalendarEvent> events;
    public static final JsonpDeserializer<PostCalendarEventsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostCalendarEventsRequest::setupPostCalendarEventsRequestDeserializer);
    public static final Endpoint<PostCalendarEventsRequest, PostCalendarEventsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PostCalendarEventsRequest, PostCalendarEventsResponse>("es/ml.post_calendar_events", request -> "POST", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/events");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PostCalendarEventsResponse._DESERIALIZER);

    private PostCalendarEventsRequest(Builder builder) {
        this.calendarId = ApiTypeHelper.requireNonNull(builder.calendarId, this, "calendarId");
        this.events = ApiTypeHelper.unmodifiableRequired(builder.events, (Object)this, "events");
    }

    public static PostCalendarEventsRequest of(Function<Builder, ObjectBuilder<PostCalendarEventsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String calendarId() {
        return this.calendarId;
    }

    public final List<CalendarEvent> events() {
        return this.events;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.events)) {
            generator.writeKey("events");
            generator.writeStartArray();
            for (CalendarEvent item0 : this.events) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPostCalendarEventsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(CalendarEvent._DESERIALIZER), "events");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostCalendarEventsRequest> {
        private String calendarId;
        private List<CalendarEvent> events;

        public final Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder events(List<CalendarEvent> list) {
            this.events = Builder._listAddAll(this.events, list);
            return this;
        }

        public final Builder events(CalendarEvent value, CalendarEvent ... values) {
            this.events = Builder._listAdd(this.events, value, values);
            return this;
        }

        public final Builder events(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.events(fn.apply(new CalendarEvent.Builder()).build(), new CalendarEvent[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostCalendarEventsRequest build() {
            this._checkSingleUse();
            return new PostCalendarEventsRequest(this);
        }
    }
}

