/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.StartTransformResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StartTransformRequest
extends RequestBase {
    @Nullable
    private final String from;
    @Nullable
    private final Time timeout;
    private final String transformId;
    public static final Endpoint<StartTransformRequest, StartTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StartTransformRequest, StartTransformResponse>("es/transform.start_transform", request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", request.from);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StartTransformResponse._DESERIALIZER);

    private StartTransformRequest(Builder builder) {
        this.from = builder.from;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.requireNonNull(builder.transformId, this, "transformId");
    }

    public static StartTransformRequest of(Function<Builder, ObjectBuilder<StartTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String from() {
        return this.from;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String transformId() {
        return this.transformId;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StartTransformRequest> {
        @Nullable
        private String from;
        @Nullable
        private Time timeout;
        private String transformId;

        public final Builder from(@Nullable String value) {
            this.from = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StartTransformRequest build() {
            this._checkSingleUse();
            return new StartTransformRequest(this);
        }
    }
}

