/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.server.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.jobrunr.dashboard.server.AbstractHttpExchangeHandler;
import org.jobrunr.dashboard.server.http.ContentType;
import org.jobrunr.utils.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHttpHandler
extends AbstractHttpExchangeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticFileHttpHandler.class);
    private final String contextPath;
    private final String rootDir;
    private final boolean singlePageApp;

    public StaticFileHttpHandler(String contextPath, String rootDir) {
        this(contextPath, rootDir, false);
    }

    public StaticFileHttpHandler(String contextPath, String rootDir, boolean singlePageApp) {
        this.contextPath = contextPath;
        this.rootDir = rootDir;
        this.singlePageApp = singlePageApp;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        try {
            String requestUri = httpExchange.getRequestURI().toString();
            requestUri = this.sanitizeRequestUri(requestUri);
            String toServe = requestUri.substring((this.contextPath + "/").length());
            URL resource = this.getClass().getClassLoader().getResource(this.rootDir + toServe);
            if (resource != null) {
                httpExchange.getResponseHeaders().add("content-type", ContentType.from(toServe));
                httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
                httpExchange.sendResponseHeaders(200, 0L);
                this.copyResourceToResponseBody(resource, httpExchange);
            } else {
                httpExchange.sendResponseHeaders(404, -1L);
            }
        }
        catch (Exception shouldNotHappen) {
            LOGGER.error("Error serving static files", (Throwable)shouldNotHappen);
        }
    }

    private String sanitizeRequestUri(String requestUri) {
        if (requestUri.contains(".")) {
            return requestUri;
        }
        if (this.singlePageApp) {
            return this.contextPath + "/index.html";
        }
        if (requestUri.equals(this.contextPath)) {
            requestUri = requestUri + "/index.html";
        } else if (requestUri.equals(this.contextPath + "/")) {
            requestUri = requestUri + "index.html";
        }
        return requestUri;
    }

    void copyResourceToResponseBody(URL resource, HttpExchange httpExchange) throws IOException {
        try (InputStream inputStream = resource.openStream();
             OutputStream outputStream = httpExchange.getResponseBody();){
            IOUtils.copyStream(inputStream, outputStream);
        }
    }
}

