/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.server.http.url;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.Autoboxer;

public class RequestUrl {
    private final String url;
    private final Map<String, String> params;
    private final Map<String, List<String>> queryParams;

    public RequestUrl(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
        this.queryParams = this.initQueryParams(url);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String param(String paramName) {
        return this.params.get(paramName);
    }

    public <T> T param(String paramName, Class<T> clazz) {
        if (String.class.equals(clazz)) {
            return clazz.cast(this.param(paramName));
        }
        if (UUID.class.equals(clazz)) {
            return clazz.cast(UUID.fromString(this.param(paramName)));
        }
        if (clazz.isEnum()) {
            return (T)Stream.of(clazz.getEnumConstants()).filter(val -> ((Enum)val).name().equalsIgnoreCase(this.param(paramName))).findFirst().orElseThrow(() -> new IllegalArgumentException("No enum constant " + clazz.getCanonicalName() + "." + this.param(paramName)));
        }
        throw new IllegalArgumentException(paramName);
    }

    public String queryParam(String queryParamName) {
        return this.optionalQueryParam(queryParamName).orElse(null);
    }

    public <T> T queryParam(String queryParamName, Class<T> clazz, T defaultValue) {
        Optional<String> queryParam = this.optionalQueryParam(queryParamName);
        if (queryParam.isPresent()) {
            return Autoboxer.autobox(queryParam.get(), clazz);
        }
        return defaultValue;
    }

    public <T> T fromQueryParams(Class<T> clazz) {
        Map<String, String> fieldValues = this.queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
        return ReflectionUtils.newInstanceAndSetFieldValues(clazz, fieldValues);
    }

    private Map<String, List<String>> initQueryParams(String url) {
        if (!url.contains("?")) {
            return Collections.emptyMap();
        }
        return Arrays.stream(url.substring(url.indexOf(63) + 1).split("&")).map(this::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf(61);
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    private Optional<String> optionalQueryParam(String queryParamName) {
        if (!this.queryParams.containsKey(queryParamName)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.queryParams.get(queryParamName).get(0));
    }
}

