/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.states.EnqueuedState;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.ScheduleExpressionType;
import org.jobrunr.utils.StringUtils;

public class RecurringJob
extends AbstractJob {
    private String id;
    private String scheduleExpression;
    private String zoneId;
    private Instant createdAt;

    private RecurringJob() {
    }

    public RecurringJob(String id, JobDetails jobDetails, String scheduleExpression, String zoneId) {
        this(id, jobDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId));
    }

    public RecurringJob(String id, JobDetails jobDetails, Schedule schedule, ZoneId zoneId) {
        this(id, jobDetails, schedule, zoneId, Instant.now(Clock.system(zoneId)));
    }

    public RecurringJob(String id, JobDetails jobDetails, String scheduleExpression, String zoneId, String createdAt) {
        this(id, jobDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId), Instant.parse(createdAt));
    }

    public RecurringJob(String id, JobDetails jobDetails, Schedule schedule, ZoneId zoneId, Instant createdAt) {
        super(jobDetails);
        schedule.validateSchedule();
        this.id = this.validateAndSetId(id);
        this.zoneId = zoneId.getId();
        this.scheduleExpression = schedule.toString();
        this.createdAt = createdAt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Job toScheduledJob() {
        return this.toJob(new ScheduledState(this.getNextRun(), this));
    }

    public List<Job> toScheduledJobs(Instant from, Instant upTo) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Instant nextRun = this.getNextRun(from);
        while (nextRun.isBefore(upTo)) {
            jobs.add(this.toJob(new ScheduledState(nextRun, this)));
            nextRun = this.getNextRun(nextRun);
        }
        return jobs;
    }

    public Job toEnqueuedJob() {
        return this.toJob(new EnqueuedState());
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getNextRun() {
        return this.getNextRun(Instant.now());
    }

    public Instant getNextRun(Instant sinceInstant) {
        return ScheduleExpressionType.getSchedule(this.scheduleExpression).next(this.createdAt, sinceInstant, ZoneId.of(this.zoneId));
    }

    private String validateAndSetId(String input) {
        String result = Optional.ofNullable(input).orElse(this.getJobSignature().replace(" ", "").replace("$", "_"));
        if (result.length() >= 128 && input == null) {
            result = StringUtils.md5Checksum(result);
        } else {
            if (result.length() >= 128) {
                throw new IllegalArgumentException("The id of a recurring job must be smaller than 128 characters.");
            }
            if (!result.matches("[\\dA-Za-z-_(),.]+")) {
                throw new IllegalArgumentException("The id of a recurring job can only contain letters and numbers.");
            }
        }
        return result;
    }

    private Job toJob(JobState jobState) {
        Job job = new Job(this.getJobDetails(), jobState);
        job.setJobName(this.getJobName());
        job.setRecurringJobId(this.getId());
        job.setAmountOfRetries(this.getAmountOfRetries());
        job.setLabels(this.getLabels());
        return job;
    }

    public String toString() {
        return "RecurringJob{id=" + this.id + ", version='" + this.getVersion() + '\'' + ", identity='" + System.identityHashCode(this) + '\'' + ", jobSignature='" + this.getJobSignature() + '\'' + ", jobName='" + this.getJobName() + '\'' + '}';
    }
}

