/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details.instructions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.details.JobDetailsBuilder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.details.instructions.AbstractJVMInstruction;
import org.jobrunr.jobs.details.instructions.VisitMethodInstruction;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeStaticInstruction
extends VisitMethodInstruction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokeStaticInstruction.class);

    public InvokeStaticInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if (this.isLastInstruction()) {
            this.jobDetailsBuilder.setClassName(this.getClassName());
            this.jobDetailsBuilder.setMethodName(this.getMethodName());
            this.jobDetailsBuilder.setJobParameters(this.getJobParameters());
            return null;
        }
        long before = System.nanoTime();
        Object result = this.getObject();
        long after = System.nanoTime();
        if (after - before > 3000000L) {
            LOGGER.warn("You are using a custom method ({}.{}({})) while enqueueing that takes a lot of time. See https://www.jobrunr.io/en/documentation/background-methods/best-practices/ on how to use JobRunr effectively.", new Object[]{this.getClassName(), this.getMethodName(), Stream.of(JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor)).map(Class::getSimpleName).collect(Collectors.joining(", "))});
        }
        return this.isVoidInstruction() ? AbstractJVMInstruction.DO_NOT_PUT_ON_STACK : result;
    }

    private Object getObject() {
        Class<?>[] paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor);
        List<Object> parameters = this.getParametersUsingParamTypes(paramTypes);
        if (this.isKotlinNullCheck()) {
            return null;
        }
        Object result = JobDetailsGeneratorUtils.createObjectViaStaticMethod(this.getClassName(), this.getMethodName(), paramTypes, parameters.toArray());
        return result;
    }

    private boolean isKotlinNullCheck() {
        return this.getClassName().startsWith("kotlin.") && this.getMethodName().equals("checkNotNullParameter");
    }

    private String getMethodName() {
        return this.name;
    }

    private String getClassName() {
        return JobDetailsGeneratorUtils.toFQClassName(this.owner);
    }

    private List<JobParameter> getJobParameters() {
        List<Class<?>> paramTypesFromDescriptor = JobDetailsGeneratorUtils.findParamTypesFromDescriptor(this.descriptor);
        LinkedList paramTypes = new LinkedList(paramTypesFromDescriptor);
        ArrayList<JobParameter> result = new ArrayList<JobParameter>();
        while (!paramTypes.isEmpty()) {
            result.add(0, this.toJobParameter(paramTypes.pollLast(), this.jobDetailsBuilder.getStack().pollLast()));
        }
        return result;
    }

    private JobParameter toJobParameter(Class<?> paramType, Object param) {
        if (ReflectionUtils.isClassAssignableToObject(paramType, param)) {
            if (Boolean.TYPE.equals(paramType) && Integer.class.equals(param.getClass())) {
                return new JobParameter(paramType, (Object)((Integer)param > 0 ? 1 : 0));
            }
            return new JobParameter(paramType, param);
        }
        throw JobRunrException.shouldNotHappenException(new IllegalStateException("The found parameter types do not match the parameters."));
    }
}

