/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.filters;

import java.util.List;
import java.util.stream.Stream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.filters.AbstractJobFilters;
import org.jobrunr.jobs.filters.ApplyStateFilter;
import org.jobrunr.jobs.filters.ElectStateFilter;
import org.jobrunr.jobs.filters.JobDefaultFilters;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.filters.JobServerFilter;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobPerformingFilters
extends AbstractJobFilters {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobPerformingFilters.class);
    private final Job job;

    public JobPerformingFilters(Job job, JobDefaultFilters jobFilters) {
        super(job, jobFilters);
        this.job = job;
    }

    public void runOnStateElectionFilter() {
        this.electStateFilters().forEach(this.catchThrowable(electStateFilter -> electStateFilter.onStateElection(this.job, (JobState)this.job.getJobState())));
    }

    public void runOnStateAppliedFilters() {
        this.applyStateFilters().forEach(this.catchThrowable(applyStateFilter -> applyStateFilter.onStateApplied(this.job, this.job.getJobState(-2), this.job.getJobState(-1))));
    }

    public void runOnJobProcessingFilters() {
        this.jobServerFilters().forEach(this.catchThrowable(jobServerFilter -> jobServerFilter.onProcessing(this.job)));
    }

    public void runOnJobProcessingSucceededFilters() {
        this.jobServerFilters().forEach(this.catchThrowable(jobServerFilter -> jobServerFilter.onProcessed(this.job)));
        this.jobServerFilters().forEach(this.catchThrowable(jobServerFilter -> jobServerFilter.onProcessingSucceeded(this.job)));
    }

    public void runOnJobProcessingFailedFilters(Exception e) {
        this.jobServerFilters().forEach(this.catchThrowable(jobServerFilter -> jobServerFilter.onProcessingFailed(this.job, e)));
    }

    public void runOnJobFailedAfterRetriesFilters() {
        this.jobServerFilters().forEach(this.catchThrowable(jobServerFilter -> jobServerFilter.onFailedAfterRetries(this.job)));
    }

    private Stream<ElectStateFilter> electStateFilters() {
        return JobPerformingFilters.electStateFilters(this.jobFilters);
    }

    private Stream<ApplyStateFilter> applyStateFilters() {
        return JobPerformingFilters.applyStateFilters(this.jobFilters);
    }

    private Stream<JobServerFilter> jobServerFilters() {
        return JobPerformingFilters.jobServerFilters(this.jobFilters);
    }

    private static Stream<ElectStateFilter> electStateFilters(List<JobFilter> jobFilters) {
        return StreamUtils.ofType(jobFilters, ElectStateFilter.class);
    }

    private static Stream<ApplyStateFilter> applyStateFilters(List<JobFilter> jobFilters) {
        return StreamUtils.ofType(jobFilters, ApplyStateFilter.class);
    }

    private static Stream<JobServerFilter> jobServerFilters(List<JobFilter> jobFilters) {
        return StreamUtils.ofType(jobFilters, JobServerFilter.class);
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }
}

