/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.UUID;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.ConcurrentJobModificationPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultConcurrentJobModificationPolicy;
import org.jobrunr.server.configuration.FixedSizeBackgroundJobServerWorkerPolicy;
import org.jobrunr.utils.StringUtils;

public class BackgroundJobServerConfiguration {
    public static final int DEFAULT_POLL_INTERVAL_IN_SECONDS = 15;
    public static final int DEFAULT_PAGE_REQUEST_SIZE = 1000;
    public static final Duration DEFAULT_DELETE_SUCCEEDED_JOBS_DURATION = Duration.ofHours(36L);
    public static final Duration DEFAULT_PERMANENTLY_DELETE_JOBS_DURATION = Duration.ofHours(72L);
    private int scheduledJobsRequestSize = 1000;
    private int orphanedJobsRequestSize = 1000;
    private int succeededJobsRequestSize = 1000;
    private int pollIntervalInSeconds = 15;
    private UUID id = UUID.randomUUID();
    private String name = BackgroundJobServerConfiguration.getHostName();
    private Duration deleteSucceededJobsAfter = DEFAULT_DELETE_SUCCEEDED_JOBS_DURATION;
    private Duration permanentlyDeleteDeletedJobsAfter = DEFAULT_PERMANENTLY_DELETE_JOBS_DURATION;
    private BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy = new DefaultBackgroundJobServerWorkerPolicy();
    private ConcurrentJobModificationPolicy concurrentJobModificationPolicy = new DefaultConcurrentJobModificationPolicy();

    private BackgroundJobServerConfiguration() {
    }

    public static BackgroundJobServerConfiguration usingStandardBackgroundJobServerConfiguration() {
        return new BackgroundJobServerConfiguration();
    }

    public BackgroundJobServerConfiguration andId(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("The id can not be null");
        }
        this.id = id;
        return this;
    }

    public BackgroundJobServerConfiguration andName(String name) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The name can not be null or empty");
        }
        if (name.length() >= 128) {
            throw new IllegalArgumentException("The length of the name can not exceed 128 characters");
        }
        this.name = name;
        return this;
    }

    public BackgroundJobServerConfiguration andPollIntervalInSeconds(int pollIntervalInSeconds) {
        if (pollIntervalInSeconds < 5) {
            throw new IllegalArgumentException("The pollIntervalInSeconds can not be smaller than 5 - otherwise it will cause to much load on your SQL/noSQL datastore.");
        }
        this.pollIntervalInSeconds = pollIntervalInSeconds;
        return this;
    }

    public BackgroundJobServerConfiguration andWorkerCount(int workerCount) {
        this.backgroundJobServerWorkerPolicy = new FixedSizeBackgroundJobServerWorkerPolicy(workerCount);
        return this;
    }

    public BackgroundJobServerConfiguration andBackgroundJobServerWorkerPolicy(BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        this.backgroundJobServerWorkerPolicy = backgroundJobServerWorkerPolicy;
        return this;
    }

    public BackgroundJobServerConfiguration andScheduledJobsRequestSize(int scheduledJobsRequestSize) {
        this.scheduledJobsRequestSize = scheduledJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andOrphanedJobsRequestSize(int orphanedJobsRequestSize) {
        this.orphanedJobsRequestSize = orphanedJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andSucceededJobsRequestSize(int succeededJobsRequestSize) {
        this.succeededJobsRequestSize = succeededJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andDeleteSucceededJobsAfter(Duration duration) {
        this.deleteSucceededJobsAfter = duration;
        return this;
    }

    public BackgroundJobServerConfiguration andPermanentlyDeleteDeletedJobsAfter(Duration duration) {
        this.permanentlyDeleteDeletedJobsAfter = duration;
        return this;
    }

    public BackgroundJobServerConfiguration andConcurrentJobModificationPolicy(ConcurrentJobModificationPolicy concurrentJobModificationPolicy) {
        this.concurrentJobModificationPolicy = concurrentJobModificationPolicy;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getScheduledJobsRequestSize() {
        return this.scheduledJobsRequestSize;
    }

    public int getOrphanedJobsRequestSize() {
        return this.orphanedJobsRequestSize;
    }

    public int getSucceededJobsRequestSize() {
        return this.succeededJobsRequestSize;
    }

    public int getPollIntervalInSeconds() {
        return this.pollIntervalInSeconds;
    }

    public Duration getDeleteSucceededJobsAfter() {
        return this.deleteSucceededJobsAfter;
    }

    public Duration getPermanentlyDeleteDeletedJobsAfter() {
        return this.permanentlyDeleteDeletedJobsAfter;
    }

    public BackgroundJobServerWorkerPolicy getBackgroundJobServerWorkerPolicy() {
        return this.backgroundJobServerWorkerPolicy;
    }

    public ConcurrentJobModificationPolicy getConcurrentJobModificationPolicy() {
        return this.concurrentJobModificationPolicy;
    }

    private static String getHostName() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return hostName.substring(0, Math.min(hostName.length(), 127));
        }
        catch (UnknownHostException e) {
            return "Unable to determine hostname";
        }
    }
}

