/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent;

import java.util.List;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.IllegalJobStateChangeException;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolver;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.utils.annotations.Beta;

@Beta
public class UseStorageProviderJobConcurrentJobModificationResolver
implements ConcurrentJobModificationResolver {
    private final JobZooKeeper jobZooKeeper;

    public UseStorageProviderJobConcurrentJobModificationResolver(JobZooKeeper jobZooKeeper) {
        this.jobZooKeeper = jobZooKeeper;
    }

    @Override
    public void resolve(ConcurrentJobModificationException e) {
        List<Job> concurrentUpdatedJobs = e.getConcurrentUpdatedJobs();
        concurrentUpdatedJobs.forEach(job -> this.resolve((Job)job, e));
    }

    public ConcurrentJobModificationResolveResult resolve(Job localJob, ConcurrentJobModificationException e) {
        this.failLocalIfPossible(localJob, e);
        Thread threadProcessingJob = this.jobZooKeeper.getThreadProcessingJob(localJob);
        if (threadProcessingJob != null) {
            threadProcessingJob.interrupt();
        }
        return ConcurrentJobModificationResolveResult.succeeded(localJob);
    }

    private void failLocalIfPossible(Job localJob, ConcurrentJobModificationException e) {
        try {
            localJob.failed("Job is already updated in StorageProvider, discarding local job.", e);
        }
        catch (IllegalJobStateChangeException illegalJobStateChangeException) {
            // empty catch block
        }
    }
}

