/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.runner;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.server.runner.AbstractBackgroundJobRunner;

public class BackgroundStaticFieldJobWithoutIocRunner
extends AbstractBackgroundJobRunner {
    @Override
    public boolean supports(Job job) {
        JobDetails jobDetails = job.getJobDetails();
        return jobDetails.hasStaticFieldName();
    }

    @Override
    protected AbstractBackgroundJobRunner.BackgroundJobWorker getBackgroundJobWorker(Job job) {
        return new StaticFieldBackgroundJobWorker(job);
    }

    protected static class StaticFieldBackgroundJobWorker
    extends AbstractBackgroundJobRunner.BackgroundJobWorker {
        public StaticFieldBackgroundJobWorker(Job job) {
            super(job);
        }

        @Override
        public void run() throws Exception {
            Class<?> jobContainingStaticFieldClass = this.getJobToPerformClass();
            Field jobField = this.getStaticFieldOfJobToPerformClass(jobContainingStaticFieldClass);
            Class<?> jobToPerformClass = jobField.getType();
            Method methodToPerform = this.getJobMethodToPerform(jobToPerformClass);
            this.invokeJobMethod(jobField.get(null), methodToPerform);
        }

        private Field getStaticFieldOfJobToPerformClass(Class<?> jobContainingStaticFieldClass) throws NoSuchFieldException {
            String staticFieldName = this.jobDetails.getStaticFieldName();
            return jobContainingStaticFieldClass.getDeclaredField(staticFieldName);
        }
    }
}

