/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper;

import java.time.Duration;
import java.time.Instant;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.zookeeper.ZooKeeperStatistics;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTaskInfo;

public class ZooKeeperRunTaskInfo
implements ZooKeeperTaskInfo,
AutoCloseable {
    private final ZooKeeperStatistics zooKeeperStatistics;
    private final BackgroundJobServerConfiguration backgroundJobServerConfiguration;
    private final long runIndex;
    private final Instant runStartTime;
    private boolean runSucceeded;

    public ZooKeeperRunTaskInfo(ZooKeeperStatistics zooKeeperStatistics, BackgroundJobServerConfiguration backgroundJobServerConfiguration, long runIndex) {
        this.zooKeeperStatistics = zooKeeperStatistics;
        this.backgroundJobServerConfiguration = backgroundJobServerConfiguration;
        this.runIndex = runIndex;
        this.runStartTime = Instant.now();
        this.runSucceeded = false;
    }

    @Override
    public boolean pollIntervalInSecondsTimeBoxIsAboutToPass() {
        Duration durationPollIntervalTimeBox = Duration.ofMillis((long)this.backgroundJobServerConfiguration.getPollIntervalInSeconds() * 950L);
        Duration durationRunTime = Duration.between(this.runStartTime, Instant.now());
        return durationRunTime.compareTo(durationPollIntervalTimeBox) >= 0;
    }

    @Override
    public BackgroundJobServerConfiguration getBackgroundJobServerConfiguration() {
        return this.backgroundJobServerConfiguration;
    }

    @Override
    public Instant getRunStartTime() {
        return this.runStartTime;
    }

    public void markRunAsSucceeded() {
        this.runSucceeded = true;
    }

    @Override
    public void close() {
        this.zooKeeperStatistics.logRun(this.runIndex, this.runSucceeded, this.backgroundJobServerConfiguration.getPollIntervalInSeconds(), this.runStartTime, Instant.now());
    }
}

