/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper;

import java.time.Duration;
import java.time.Instant;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.dashboard.DashboardNotificationManager;
import org.jobrunr.server.dashboard.PollIntervalInSecondsTimeBoxIsTooSmallNotification;
import org.jobrunr.server.zookeeper.ZooKeeperRunTaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperStatistics.class);
    private final DashboardNotificationManager dashboardNotificationManager;
    private long runCounter;
    private int exceptionCounter;
    private int runTookToLongCounter;

    public ZooKeeperStatistics(DashboardNotificationManager dashboardNotificationManager) {
        this.dashboardNotificationManager = dashboardNotificationManager;
        this.runCounter = 0L;
        this.exceptionCounter = 0;
        this.runTookToLongCounter = 0;
    }

    public ZooKeeperRunTaskInfo startRun(BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        return new ZooKeeperRunTaskInfo(this, backgroundJobServerConfiguration, ++this.runCounter);
    }

    public void handleException(Exception e) {
        ++this.exceptionCounter;
        this.dashboardNotificationManager.handle(e);
    }

    public boolean hasTooManyExceptions() {
        return this.exceptionCounter > 5;
    }

    void logRun(long runIndex, boolean runSucceeded, int pollIntervalInSeconds, Instant runStartTime, Instant runEndTime) {
        Duration actualRunDuration;
        if (runSucceeded && this.exceptionCounter > 0) {
            --this.exceptionCounter;
        }
        if ((actualRunDuration = Duration.between(runStartTime, runEndTime)).getSeconds() < (long)pollIntervalInSeconds) {
            LOGGER.debug("JobZooKeeper run took {}", (Object)actualRunDuration);
            this.runTookToLongCounter = 0;
        } else {
            LOGGER.debug("JobZooKeeper run took {} (while pollIntervalInSeconds is {})", (Object)actualRunDuration, (Object)pollIntervalInSeconds);
            if (this.runTookToLongCounter < 2) {
                ++this.runTookToLongCounter;
            } else {
                this.dashboardNotificationManager.notify(new PollIntervalInSecondsTimeBoxIsTooSmallNotification(runIndex, pollIntervalInSeconds, runStartTime, (int)actualRunDuration.getSeconds()));
                this.runTookToLongCounter = 0;
            }
        }
    }
}

