/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.zookeeper.tasks;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.strategy.WorkDistributionStrategy;
import org.jobrunr.server.zookeeper.tasks.ZooKeeperTask;
import org.jobrunr.storage.PageRequest;

public class OnboardNewWorkTask
extends ZooKeeperTask {
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final WorkDistributionStrategy workDistributionStrategy;

    public OnboardNewWorkTask(JobZooKeeper jobZooKeeper, BackgroundJobServer backgroundJobServer) {
        super(jobZooKeeper, backgroundJobServer);
        this.workDistributionStrategy = backgroundJobServer.getWorkDistributionStrategy();
    }

    @Override
    protected void runTask() {
        try {
            if (this.backgroundJobServer.isRunning() && this.reentrantLock.tryLock()) {
                LOGGER.trace("Looking for enqueued jobs... ");
                PageRequest workPageRequest = this.workDistributionStrategy.getWorkPageRequest();
                if (workPageRequest.getLimit() > 0) {
                    List<Job> enqueuedJobs = this.storageProvider.getJobs(StateName.ENQUEUED, workPageRequest);
                    enqueuedJobs.forEach(this.backgroundJobServer::processJob);
                    LOGGER.debug("Found {} enqueued jobs to process.", (Object)enqueuedJobs.size());
                }
            }
        }
        finally {
            if (this.reentrantLock.isHeldByCurrentThread()) {
                this.reentrantLock.unlock();
            }
        }
    }
}

